/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.ect.EdiParseException;
import org.milyn.ect.common.XmlTagEncoder;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEdifactMessage {
    private static final String MESSAGE_DEFINITION = "[\\d\\. ]*MESSAGE DEFINITION *";
    private static final String MESSAGE_DEFINITION_START = "^(\\d{4} *| *)[- \\*\\+\\|X]*(([A-Z]{3}),|[S|s]egment [G|g]roup \\d*:)+(.*)";
    private static final String MESSAGE_DEFINITION_END = "([\\d\\.]* *(Data)? *[S|s]egment [I|i]ndex.*)|( *[\\d\\.]+ *[M|m]essage [S|s]tructure.*)";
    private static final Pattern MESSAGE_TYPE = Pattern.compile(".*Message Type *: *(\\w*) *");
    private static final Pattern MESSAGE_RELEASE = Pattern.compile(".*Release *: *(\\w*) *");
    private static final Pattern MESSAGE_AGENCY = Pattern.compile(".*Contr. Agency *: *(\\w*) *");
    private static final Pattern MESSAGE_VERSION = Pattern.compile(".*Version *: *(\\w*) *");
    private static final String SEGMENT_TABLE = "[\\d\\. ]*[S|s]egment [T|t]able *";
    private static final String SEGMENT_TABLE_HEADER = "(Pos *Tag *Name *S *R.*)|( *TAG *NAME *S *REPT *S *REPT)|( *POS *TAG *NAME *S *R *)";
    private static String SEGMENT_REGULAR = "(\\d{4})*[-\\+\\* XS]*(\\w{3}) *(.*) +(M|C|m|c) *(\\d+)[ \\|]*";
    private static String SEGMENT_REGULAR_START = "(\\d{4})*[-\\+\\* XS]*(\\w{3}) *(.*) *\\|";
    private static String SEGMENT_REGULAR_END = " *(.*) +(M|C|m|c) *(\\d*)[ \\|]*";
    private static String SEGMENT_GROUP_START = "(\\d{4})*[-\\+\\* XS]*-* *([S|s]egment [G|g]roup \\d*) *-* +(C|M|c|m) *(\\d*)[ \\-\\+\\|]*";
    private static String SEGMENT_GROUP_END = "(\\d{4})*[-\\+\\* XS]*(\\w{3}) *([\\w /-]*) +(C|M|c|m) *(\\d*) *-+([ |\\+]*)";
    private static final String ANNEX = "(Informative annex:.*)";
    private static final String NEW_LINE = "\n";
    private static final String LEGAL_MESSAGE = "\\s*UN/EDIFACT\\s*";
    private static final String DELIMITER_SEGMENT = "&#39;!$";
    private static final String DELIMITER_COMPOSITE = "+";
    private static final String DELIMITER_DATA = ":";
    private static final String DELIMITER_NOT_USED = "~";
    private static final String ESCAPE = "?";
    private static List<String> ignoreSegments = Arrays.asList("UNA", "UNB", "UNG", "UNH", "UNT", "UNZ", "UNE");
    private String type;
    private String version;
    private String release;
    private String agency;
    private Edimap edimap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnEdifactMessage(Reader reader, boolean isSplitIntoImport, Edimap definitionModel) throws EdiParseException, IOException {
        BufferedReader breader = null;
        try {
            breader = new BufferedReader(reader);
            this.assertLegalMessage(breader);
            this.type = this.getValue(breader, MESSAGE_TYPE);
            this.version = this.getValue(breader, MESSAGE_VERSION);
            this.release = this.getValue(breader, MESSAGE_RELEASE);
            this.agency = this.getValue(breader, MESSAGE_AGENCY);
            this.edimap = new Edimap();
            SegmentGroup rootGroup = new SegmentGroup();
            rootGroup.setXmltag(XmlTagEncoder.encode(this.type));
            this.edimap.setSegments(rootGroup);
            Delimiters delimiters = new Delimiters();
            delimiters.setSegment(DELIMITER_SEGMENT);
            delimiters.setField(DELIMITER_COMPOSITE);
            delimiters.setComponent(DELIMITER_DATA);
            delimiters.setSubComponent(DELIMITER_NOT_USED);
            delimiters.setEscape(ESCAPE);
            this.edimap.setDelimiters(delimiters);
            this.edimap.setDescription(new Description());
            this.edimap.getDescription().setName(this.type);
            this.edimap.getDescription().setVersion(this.version + DELIMITER_DATA + this.release + DELIMITER_DATA + this.agency);
            Map<String, Segment> segmentDefinitions = null;
            if (isSplitIntoImport) {
                Import ediImport = new Import();
                ediImport.setNamespace(this.agency);
                ediImport.setResource(definitionModel.getDescription().getName() + ".xml");
                this.edimap.getImports().add(ediImport);
            } else {
                segmentDefinitions = this.getSegmentDefinitions(definitionModel);
            }
            Map<String, String> definitions = this.parseMessageDefinition(breader);
            this.parseMessageStructure(breader, rootGroup, definitions, isSplitIntoImport, segmentDefinitions);
        }
        finally {
            if (breader != null) {
                breader.close();
            }
        }
    }

    public Edimap getEdimap() {
        return this.edimap;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRelease() {
        return this.release;
    }

    public String getAgency() {
        return this.agency;
    }

    private Map<String, Segment> getSegmentDefinitions(Edimap definitionModel) {
        HashMap<String, Segment> result = new HashMap<String, Segment>();
        for (SegmentGroup segmentGroup : definitionModel.getSegments().getSegments()) {
            result.put(segmentGroup.getSegcode(), (Segment)segmentGroup);
        }
        return result;
    }

    private void assertLegalMessage(BufferedReader reader) throws EdiParseException {
        String line;
        try {
            line = reader.readLine();
            while (line != null && !line.matches(LEGAL_MESSAGE)) {
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new EdiParseException("Error reading first line of UN/EDIFACT message.", e);
        }
        if (line == null) {
            throw new EdiParseException("Not a valid UN/EDIFACT message definition. First line doe not match pattern '\\s*UN/EDIFACT\\s*'.");
        }
    }

    private void parseMessageStructure(BufferedReader reader, SegmentGroup group, Map<String, String> definitions, boolean isSplitIntoImport, Map<String, Segment> segmentDefinitions) throws IOException {
        String line = reader.readLine();
        while (!line.matches(SEGMENT_TABLE)) {
            line = reader.readLine();
        }
        while (!line.matches(SEGMENT_TABLE_HEADER)) {
            line = reader.readLine();
        }
        this.parseNextSegment(reader, group, definitions, isSplitIntoImport, segmentDefinitions, new LineNumber());
    }

    private Map<String, String> parseMessageDefinition(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (!line.toUpperCase().matches(MESSAGE_DEFINITION)) {
            line = reader.readLine();
        }
        line = reader.readLine();
        while (!line.toUpperCase().matches(MESSAGE_DEFINITION)) {
            line = reader.readLine();
        }
        line = reader.readLine();
        while (!line.matches(MESSAGE_DEFINITION_START) || line.length() == 0) {
            line = reader.readLine();
        }
        LineNumber lineNo = new LineNumber();
        HashMap<String, String> definitions = new HashMap<String, String>();
        while (!line.matches(MESSAGE_DEFINITION_END)) {
            if (line.matches(MESSAGE_DEFINITION_START)) {
                Pattern pattern = Pattern.compile(MESSAGE_DEFINITION_START);
                Matcher matcher = pattern.matcher(line);
                matcher.matches();
                String id = this.getLineId(lineNo, matcher.group(1));
                StringBuilder definition = new StringBuilder();
                definition.append(matcher.group(2)).append(NEW_LINE);
                line = reader.readLine();
                while (!line.matches(MESSAGE_DEFINITION_START) && !line.matches(MESSAGE_DEFINITION_END)) {
                    definition.append(line).append(NEW_LINE);
                    line = reader.readLine();
                }
                definitions.put(id, definition.toString());
                continue;
            }
            line = reader.readLine();
        }
        return definitions;
    }

    private int parseNextSegment(BufferedReader reader, SegmentGroup parentGroup, Map<String, String> definitions, boolean isSplitIntoImport, Map<String, Segment> segmentDefinitions, LineNumber lineNo) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            String id;
            Matcher matcher;
            if (line.matches(SEGMENT_GROUP_START)) {
                matcher = Pattern.compile(SEGMENT_GROUP_START).matcher(line);
                matcher.matches();
                id = this.getLineId(lineNo, matcher.group(1));
                SegmentGroup group = this.createGroup(id, matcher.group(2), matcher.group(3), matcher.group(4), definitions);
                parentGroup.getSegments().add(group);
                int result = this.parseNextSegment(reader, group, definitions, isSplitIntoImport, segmentDefinitions, lineNo);
                if (result != 0) {
                    return result - 1;
                }
            } else {
                Segment segment;
                if (line.matches(SEGMENT_GROUP_END)) {
                    matcher = Pattern.compile(SEGMENT_GROUP_END).matcher(line);
                    matcher.matches();
                    id = this.getLineId(lineNo, matcher.group(1));
                    segment = this.createSegment(id, matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), definitions, isSplitIntoImport, segmentDefinitions);
                    parentGroup.getSegments().add(segment);
                    return this.extractPlusCharacter(matcher.group(6)).length() - 1;
                }
                if (line.matches(SEGMENT_REGULAR)) {
                    matcher = Pattern.compile(SEGMENT_REGULAR).matcher(line);
                    matcher.matches();
                    id = this.getLineId(lineNo, matcher.group(1));
                    if (!ignoreSegments.contains(matcher.group(2))) {
                        segment = this.createSegment(id, matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), definitions, isSplitIntoImport, segmentDefinitions);
                        parentGroup.getSegments().add(segment);
                    }
                } else if (!line.trim().equals("") && line.matches(SEGMENT_REGULAR_START)) {
                    matcher = Pattern.compile(SEGMENT_REGULAR_START).matcher(line);
                    matcher.matches();
                    id = this.getLineId(lineNo, matcher.group(1));
                    String segcode = matcher.group(2);
                    String description = matcher.group(3);
                    line = reader.readLine();
                    matcher = Pattern.compile(SEGMENT_REGULAR_END).matcher(line);
                    matcher.matches();
                    description = description + " " + matcher.group(1);
                    if (!ignoreSegments.contains(matcher.group(2))) {
                        Segment segment2 = this.createSegment(id, segcode, description, matcher.group(2), matcher.group(3), definitions, isSplitIntoImport, segmentDefinitions);
                        parentGroup.getSegments().add(segment2);
                    }
                } else if (line.matches(ANNEX)) {
                    return 0;
                }
            }
            line = reader.readLine();
        }
        return 0;
    }

    private String getLineId(LineNumber lineNo, String id) {
        if (id == null || id.trim().equals("")) {
            id = String.valueOf(lineNo.increment());
        }
        return id.trim();
    }

    private String extractPlusCharacter(String value) {
        return value.replaceAll("[^\\+]", "");
    }

    private SegmentGroup createGroup(String id, String name, String mandatory, String maxOccurance, Map<String, String> definitions) {
        SegmentGroup group = new SegmentGroup();
        group.setXmltag(XmlTagEncoder.encode(name.trim()));
        String test = definitions.get(id);
        group.setDocumentation(test.trim());
        group.setMinOccurs(Integer.valueOf(mandatory.equals("M") ? 1 : 0));
        group.setMaxOccurs(Integer.valueOf(maxOccurance));
        return group;
    }

    private Segment createSegment(String id, String segcode, String description, String mandatory, String maxOccurance, Map<String, String> definitions, boolean isSplitIntoImport, Map<String, Segment> segmentDefinitions) {
        Segment segment = new Segment();
        segment.setSegcode(segcode);
        segment.setNodeTypeRef(this.agency + DELIMITER_DATA + segcode);
        if (!isSplitIntoImport) {
            Segment importedSegment = segmentDefinitions.get(segcode);
            if (importedSegment == null) {
                throw new EdiParseException("Unknown segment code '" + segcode + "'.");
            }
            segment.getFields().addAll(importedSegment.getFields());
            if (importedSegment.getSegments().size() > 0) {
                segment.getSegments().addAll(importedSegment.getSegments());
            }
        }
        segment.setXmltag(XmlTagEncoder.encode(description.trim()));
        String test = definitions.get(id);
        segment.setDocumentation(definitions.get(id).trim());
        segment.setMinOccurs(Integer.valueOf(mandatory.equals("M") ? 1 : 0));
        segment.setMaxOccurs(Integer.valueOf(maxOccurance));
        segment.setTruncatable(Boolean.valueOf(true));
        return segment;
    }

    private String getValue(BufferedReader reader, Pattern pattern) throws IOException {
        String line = reader.readLine();
        Matcher matcher = pattern.matcher(line);
        while (!matcher.matches()) {
            line = reader.readLine();
            matcher = pattern.matcher(line);
        }
        return matcher.group(1);
    }

    private class LineNumber {
        private int value = 0;

        private LineNumber() {
        }

        public int getValue() {
            return this.value;
        }

        public int increment() {
            return this.value++;
        }
    }
}

