/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ect.formats.unedifact;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.milyn.ect.EdiParseException;
import org.milyn.ect.EdiSpecificationReader;
import org.milyn.ect.formats.unedifact.UnEdifactDefinitionReader;
import org.milyn.ect.formats.unedifact.UnEdifactMessage;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.unedifact.UNEdifactInterchangeParser;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEdifactSpecificationReader
implements EdiSpecificationReader {
    public static final String INTERCHANGE_TYPE = "UNEDIFACT";
    private static final int BUFFER = 2048;
    private static final String INTERCHANGE_DEFINITION = "un-edifact-interchange-definition.xml";
    private boolean useImport;
    private Map<String, byte[]> definitionFiles;
    private Map<String, byte[]> messageFiles;
    private Edimap definitionModel;

    public UnEdifactSpecificationReader(ZipInputStream specificationInStream, boolean useImport) throws IOException {
        this.useImport = useImport;
        this.definitionFiles = new HashMap<String, byte[]>();
        this.messageFiles = new HashMap<String, byte[]>();
        UnEdifactSpecificationReader.readDefinitionEntries(specificationInStream, new ZipDirectoryEntry("eded.", this.definitionFiles), new ZipDirectoryEntry("edcd.", this.definitionFiles), new ZipDirectoryEntry("edsd.", this.definitionFiles), new ZipDirectoryEntry("edmd.", "*", this.messageFiles));
        this.definitionModel = this.parseEDIDefinitionFiles();
        this.addMissingDefinitions(this.definitionModel);
        try {
            EdifactModel interchangeEnvelope = new EdifactModel(ClassUtil.getResourceAsStream((String)INTERCHANGE_DEFINITION, this.getClass()));
            this.definitionModel.getSegments().getSegments().addAll(interchangeEnvelope.getEdimap().getSegments().getSegments());
        }
        catch (Exception e) {
            throw new EdiParseException(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getMessageNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(this.definitionModel.getDescription().getName());
        names.addAll(this.messageFiles.keySet());
        return names;
    }

    @Override
    public Edimap getMappingModel(String messageName) throws IOException {
        if (messageName.equals(this.definitionModel.getDescription().getName())) {
            return this.definitionModel;
        }
        return this.parseEdiMessage(messageName).getEdimap();
    }

    @Override
    public Properties getInterchangeProperties() {
        Properties properties = new Properties();
        properties.setProperty("interchangeType", INTERCHANGE_TYPE);
        properties.setProperty("messageBindingConfig", "/org/milyn/smooks/edi/unedifact/model/r41/bindings/unedifact-message.xml");
        properties.setProperty("interchangeBindingConfig", "/org/milyn/smooks/edi/unedifact/model/r41/bindings/unedifact-interchange.xml");
        return properties;
    }

    private void addMissingDefinitions(Edimap definitionModel) {
        Segment ugh = new Segment();
        Segment ugt = new Segment();
        ugh.setSegcode("UGH");
        ugh.setXmltag("UGH");
        ugh.addField(new Field("id", Boolean.valueOf(true)));
        ugt.setSegcode("UGT");
        ugt.setXmltag("UGT");
        ugt.addField(new Field("id", Boolean.valueOf(true)));
        definitionModel.getSegments().getSegments().add(ugh);
        definitionModel.getSegments().getSegments().add(ugt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnEdifactMessage parseEdiMessage(String messageName) throws IOException {
        byte[] message = this.messageFiles.get(messageName);
        if (message != null) {
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(message));
            try {
                UnEdifactMessage unEdifactMessage = new UnEdifactMessage(reader, this.useImport, this.definitionModel);
                return unEdifactMessage;
            }
            finally {
                reader.close();
            }
        }
        return null;
    }

    public Edimap getDefinitionModel() throws IOException {
        return this.definitionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Edimap parseEDIDefinitionFiles() throws IOException, EdiParseException {
        Edimap edifactModel;
        Reader dataISR = null;
        Reader compositeISR = null;
        Reader segmentISR = null;
        try {
            dataISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("eded.")));
            compositeISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("edcd.")));
            segmentISR = new InputStreamReader(new ByteArrayInputStream(this.definitionFiles.get("edsd.")));
            edifactModel = UnEdifactDefinitionReader.parse(dataISR, compositeISR, segmentISR);
            edifactModel.setDescription(EDIUtils.MODEL_SET_DEFINITIONS_DESCRIPTION);
            edifactModel.getSegments().setXmltag("DefinitionMap");
            edifactModel.setDelimiters(UNEdifactInterchangeParser.defaultUNEdifactDelimiters);
        }
        finally {
            if (dataISR != null) {
                dataISR.close();
            }
            if (compositeISR != null) {
                compositeISR.close();
            }
            if (segmentISR != null) {
                segmentISR.close();
            }
        }
        return edifactModel;
    }

    private static void readDefinitionEntries(ZipInputStream folderZip, ZipDirectoryEntry ... entries) throws IOException {
        ZipEntry fileEntry = folderZip.getNextEntry();
        while (fileEntry != null) {
            String fName = new File(fileEntry.getName().toLowerCase()).getName().replaceFirst("tr", "ed");
            for (ZipDirectoryEntry entry : entries) {
                int size;
                if (!fName.startsWith(entry.getDirectory())) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((size = folderZip.read(bytes, 0, bytes.length)) != -1) {
                    baos.write(bytes, 0, size);
                }
                ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(baos.toByteArray()));
                UnEdifactSpecificationReader.readZipEntry(entry.getEntries(), zipInputStream, entry.getFile());
                zipInputStream.close();
            }
            folderZip.closeEntry();
            fileEntry = folderZip.getNextEntry();
        }
    }

    private static boolean readZipEntry(Map<String, byte[]> files, ZipInputStream folderZip, String entry) throws IOException {
        boolean result = false;
        ZipEntry fileEntry = folderZip.getNextEntry();
        while (fileEntry != null) {
            String fName = new File(fileEntry.getName().toLowerCase()).getName().replaceFirst("tr", "ed");
            if (fName.startsWith(entry) || entry.equals("*")) {
                int size;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((size = folderZip.read(bytes, 0, bytes.length)) != -1) {
                    UnEdifactSpecificationReader.translatePseudoGraph(bytes);
                    baos.write(bytes, 0, size);
                }
                result = true;
                if (entry.equals("*")) {
                    if (fileEntry.getName().indexOf(95) != -1) {
                        files.put(fName.substring(0, fName.indexOf(95)).toUpperCase(), baos.toByteArray());
                    }
                } else {
                    files.put(entry, baos.toByteArray());
                    break;
                }
            }
            folderZip.closeEntry();
            fileEntry = folderZip.getNextEntry();
        }
        return result;
    }

    private static void translatePseudoGraph(byte[] bytes) {
        int l = bytes.length;
        block5: for (int i = 0; i < l; ++i) {
            switch (bytes[i]) {
                case -60: {
                    bytes[i] = 45;
                    continue block5;
                }
                case -65: 
                case -63: 
                case -39: {
                    bytes[i] = 43;
                    continue block5;
                }
                case -77: {
                    bytes[i] = 124;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipDirectoryEntry {
        private String directory;
        private String file;
        private Map<String, byte[]> entries;

        private ZipDirectoryEntry(String directory, Map<String, byte[]> entries) {
            this(directory, directory, entries);
        }

        public ZipDirectoryEntry(String directory, String file, Map<String, byte[]> entries) {
            this.directory = directory;
            this.file = file;
            this.entries = entries;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getFile() {
            return this.file;
        }

        public Map<String, byte[]> getEntries() {
            return this.entries;
        }
    }
}

