/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.edi;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelLoader
implements ContentHandler {
    @ConfigParam
    private String mappingModel;
    @AppContext
    private ApplicationContext applicationContext;

    @Initialize
    public void initialize() throws EDIConfigurationException, IOException, SAXException {
        Map<Description, EdifactModel> mappingModels = ModelLoader.getMappingModels(this.mappingModel, this.applicationContext, true);
        if (mappingModels.isEmpty()) {
            EDIUtils.loadMappingModels((String)this.mappingModel, mappingModels, (URI)this.applicationContext.getResourceLocator().getBaseURI());
        }
    }

    public static Map<Description, EdifactModel> getMappingModels(String mappingModelKey, ApplicationContext applicationContext) throws EDIConfigurationException {
        return ModelLoader.getMappingModels(mappingModelKey, applicationContext, false);
    }

    private static Map<Description, EdifactModel> getMappingModels(String mappingModelKey, ApplicationContext applicationContext, boolean create) throws EDIConfigurationException {
        HashMap mappingModelMap;
        HashMap modelRegistry = (HashMap)applicationContext.getAttribute(ModelLoader.class);
        if (modelRegistry == null) {
            modelRegistry = new HashMap();
            applicationContext.setAttribute(ModelLoader.class, modelRegistry);
        }
        if ((mappingModelMap = (HashMap)modelRegistry.get(mappingModelKey)) == null) {
            if (!create) {
                throw new EDIConfigurationException("Unable to get EDI Mapping Model Map for '" + mappingModelKey + "'.  Models not bound to ApplicationContext.  ModelLoader should have loaded these models during initialization phase.");
            }
            mappingModelMap = new HashMap();
            modelRegistry.put(mappingModelKey, mappingModelMap);
        }
        return mappingModelMap;
    }
}

