/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.NumberFormat;
import java.text.ParseException;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.NumberDecoder;

@DecodeType(value={Long.class, long.class})
public class LongDecoder
extends NumberDecoder {
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                if (this.isPercentage()) {
                    return (long)(number.doubleValue() * 100.0);
                }
                return number.longValue();
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode Long value '" + data + "' using NumberFormat instance " + format + ".", (Throwable)e);
            }
        }
        try {
            return Long.parseLong(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode Long value '" + data + "'.", (Throwable)e);
        }
    }
}

