/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.util.Collection;
import java.util.HashSet;
import org.milyn.ejc.IllegalNameException;
import org.milyn.javabean.pojogen.JType;

public class EJCUtils {
    private static HashSet<String> reservedKeywords;

    public static String encodeClassName(String name) throws IllegalNameException {
        String result = name;
        if (name.toUpperCase().equals(name)) {
            StringBuilder nameRebuilder = new StringBuilder();
            nameRebuilder.append(name.toLowerCase());
            nameRebuilder.setCharAt(0, name.charAt(0));
            result = nameRebuilder.toString();
        }
        result = EJCUtils.deleteWithPascalNotation(result, '_');
        if (Character.isLowerCase((result = EJCUtils.encodeJavaIdentifier(result)).charAt(0))) {
            result = Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
        EJCUtils.assertLegalName(result);
        return result;
    }

    public static String encodeAttributeName(JType type, String name) throws IllegalNameException {
        String result = EJCUtils.encodeAttributeName(name);
        if (type != null && Collection.class.isAssignableFrom(type.getClass())) {
            result = result + "s";
        }
        return result;
    }

    public static String encodeAttributeName(String name) {
        String result = name.toUpperCase().equals(name) ? name.toLowerCase() : name;
        result = EJCUtils.deleteWithPascalNotation(result, '_');
        if (Character.isUpperCase((result = EJCUtils.encodeJavaIdentifier(result)).charAt(0))) {
            result = Character.toLowerCase(result.charAt(0)) + result.substring(1);
        }
        if (reservedKeywords.contains(result)) {
            result = "_" + result;
        }
        return result;
    }

    public static String encodeJavaIdentifier(String identifier) {
        StringBuilder result = new StringBuilder();
        int len = identifier.length();
        boolean matchPrevious = false;
        for (int i = 0; i < len; ++i) {
            char currentChar = identifier.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(currentChar)) {
                result.append('_');
            }
            if (!Character.isJavaIdentifierPart(currentChar)) {
                matchPrevious = true;
                continue;
            }
            if (matchPrevious) {
                currentChar = Character.toUpperCase(currentChar);
                matchPrevious = false;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public static String deleteWithPascalNotation(String value, char deleteChar) {
        StringBuilder result = new StringBuilder();
        boolean matchPrevious = false;
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (currentChar == deleteChar) {
                matchPrevious = true;
                continue;
            }
            if (matchPrevious) {
                currentChar = Character.toUpperCase(currentChar);
                matchPrevious = false;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    private static void assertLegalName(String name) throws IllegalNameException {
        if (reservedKeywords.contains(name)) {
            throw new IllegalNameException("Illegal attribute- or class-name. The name [" + name + "] is a reserved keyword in java.");
        }
    }

    static {
        String[] words;
        reservedKeywords = new HashSet();
        for (String w : words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"}) {
            reservedKeywords.add(w);
        }
    }
}

