/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.fixedlength.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.milyn.FilterSettings;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.assertion.AssertArgument;
import org.milyn.fixedlength.FixedLengthBinding;
import org.milyn.fixedlength.FixedLengthBindingType;
import org.milyn.fixedlength.FixedLengthReaderConfigurator;
import org.milyn.payload.JavaResult;

public class FixedLengthListBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public FixedLengthListBinder(String fields, Class recordType) {
        AssertArgument.isNotNullAndNotEmpty((String)fields, (String)"fields");
        AssertArgument.isNotNull((Object)recordType, (String)"recordType");
        this.smooks = new Smooks();
        this.smooks.setFilterSettings(FilterSettings.DEFAULT_SAX);
        this.smooks.setReaderConfig((ReaderConfigurator)new FixedLengthReaderConfigurator(fields).setBinding(new FixedLengthBinding(this.beanId, recordType, FixedLengthBindingType.LIST)));
    }

    public List bind(Reader fixedLengthStream) {
        AssertArgument.isNotNull((Object)fixedLengthStream, (String)"fixedLengthStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource((Source)new StreamSource(fixedLengthStream), new Result[]{javaResult});
        return (List)javaResult.getBean(this.beanId);
    }

    public List bind(InputStream fixedLengthStream) {
        return this.bind(new InputStreamReader(fixedLengthStream));
    }
}

