/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BeanUtils;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.w3c.dom.Element;

@VisitBeforeReport(summary="Created <b>${resource.parameters.beanId!'undefined'}</b> bean instance.  Associated lifecycle if wired to another bean.", detailTemplate="reporting/BeanInstanceCreatorReport_Before.html")
@VisitAfterReport(condition="parameters.containsKey('setOn') || parameters.beanClass.value.endsWith('[]')", summary="Ended bean lifecycle. Set bean on any targets.", detailTemplate="reporting/BeanInstanceCreatorReport_After.html")
public class BeanInstanceCreator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter {
    private static Log logger = LogFactory.getLog(BeanInstanceCreator.class);
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="beanClass")
    private String beanClassName;
    @AppContext
    private ApplicationContext appContext;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanRepositoryManager beanRepositoryManager;
    private BeanId beanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.buildId();
        this.beanRepositoryManager = BeanRepositoryManager.getInstance(this.appContext);
        BeanIdRegister beanIdRegister = this.beanRepositoryManager.getBeanIdRegister();
        this.beanId = beanIdRegister.register(this.beanIdName);
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.beanClassName, this.appContext);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BeanInstanceCreator created for [" + this.beanIdName + "]."));
        }
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstanceCreator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.createAndSetBean(executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.createAndSetBean(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.visitAfter(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.visitAfter(executionContext);
    }

    public void visitAfter(ExecutionContext executionContext) {
        boolean isBeanTypeArray;
        BeanRuntimeInfo.Classification thisBeanType = this.beanRuntimeInfo.getClassification();
        boolean bl = isBeanTypeArray = thisBeanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION;
        if (isBeanTypeArray) {
            Object bean = BeanRepositoryManager.getBeanRepository(executionContext).getBean(this.beanId);
            bean = this.convert(executionContext, bean);
        }
    }

    private Object convert(ExecutionContext executionContext, Object bean) {
        bean = BeanUtils.convertListToArray((List)bean, this.beanRuntimeInfo.getArrayType());
        BeanRepositoryManager.getBeanRepository(executionContext).changeBean(this.beanId, bean);
        return bean;
    }

    private void createAndSetBean(ExecutionContext executionContext) {
        Object bean = this.createBeanInstance();
        BeanRepositoryManager.getBeanRepository(executionContext).addBean(this.beanId, bean);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean [" + this.beanIdName + "] instance created."));
        }
    }

    private Object createBeanInstance() {
        Object bean;
        try {
            bean = this.beanRuntimeInfo.getPopulateType().newInstance();
        }
        catch (InstantiationException e) {
            throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
        }
        return bean;
    }

    private String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }
}

