/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.BeanPopulator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BeanUtils;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleObserver;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(condition="parameters.containsKey('wireBeanIdName')", summary="Create bean lifecycle observer for bean <b>${resource.parameters.wireBeanId!'undefined'}</b>.", detailTemplate="reporting/BeanInstancePopulatorReport_Before.html")
@VisitAfterReport(condition="!parameters.containsKey('wireBeanIdName')", summary="Populating <b>${resource.parameters.beanId}</b> with a value from this element.", detailTemplate="reporting/BeanInstancePopulatorReport_After.html")
public class BeanInstancePopulator
implements DOMElementVisitor,
SAXElementVisitor {
    private static Log logger = LogFactory.getLog(BeanInstancePopulator.class);
    private static String EC_DEFAULT_EXTEND_LIFECYCLE = BeanInstancePopulator.class + "#" + BeanPopulator.GLOBAL_DEFAULT_EXTEND_LIFECYCLE;
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="wireBeanId", defaultVal="##NULL")
    private String wireBeanIdName;
    @ConfigParam(defaultVal="##NULL")
    private MVELExpressionEvaluator expression;
    @ConfigParam(defaultVal="##NULL")
    private String property;
    @ConfigParam(defaultVal="##NULL")
    private String setterMethod;
    @ConfigParam(defaultVal="##NULL")
    private String valueAttributeName;
    @ConfigParam(name="type", defaultVal="##NULL")
    private String typeAlias;
    @ConfigParam(name="default", defaultVal="##NULL")
    private String defaultVal;
    @ConfigParam(defaultVal="##NULL")
    private Boolean extendLifecycle;
    @AppContext
    private ApplicationContext appContext;
    private BeanRepositoryManager beanRepositoryManager;
    private BeanId beanId;
    private BeanId wireBeanId;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanRuntimeInfo wiredBeanRuntimeInfo;
    private Method propertySetterMethod;
    private boolean checkedForSetterMethod;
    private boolean isAttribute = true;
    private DataDecoder decoder;
    private String mapKeyAttribute;
    private boolean beanWiring;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.buildId();
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.appContext);
        this.beanWiring = this.wireBeanIdName != null;
        this.isAttribute = this.valueAttributeName != null;
        this.beanRepositoryManager = BeanRepositoryManager.getInstance(this.appContext);
        BeanIdRegister beanIdRegister = this.beanRepositoryManager.getBeanIdRegister();
        this.beanId = beanIdRegister.getBeanId(this.beanIdName);
        if (this.setterMethod == null && this.property == null) {
            if (this.beanWiring && (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION || this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION)) {
                this.property = this.wireBeanIdName;
            } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION) {
                throw new SmooksConfigurationException("Binding configuration for beanIdName='" + this.beanIdName + "' must contain " + "either a 'property' or 'setterMethod' attribute definition, unless the target bean is a Collection/Array." + "  Bean is type '" + this.beanRuntimeInfo.getPopulateType().getName() + "'.");
            }
        }
        if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION && this.property != null) {
            this.property = this.property.trim();
            if (this.property.length() > 1 && this.property.charAt(0) == '@') {
                this.mapKeyAttribute = this.property.substring(1);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean Instance Populator created for [" + this.beanIdName + "].  property=" + this.property));
        }
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstancePopulator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        if (this.property != null) {
            idBuilder.append("#").append(this.property);
        }
        if (this.setterMethod != null) {
            idBuilder.append("#").append(this.setterMethod).append("()");
        }
        if (this.wireBeanIdName != null) {
            idBuilder.append("#").append(this.wireBeanIdName);
        }
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.checkBeanExists(executionContext);
        if (this.beanWiring) {
            this.bindBeanValue(executionContext);
        } else if (this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.checkBeanExists(executionContext);
        if (!this.beanWiring && !this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
        if (this.beanWiring) {
            this.extendLifecycle(executionContext);
        }
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.checkBeanExists(executionContext);
        if (this.beanWiring) {
            this.bindBeanValue(executionContext);
        } else if (!this.beanWiring && !this.isAttribute) {
            element.setCache((Object)new TrackedStringWriter());
        } else if (this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
    }

    public void onChildText(SAXElement element, SAXText childText, ExecutionContext executionContext) throws SmooksException, IOException {
        if (!this.beanWiring && !this.isAttribute) {
            childText.toWriter((Writer)element.getCache());
        }
    }

    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.checkBeanExists(executionContext);
        if (!this.beanWiring && !this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
        if (this.beanWiring) {
            this.extendLifecycle(executionContext);
        }
    }

    private void checkBeanExists(ExecutionContext executionContext) {
        BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
        if (beanRepository.getBean(this.beanId) == null) {
            throw new SmooksConfigurationException("Can't populate object '" + this.beanRuntimeInfo.getPopulateType().getName() + "' with bean id '" + this.beanId + "' because there is no object in the bean context under that bean id.");
        }
    }

    private void bindDomDataValue(Element element, ExecutionContext executionContext) {
        String mapPropertyName;
        String dataString = this.isAttribute ? DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName) : DomUtils.getAllText((Element)element, (boolean)false);
        if (this.mapKeyAttribute != null) {
            mapPropertyName = DomUtils.getAttributeValue((Element)element, (String)this.mapKeyAttribute);
            if (mapPropertyName == null) {
                mapPropertyName = DomUtils.getName((Element)element);
            }
        } else {
            mapPropertyName = this.property != null ? this.property : DomUtils.getName((Element)element);
        }
        if (this.expression != null) {
            this.bindExpressionValue(mapPropertyName, executionContext);
        } else {
            this.populateAndSetPropertyValue(mapPropertyName, dataString, executionContext);
        }
    }

    private void bindSaxDataValue(SAXElement element, ExecutionContext executionContext) {
        String mapPropertyName;
        String dataString = this.isAttribute ? SAXUtil.getAttribute((String)this.valueAttributeName, (Attributes)element.getAttributes()) : element.getCache().toString();
        if (this.mapKeyAttribute != null) {
            mapPropertyName = SAXUtil.getAttribute((String)this.mapKeyAttribute, (Attributes)element.getAttributes(), null);
            if (mapPropertyName == null) {
                mapPropertyName = element.getName().getLocalPart();
            }
        } else {
            mapPropertyName = this.property != null ? this.property : element.getName().getLocalPart();
        }
        if (this.expression != null) {
            this.bindExpressionValue(mapPropertyName, executionContext);
        } else {
            this.populateAndSetPropertyValue(mapPropertyName, dataString, executionContext);
        }
    }

    private BeanId getWireBeanId() {
        if (this.wireBeanId == null) {
            this.wireBeanId = this.beanRepositoryManager.getBeanIdRegister().getBeanId(this.wireBeanIdName);
        }
        if (this.wireBeanId == null) {
            this.wireBeanId = this.beanRepositoryManager.getBeanIdRegister().register(this.wireBeanIdName);
        }
        return this.wireBeanId;
    }

    private void bindBeanValue(final ExecutionContext executionContext) {
        final BeanId targetBeanId = this.getWireBeanId();
        final BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
        Object bean = beanRepository.getBean(targetBeanId);
        if (bean == null) {
            beanRepository.addBeanLifecycleObserver(targetBeanId, BeanLifecycle.BEGIN, this.getId(), false, new BeanRepositoryLifecycleObserver(){

                public void onBeanLifecycleEvent(BeanRepositoryLifecycleEvent event) {
                    BeanRuntimeInfo wiredBeanRI = BeanInstancePopulator.this.getWiredBeanRuntimeInfo();
                    beanRepository.associateLifecycles(BeanInstancePopulator.this.beanId, targetBeanId);
                    if (wiredBeanRI != null && wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
                        beanRepository.addBeanLifecycleObserver(targetBeanId, BeanLifecycle.CHANGE, BeanInstancePopulator.this.getId(), true, new BeanRepositoryLifecycleObserver(){

                            public void onBeanLifecycleEvent(BeanRepositoryLifecycleEvent event) {
                                BeanInstancePopulator.this.populateAndSetPropertyValue(BeanInstancePopulator.this.property, event.getBean(), executionContext);
                            }
                        });
                    } else {
                        BeanInstancePopulator.this.populateAndSetPropertyValue(BeanInstancePopulator.this.property, event.getBean(), executionContext);
                    }
                }
            });
        } else {
            this.populateAndSetPropertyValue(this.property, bean, executionContext);
        }
    }

    private void extendLifecycle(ExecutionContext executionContext) {
        Boolean doExtendLifecycle = this.extendLifecycle;
        if (doExtendLifecycle == null) {
            doExtendLifecycle = this.isDefaultExtendLifecycle(executionContext);
        }
        if (!doExtendLifecycle.booleanValue()) {
            BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
            beanRepository.removeBeanLifecycleObserver(this.getWireBeanId(), BeanLifecycle.BEGIN, this.getId());
        }
    }

    private boolean isDefaultExtendLifecycle(ExecutionContext executionContext) {
        Boolean defaultExtendLifecycle = (Boolean)executionContext.getAttribute((Object)EC_DEFAULT_EXTEND_LIFECYCLE);
        if (defaultExtendLifecycle == null) {
            String wireAfterElementStr = executionContext.getConfigParameter(BeanPopulator.GLOBAL_DEFAULT_EXTEND_LIFECYCLE, "false");
            defaultExtendLifecycle = Boolean.parseBoolean(wireAfterElementStr.trim());
            executionContext.setAttribute((Object)EC_DEFAULT_EXTEND_LIFECYCLE, (Object)defaultExtendLifecycle);
        }
        return defaultExtendLifecycle;
    }

    private void bindExpressionValue(String mapPropertyName, ExecutionContext executionContext) {
        Map<String, Object> beanMap = BeanRepositoryManager.getBeanRepository(executionContext).getBeanMap();
        Object dataObject = this.expression.getValue(beanMap);
        if (dataObject instanceof String) {
            this.populateAndSetPropertyValue(mapPropertyName, (String)dataObject, executionContext);
        } else {
            this.populateAndSetPropertyValue(mapPropertyName, dataObject, executionContext);
        }
    }

    private void populateAndSetPropertyValue(String mapPropertyName, String dataString, ExecutionContext executionContext) {
        Object dataObject = this.decodeDataString(dataString, executionContext);
        this.populateAndSetPropertyValue(mapPropertyName, dataObject, executionContext);
    }

    private void populateAndSetPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext) {
        if (dataObject == null) {
            return;
        }
        Object bean = BeanRepositoryManager.getBeanRepository(executionContext).getBean(this.beanId);
        BeanRuntimeInfo.Classification beanType = this.beanRuntimeInfo.getClassification();
        this.createPropertySetterMethod(bean, dataObject.getClass());
        try {
            if (this.propertySetterMethod != null) {
                this.propertySetterMethod.invoke(bean, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.MAP_COLLECTION) {
                ((Map)bean).put(mapPropertyName, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION || beanType == BeanRuntimeInfo.Classification.COLLECTION_COLLECTION) {
                ((Collection)bean).add(dataObject);
            } else if (this.propertySetterMethod == null) {
                if (this.setterMethod != null) {
                    throw new SmooksConfigurationException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + this.setterMethod + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
                if (this.property != null) {
                    throw new SmooksConfigurationException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + BeanUtils.toSetterName(this.property) + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + BeanUtils.toSetterName(this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + BeanUtils.toSetterName(this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
    }

    private void createPropertySetterMethod(Object bean, Class<?> parameter) {
        if (!this.checkedForSetterMethod && this.propertySetterMethod == null) {
            String methodName = null;
            if (this.setterMethod != null && !this.setterMethod.trim().equals("")) {
                methodName = this.setterMethod;
            } else if (this.property != null && !this.property.trim().equals("")) {
                methodName = BeanUtils.toSetterName(this.property);
            }
            if (methodName != null) {
                this.propertySetterMethod = this.createPropertySetterMethod(bean, methodName, parameter);
            }
            this.checkedForSetterMethod = true;
        }
    }

    private synchronized Method createPropertySetterMethod(Object bean, String setterName, Class<?> setterParamType) {
        if (this.propertySetterMethod == null) {
            this.propertySetterMethod = BeanUtils.createSetterMethod(setterName, bean, setterParamType);
        }
        return this.propertySetterMethod;
    }

    private Object decodeDataString(String dataString, ExecutionContext executionContext) throws DataDecodeException {
        if ((dataString == null || dataString.equals("")) && this.defaultVal != null) {
            if (this.defaultVal.equals("null")) {
                return null;
            }
            dataString = this.defaultVal;
        }
        if (this.decoder == null) {
            this.decoder = this.getDecoder(executionContext);
        }
        return this.decoder.decode(dataString);
    }

    private DataDecoder getDecoder(ExecutionContext executionContext) throws DataDecodeException {
        List decoders = executionContext.getDeliveryConfig().getObjects("decoder:" + this.typeAlias);
        if (decoders == null || decoders.isEmpty()) {
            this.decoder = DataDecoder.Factory.create((String)this.typeAlias);
        } else {
            if (!(decoders.get(0) instanceof DataDecoder)) {
                throw new DataDecodeException("Configured decoder '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + DataDecoder.class.getName());
            }
            this.decoder = (DataDecoder)decoders.get(0);
        }
        return this.decoder;
    }

    private BeanRuntimeInfo getWiredBeanRuntimeInfo() {
        if (this.wiredBeanRuntimeInfo == null) {
            this.wiredBeanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.wireBeanIdName, this.appContext);
        }
        return this.wiredBeanRuntimeInfo;
    }

    private String getId() {
        return this.id;
    }

    public static class TrackedStringWriter
    extends StringWriter {
        private char[] lastWriteBuf;
        private int lastWriteOff;
        private int lastWriteLen;
        private List<WriteRecord> writeTrackingList;

        public void write(char[] cbuf, int off, int len) {
            if (cbuf == this.lastWriteBuf && off == this.lastWriteOff && len == this.lastWriteLen) {
                return;
            }
            if (this.lastWriteBuf != null) {
                if (this.writeTrackingList == null) {
                    this.writeTrackingList = new ArrayList<WriteRecord>();
                } else if (this.isAlreadyWritten(cbuf, off, len)) {
                    return;
                }
                this.writeTrackingList.add(new WriteRecord(this.lastWriteBuf, this.lastWriteOff, this.lastWriteLen));
            }
            super.write(cbuf, off, len);
            this.lastWriteBuf = cbuf;
            this.lastWriteOff = off;
            this.lastWriteLen = len;
        }

        private boolean isAlreadyWritten(char[] cbuf, int off, int len) {
            int trackListLen = this.writeTrackingList.size();
            for (int i = 0; i < trackListLen; ++i) {
                WriteRecord listEntry = this.writeTrackingList.get(i);
                if (cbuf != listEntry.lastWriteBuf || off != listEntry.lastWriteOff || len != listEntry.lastWriteLen) continue;
                return true;
            }
            return false;
        }

        private class WriteRecord {
            private char[] lastWriteBuf;
            private int lastWriteOff;
            private int lastWriteLen;

            private WriteRecord(char[] lastWriteBuf, int lastWriteOff, int lastWriteLen) {
                this.lastWriteBuf = lastWriteBuf;
                this.lastWriteOff = lastWriteOff;
                this.lastWriteLen = lastWriteLen;
            }
        }
    }
}

