/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.container.ApplicationContext;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRuntimeInfo {
    private static final String CONTEXT_KEY = BeanRuntimeInfo.class.getName() + "#CONTEXT_KEY";
    private Class<?> populateType;
    private Classification classification;
    private Class<?> arrayType;

    public BeanRuntimeInfo() {
    }

    public BeanRuntimeInfo(String classname) {
        this.resolveBeanRuntimeInfo(classname);
    }

    public static void recordBeanRuntimeInfo(String beanId, BeanRuntimeInfo beanRuntimeInfo, ApplicationContext appContext) {
        Map<String, BeanRuntimeInfo> runtimeInfoMap = BeanRuntimeInfo.getRuntimeInfoMap(appContext);
        BeanRuntimeInfo existingBeanConfig = runtimeInfoMap.get(beanId);
        if (existingBeanConfig != null && !beanRuntimeInfo.equals(existingBeanConfig)) {
            throw new SmooksConfigurationException("Multiple configurations present with beanId='" + beanId + "', but the bean runtime infos are not equal i.e bean classes etc are different.  Use a different beanId and the 'setOnMethod' config if needed.");
        }
        runtimeInfoMap.put(beanId, beanRuntimeInfo);
    }

    public static BeanRuntimeInfo getBeanRuntimeInfo(String beanId, ApplicationContext appContext) {
        Map<String, BeanRuntimeInfo> runtimeInfoMap = BeanRuntimeInfo.getRuntimeInfoMap(appContext);
        return runtimeInfoMap.get(beanId);
    }

    public static BeanRuntimeInfo getBeanRuntimeInfo(String beanId, String beanClassName, ApplicationContext appContext) {
        Map<String, BeanRuntimeInfo> runtimeInfoMap = BeanRuntimeInfo.getRuntimeInfoMap(appContext);
        BeanRuntimeInfo beanRuntimeInfo = runtimeInfoMap.get(beanId);
        if (beanRuntimeInfo == null) {
            beanRuntimeInfo = new BeanRuntimeInfo(beanClassName);
            BeanRuntimeInfo.recordBeanRuntimeInfo(beanId, beanRuntimeInfo, appContext);
        }
        return beanRuntimeInfo;
    }

    private void resolveBeanRuntimeInfo(String beanClass) {
        if (beanClass.endsWith("[]")) {
            this.setClassification(Classification.ARRAY_COLLECTION);
            String arrayTypeName = beanClass.substring(0, beanClass.length() - 2);
            try {
                this.setArrayType(ClassUtil.forName((String)arrayTypeName, this.getClass()));
            }
            catch (ClassNotFoundException e) {
                throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + arrayTypeName + " not on classpath.");
            }
            this.setPopulateType(ArrayList.class);
        } else {
            Class clazz;
            try {
                clazz = ClassUtil.forName((String)beanClass, this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + beanClass + " not on classpath.");
            }
            this.setPopulateType(clazz);
            if (Map.class.isAssignableFrom(clazz)) {
                this.setClassification(Classification.MAP_COLLECTION);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                this.setClassification(Classification.COLLECTION_COLLECTION);
            } else {
                this.setClassification(Classification.NON_COLLECTION);
            }
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + beanClass + " doesn't have a public default constructor.");
            }
        }
    }

    private static Map<String, BeanRuntimeInfo> getRuntimeInfoMap(ApplicationContext appContext) {
        HashMap runtimeInfoMap = (HashMap)appContext.getAttribute((Object)CONTEXT_KEY);
        if (runtimeInfoMap == null) {
            runtimeInfoMap = new HashMap();
            appContext.setAttribute((Object)CONTEXT_KEY, runtimeInfoMap);
        }
        return runtimeInfoMap;
    }

    public Class<?> getPopulateType() {
        return this.populateType;
    }

    public void setPopulateType(Class<?> populateType) {
        this.populateType = populateType;
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    public Class<?> getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(Class<?> arrayType) {
        this.arrayType = arrayType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeanRuntimeInfo)) {
            return false;
        }
        BeanRuntimeInfo beanInfo = (BeanRuntimeInfo)obj;
        if (beanInfo.getArrayType() != this.getArrayType()) {
            return false;
        }
        if (beanInfo.getClassification() != this.getClassification()) {
            return false;
        }
        return beanInfo.getPopulateType() == this.getPopulateType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Classification {
        NON_COLLECTION,
        ARRAY_COLLECTION,
        COLLECTION_COLLECTION,
        MAP_COLLECTION;

    }
}

