/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.repository.BeanRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanUtils {
    private static Log logger = LogFactory.getLog(BeanUtils.class);
    public static final String JAVABEAN_NAMESPACE = "http://www.milyn.org/xsd/smooks/javabean-1.1.xsd";

    public static Method createSetterMethod(String setterName, Object bean, Class<?> setterParamType) {
        String setterNamePlural;
        Method beanSetterMethod = BeanUtils.getMethod(setterName, bean, setterParamType);
        if (beanSetterMethod != null || !List.class.isAssignableFrom(setterParamType) || (beanSetterMethod = BeanUtils.getMethod(setterNamePlural = setterName + "s", bean, setterParamType)) == null) {
            // empty if block
        }
        if (beanSetterMethod == null && Integer.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Integer.TYPE);
        }
        if (beanSetterMethod == null && Long.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Long.TYPE);
        }
        if (beanSetterMethod == null && Float.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Float.TYPE);
        }
        if (beanSetterMethod == null && Double.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Double.TYPE);
        }
        if (beanSetterMethod == null && Character.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Character.TYPE);
        }
        if (beanSetterMethod == null && Short.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Short.TYPE);
        }
        if (beanSetterMethod == null && Byte.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Byte.TYPE);
        }
        if (beanSetterMethod == null && Boolean.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = BeanUtils.getMethod(setterName, bean, Boolean.TYPE);
        }
        return beanSetterMethod;
    }

    private static Method getMethod(String setterName, Object bean, Class<?> setterParamType) {
        Method[] methods = bean.getClass().getMethods();
        Method beanSetterMethod = null;
        for (Method method : methods) {
            Class<?>[] params;
            if (!method.getName().equals(setterName) || (params = method.getParameterTypes()) == null || params.length != 1 || !params[0].isAssignableFrom(setterParamType)) continue;
            beanSetterMethod = method;
            break;
        }
        return beanSetterMethod;
    }

    public static String toSetterName(String property) {
        StringBuffer setterName = new StringBuffer();
        setterName.append(property);
        setterName.setCharAt(0, Character.toUpperCase(property.charAt(0)));
        setterName.insert(0, "set");
        return setterName.toString();
    }

    public static Object getBean(String beanId, ExecutionContext execContext) {
        Object bean = BeanRepositoryManager.getBeanRepository(execContext).getBean(beanId);
        if (bean == null) {
            throw new SmooksConfigurationException("Bean instance [" + beanId + "] not available and bean runtime class not set on configuration.");
        }
        return bean;
    }

    public static Object convertListToArray(List<?> list, Class<?> arrayClass) {
        AssertArgument.isNotNull(list, (String)"list");
        AssertArgument.isNotNull(arrayClass, (String)"arrayClass");
        int length = list.size();
        Object arrayObj = Array.newInstance(arrayClass, list.size());
        for (int i = 0; i < length; ++i) {
            try {
                Array.set(arrayObj, i, list.get(i));
                continue;
            }
            catch (ClassCastException e) {
                logger.error((Object)("Failed to cast type '" + list.get(i).getClass().getName() + "' to '" + arrayClass.getName() + "'."), (Throwable)e);
            }
        }
        return arrayObj;
    }
}

