/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.lifecycle.BeanLifecycleSubjectGroup;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleObserver;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRepository {
    private final ExecutionContext executionContext;
    private final Map<String, Object> beanMap;
    private final ArrayList<RepositoryEntry> repositoryEntries;
    private final BeanIdRegister beanIdRegister;
    private final RepositoryBeanMapAdapter repositoryBeanMapAdapter = new RepositoryBeanMapAdapter();

    public BeanRepository(ExecutionContext executionContext, BeanIdRegister beanIdList, Map<String, Object> beanMap) {
        this.executionContext = executionContext;
        this.beanIdRegister = beanIdList;
        this.beanMap = beanMap;
        this.repositoryEntries = new ArrayList(beanIdList.size());
        this.updateBeanMap();
    }

    public static BeanRepository getInstance(ExecutionContext executionContext) {
        return BeanRepositoryManager.getBeanRepository(executionContext);
    }

    public void addBean(BeanId beanId, Object bean) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        this.checkUpdatedBeanIdList();
        int index = beanId.getIndex();
        this.cleanAssociatedLifecycleBeans(index);
        this.repositoryEntries.get(index).setValue(bean);
        this.notifyObservers(beanId, BeanLifecycle.BEGIN, bean);
    }

    public void addBean(String beanId, Object bean) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        this.addBean(this.getBeanId(beanId), bean);
    }

    public BeanId getBeanId(String beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        BeanId beanIdObj = this.beanIdRegister.getBeanId(beanId);
        if (beanIdObj == null) {
            beanIdObj = this.beanIdRegister.register(beanId);
        }
        return beanIdObj;
    }

    public boolean containsBean(BeanId beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        int index = beanId.getIndex();
        return this.repositoryEntries.size() > index && this.repositoryEntries.get(index).getValue() != null;
    }

    public Object getBean(BeanId beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        int index = beanId.getIndex();
        if (this.repositoryEntries.size() <= index) {
            return null;
        }
        return this.repositoryEntries.get(index).getValue();
    }

    public void changeBean(BeanId beanId, Object bean) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        int index = beanId.getIndex();
        if (this.repositoryEntries.size() <= index || this.repositoryEntries.get(index).getValue() == null) {
            throw new IllegalStateException("The bean '" + beanId + "' can't be changed because it isn't in the repository.");
        }
        this.repositoryEntries.get(index).setValue(bean);
        this.notifyObservers(beanId, BeanLifecycle.CHANGE, bean);
    }

    public Object removeBean(BeanId beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        Object old = this.getBean(beanId);
        this.removeBean(beanId.getIndex());
        return old;
    }

    public void clear() {
        for (RepositoryEntry entry : this.repositoryEntries) {
            entry.setValue(null);
        }
    }

    public void associateLifecycles(BeanId parentBeanId, BeanId childBeanId) {
        AssertArgument.isNotNull((Object)parentBeanId, (String)"parentBeanId");
        AssertArgument.isNotNull((Object)childBeanId, (String)"childBeanId");
        this.checkUpdatedBeanIdList();
        int parentId = parentBeanId.getIndex();
        int childId = childBeanId.getIndex();
        List<Integer> associations = this.repositoryEntries.get(parentId).getLifecycleAssociation();
        if (!associations.contains(childId)) {
            associations.add(childId);
        }
    }

    public void addBeanLifecycleObserver(BeanId beanId, BeanLifecycle lifecycle, String observerId, boolean notifyOnce, BeanRepositoryLifecycleObserver observer) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        BeanLifecycleSubjectGroup subjectGroup = this.getBeanLifecycleSubjectGroup(beanId, true);
        subjectGroup.addObserver(lifecycle, observerId, notifyOnce, observer);
    }

    public void removeBeanLifecycleObserver(BeanId beanId, BeanLifecycle lifecycle, String observerId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        BeanLifecycleSubjectGroup subjectGroup = this.getBeanLifecycleSubjectGroup(beanId, false);
        if (subjectGroup != null) {
            subjectGroup.removeObserver(lifecycle, observerId);
        }
    }

    public Object getBean(String beanId) {
        return this.beanMap.get(beanId);
    }

    public Map<String, Object> getBeanMap() {
        return this.repositoryBeanMapAdapter;
    }

    private void checkUpdatedBeanIdList() {
        if (this.repositoryEntries.size() != this.beanIdRegister.size()) {
            this.updateBeanMap();
        }
    }

    private void updateBeanMap() {
        for (String beanId : this.beanIdRegister.getBeanIdMap().keySet()) {
            if (this.beanMap.containsKey(beanId)) continue;
            this.beanMap.put(beanId, null);
        }
        this.updateRepositoryEntries();
    }

    private void updateRepositoryEntries() {
        this.repositoryEntries.addAll(Collections.nCopies(this.beanIdRegister.size() - this.repositoryEntries.size(), null));
        for (Map.Entry<String, Object> beanMapEntry : this.beanMap.entrySet()) {
            BeanId beanId = this.beanIdRegister.getBeanId(beanMapEntry.getKey());
            int index = beanId.getIndex();
            if (this.repositoryEntries.get(index) != null) continue;
            this.repositoryEntries.set(index, new RepositoryEntry(beanId, beanMapEntry));
        }
    }

    private void removeBean(int index) {
        this.cleanAssociatedLifecycleBeans(index);
        this.repositoryEntries.get(index).setValue(null);
    }

    private void cleanAssociatedLifecycleBeans(int parentId) {
        RepositoryEntry repositoryEntry = this.repositoryEntries.get(parentId);
        List<Integer> associations = repositoryEntry.getLifecycleAssociation();
        if (associations.size() > 0) {
            for (Integer associationId : associations) {
                this.removeBean(associationId);
            }
            repositoryEntry.getLifecycleAssociation().clear();
        }
    }

    private void notifyObservers(BeanId beanId, BeanLifecycle lifecycle, Object bean) {
        BeanLifecycleSubjectGroup subjectGroup = this.getBeanLifecycleSubjectGroup(beanId, false);
        if (subjectGroup != null) {
            subjectGroup.notifyObservers(lifecycle, bean);
        }
    }

    private BeanLifecycleSubjectGroup getBeanLifecycleSubjectGroup(BeanId beanId, boolean createIfNotExist) {
        this.checkUpdatedBeanIdList();
        RepositoryEntry repositoryEntry = this.repositoryEntries.get(beanId.getIndex());
        BeanLifecycleSubjectGroup subjectGroup = repositoryEntry.getBeanLifecycleSubjectGroup();
        if (subjectGroup == null && createIfNotExist) {
            subjectGroup = new BeanLifecycleSubjectGroup(this.executionContext, beanId);
            repositoryEntry.setBeanLifecycleSubjectGroup(subjectGroup);
        }
        return subjectGroup;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("beanMap", this.beanMap, true).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RepositoryBeanMapAdapter
    implements Map<String, Object> {
        private RepositoryBeanMapAdapter() {
        }

        @Override
        public void clear() {
            BeanRepository.this.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return BeanRepository.this.beanMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return BeanRepository.this.beanMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.unmodifiableSet(BeanRepository.this.beanMap.entrySet());
        }

        @Override
        public Object get(Object key) {
            return BeanRepository.this.beanMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return BeanRepository.this.beanMap.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return BeanRepository.this.beanMap.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            AssertArgument.isNotNull((Object)key, (String)"key");
            BeanId beanId = BeanRepository.this.beanIdRegister.getBeanId(key);
            Object old = null;
            if (beanId == null) {
                beanId = BeanRepository.this.beanIdRegister.register(key);
            } else {
                old = BeanRepository.this.getBean(beanId);
            }
            BeanRepository.this.addBean(beanId, value);
            return old;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            AssertArgument.isNotNull(map, (String)"map");
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                BeanRepository.this.addBean(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            AssertArgument.isNotNull((Object)key, (String)"key");
            if (!(key instanceof String)) {
                return null;
            }
            BeanId beanId = BeanRepository.this.beanIdRegister.getBeanId((String)key);
            return beanId == null ? null : BeanRepository.this.removeBean(beanId);
        }

        @Override
        public int size() {
            return BeanRepository.this.beanMap.size();
        }

        @Override
        public Collection<Object> values() {
            return BeanRepository.this.beanMap.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RepositoryEntry {
        private final BeanId beanId;
        private final Map.Entry<String, Object> entry;
        private final List<Integer> lifecycleAssociation = new ArrayList<Integer>();
        private BeanLifecycleSubjectGroup beanLifecycleSubjectGroup;

        public RepositoryEntry(BeanId beanId, Map.Entry<String, Object> entry) {
            this.beanId = beanId;
            this.entry = entry;
        }

        public BeanId getBeanId() {
            return this.beanId;
        }

        public Map.Entry<String, Object> getEntry() {
            return this.entry;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public void setValue(Object value) {
            this.entry.setValue(value);
        }

        public List<Integer> getLifecycleAssociation() {
            return this.lifecycleAssociation;
        }

        public BeanLifecycleSubjectGroup getBeanLifecycleSubjectGroup() {
            return this.beanLifecycleSubjectGroup;
        }

        public void setBeanLifecycleSubjectGroup(BeanLifecycleSubjectGroup beanLifecycleSubjectGroup) {
            this.beanLifecycleSubjectGroup = beanLifecycleSubjectGroup;
        }
    }
}

