/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BeanUtils;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.factory.Factory;
import org.milyn.javabean.factory.FactoryDefinitionParser;
import org.milyn.javabean.repository.BeanId;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(summary="Created <b>${resource.parameters.beanId!'undefined'}</b> bean instance.  Associated lifecycle if wired to another bean.", detailTemplate="reporting/BeanInstanceCreatorReport_Before.html")
@VisitAfterReport(condition="parameters.containsKey('setOn') || parameters.beanClass.value.endsWith('[]')", summary="Ended bean lifecycle. Set bean on any targets.", detailTemplate="reporting/BeanInstanceCreatorReport_After.html")
public class BeanInstanceCreator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer {
    private static Log logger = LogFactory.getLog(BeanInstanceCreator.class);
    public static final String INIT_VAL_EXPRESSION = "initValExpression";
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="beanClass", use=ConfigParam.Use.OPTIONAL)
    private String beanClassName;
    @ConfigParam(name="beanFactory", use=ConfigParam.Use.OPTIONAL)
    private String beanFactoryDefinition;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanId beanId;
    private MVELExpressionEvaluator initValsExpression;
    private Factory<?> factory;

    public BeanInstanceCreator() {
    }

    public BeanInstanceCreator(String beanId, Class<?> beanClass) {
        this(beanId, beanClass, null);
    }

    public <T> BeanInstanceCreator(String beanId, Class<T> beanClass, Factory<? extends T> factory) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull(beanClass, (String)"beanClass");
        this.beanIdName = beanId;
        this.beanClassName = BeanInstanceCreator.toClassName(beanClass);
        this.factory = factory;
    }

    public String getBeanId() {
        return this.beanIdName;
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        List initValExpressions;
        this.buildId();
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        if (StringUtils.isNotBlank((String)this.beanFactoryDefinition)) {
            this.factory = FactoryDefinitionParser.FactoryDefinitionParserFactory.getInstance(this.appContext).parse(this.beanFactoryDefinition);
        }
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.beanClassName, this.appContext);
        if (this.factory == null) {
            this.checkForDefaultConstructor();
        } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new SmooksConfigurationException("Using a factory with an array is not supported");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BeanInstanceCreator created for [" + this.beanIdName + "]. BeanRuntimeInfo: " + this.beanRuntimeInfo));
        }
        if ((initValExpressions = this.config.getParameters(INIT_VAL_EXPRESSION)) != null && !initValExpressions.isEmpty()) {
            StringBuilder initValsExpressionString = new StringBuilder();
            for (Parameter initValExpression : initValExpressions) {
                initValsExpressionString.append(initValExpression.getValue());
                initValsExpressionString.append("\n");
            }
            this.initValsExpression = new MVELExpressionEvaluator();
            this.initValsExpression.setExpression(initValsExpressionString.toString());
        }
    }

    public BeanRuntimeInfo getBeanRuntimeInfo() {
        return this.beanRuntimeInfo;
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstanceCreator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.createAndSetBean(executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.createAndSetBean(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.visitAfter(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.visitAfter(executionContext);
    }

    public void visitAfter(ExecutionContext executionContext) {
        BeanRuntimeInfo.Classification thisBeanType = this.beanRuntimeInfo.getClassification();
        boolean isBeanTypeArray = thisBeanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION;
        BeanContext beanContext = executionContext.getBeanContext();
        beanContext.setBeanInContext(this.beanId, false);
        if (isBeanTypeArray) {
            Object bean = beanContext.getBean(this.beanId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converting bean [" + this.beanIdName + "] to an array and rebinding to context."));
            }
            bean = this.convert(executionContext, bean);
        }
    }

    private Object convert(ExecutionContext executionContext, Object bean) {
        bean = BeanUtils.convertListToArray((List)bean, this.beanRuntimeInfo.getArrayType());
        executionContext.getBeanContext().changeBean(this.beanId, bean);
        return bean;
    }

    private void createAndSetBean(ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = this.createBeanInstance(executionContext);
        if (this.initValsExpression != null) {
            this.initValsExpression.exec(bean);
        }
        beanContext.setBeanInContext(this.beanId, false);
        beanContext.addBean(this.beanId, bean);
        beanContext.setBeanInContext(this.beanId, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean [" + this.beanIdName + "] instance created."));
        }
    }

    private Object createBeanInstance(ExecutionContext executionContext) {
        Object bean;
        if (this.factory == null) {
            try {
                bean = this.beanRuntimeInfo.getPopulateType().newInstance();
            }
            catch (InstantiationException e) {
                throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
            }
        }
        try {
            bean = this.factory.create(executionContext);
        }
        catch (RuntimeException e) {
            throw new SmooksConfigurationException("The factory was unable to create the bean instance [" + this.beanIdName + "] using the factory '" + this.factory + "'.", (Throwable)e);
        }
        return bean;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName});
    }

    private String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    private static String toClassName(Class<?> beanClass) {
        if (!beanClass.isArray()) {
            return beanClass.getName();
        }
        return beanClass.getComponentType().getName() + "[]";
    }

    private void checkForDefaultConstructor() {
        try {
            this.beanRuntimeInfo.getPopulateType().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + this.beanRuntimeInfo.getPopulateType().getName() + " doesn't have a public default constructor.");
        }
    }
}

