/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.repository.BeanId;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(condition="parameters.containsKey('valueAttributeName')", summary="Creating object under bean id <b>${resource.parameters.beanId}</b> with a value from the attribute <b>${resource.parameters.valueAttributeName}</b>.", detailTemplate="reporting/ValueBinderReport_Before.html")
@VisitAfterReport(condition="!parameters.containsKey('valueAttributeName')", summary="Creating object <b>${resource.parameters.beanId}</b> with a value from this element.", detailTemplate="reporting/ValueBinderReport_After.html")
public class ValueBinder
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer {
    private static final Log logger = LogFactory.getLog(ValueBinder.class);
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(defaultVal="##NULL")
    private String valueAttributeName;
    @ConfigParam(name="default", defaultVal="##NULL")
    private String defaultValue;
    @ConfigParam(name="type", defaultVal="String")
    private String typeAlias;
    private BeanId beanId;
    @AppContext
    private ApplicationContext appContext;
    private boolean isAttribute;
    private DataDecoder decoder;

    public ValueBinder() {
    }

    public ValueBinder(String beanId) {
        this.beanIdName = beanId;
    }

    public String getBeanIdName() {
        return this.beanIdName;
    }

    public void setBeanIdName(String beanIdName) {
        this.beanIdName = beanIdName;
    }

    public String getValueAttributeName() {
        return this.valueAttributeName;
    }

    public void setValueAttributeName(String valueAttributeName) {
        this.valueAttributeName = valueAttributeName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getTypeAlias() {
        return this.typeAlias;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public DataDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(DataDecoder decoder) {
        this.decoder = decoder;
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.isAttribute = this.valueAttributeName != null;
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Value Binder created for [" + this.beanIdName + "]."));
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.isAttribute) {
            this.bindValue(DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName), executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.isAttribute) {
            this.bindValue(DomUtils.getAllText((Element)element, (boolean)false), executionContext);
        }
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (this.isAttribute) {
            this.bindValue(SAXUtil.getAttribute((String)this.valueAttributeName, (Attributes)element.getAttributes()), executionContext);
        } else {
            element.accumulateText();
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (!this.isAttribute) {
            this.bindValue(element.getTextContent(), executionContext);
        }
    }

    private void bindValue(String dataString, ExecutionContext executionContext) {
        Object valueObj = this.decodeDataString(dataString, executionContext);
        BeanContext beanContext = executionContext.getBeanContext();
        if (valueObj == null) {
            beanContext.removeBean(this.beanId);
        } else {
            beanContext.addBean(this.beanId, valueObj);
        }
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName});
    }

    private Object decodeDataString(String dataString, ExecutionContext executionContext) throws DataDecodeException {
        if ((dataString == null || dataString.length() == 0) && this.defaultValue != null) {
            if (this.defaultValue.equals("null")) {
                return null;
            }
            dataString = this.defaultValue;
        }
        try {
            return this.getDecoder(executionContext).decode(dataString);
        }
        catch (DataDecodeException e) {
            throw new DataDecodeException("Failed to decode the value '" + dataString + "' for the bean id '" + this.beanIdName + "'.", (Throwable)e);
        }
    }

    private DataDecoder getDecoder(ExecutionContext executionContext) throws DataDecodeException {
        if (this.decoder == null) {
            List decoders = executionContext.getDeliveryConfig().getObjects("decoder:" + this.typeAlias);
            if (decoders == null || decoders.isEmpty()) {
                this.decoder = DataDecoder.Factory.create((String)this.typeAlias);
            } else {
                if (!(decoders.get(0) instanceof DataDecoder)) {
                    throw new DataDecodeException("Configured decoder '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + DataDecoder.class.getName());
                }
                this.decoder = (DataDecoder)decoders.get(0);
            }
        }
        return this.decoder;
    }
}

