/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic.ext;

import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.javabean.ext.BeanConfigUtil;
import org.w3c.dom.Element;

public class BeanClassLookup
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = ExtensionContext.getExtensionContext((ExecutionContext)executionContext);
        SmooksResourceConfiguration dmbWriterConfig = (SmooksResourceConfiguration)extensionContext.getResourceStack().peek();
        if (dmbWriterConfig.getStringParameter("beanClass") == null) {
            String beanId = dmbWriterConfig.getStringParameter("beanId");
            if (beanId == null) {
                throw new SmooksConfigurationException("One of the 'beanClass' or 'beanId' attributes must be configured on the <dmb:writer> configuration.");
            }
            SmooksResourceConfiguration beanCreatorConfig = BeanConfigUtil.findBeanCreatorConfig(beanId, executionContext);
            if (beanCreatorConfig == null) {
                throw new SmooksConfigurationException("Cannot find <jb:bean> configuration for beanId '" + beanId + "' for <dmb:writer>.  Reordered <dmb:writer> after <jb:bean> config.");
            }
            String beanClass = beanCreatorConfig.getStringParameter("beanClass");
            if (beanClass == null) {
                throw new SmooksConfigurationException("Cannot create find BeanWriter for beanId '" + beanId + "'.  The associated <jb:bean> configuration does not define a bean Class name.");
            }
            dmbWriterConfig.setParameter("beanClass", beanClass);
        }
    }
}

