/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.javabean.BindingAppender;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.ValueBinder;
import org.milyn.javabean.ext.SelectorPropertyResolver;

public class Value
extends BindingAppender {
    private String dataSelector;
    private String targetNamespace;
    private String defaultValue;
    private DataDecoder decoder;

    public Value(String beanId, String data) {
        super(beanId);
        AssertArgument.isNotNullAndNotEmpty((String)beanId, (String)"beanId");
        AssertArgument.isNotNullAndNotEmpty((String)data, (String)"dataSelector");
        this.dataSelector = data;
    }

    public Value(String beanId, String data, Class<?> type) {
        this(beanId, data);
        AssertArgument.isNotNull(type, (String)"type");
        this.decoder = DataDecoder.Factory.create(type);
    }

    public Value setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
        return this;
    }

    public Value setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Value setType(Class<?> type) {
        this.decoder = DataDecoder.Factory.create(type);
        return this;
    }

    public Value setDecoder(DataDecoder dataDecoder) {
        this.decoder = dataDecoder;
        return this;
    }

    public void addVisitors(VisitorConfigMap visitorMap) {
        ValueBinder binder = new ValueBinder(this.getBeanId());
        SmooksResourceConfiguration populatorConfig = new SmooksResourceConfiguration(this.dataSelector);
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
        binder.setDecoder(this.decoder);
        binder.setDefaultValue(this.defaultValue);
        binder.setValueAttributeName(populatorConfig.getStringParameter("valueAttributeName"));
        visitorMap.addVisitor((Visitor)binder, populatorConfig.getSelector(), this.targetNamespace, true);
    }
}

