/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.ext;

import java.util.UUID;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.decoders.PreprocessDecoder;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecodeParamResolver
implements DOMVisitBefore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        NodeList decodeParams = element.getElementsByTagNameNS(element.getNamespaceURI(), "decodeParam");
        if (decodeParams.getLength() > 0) {
            ExtensionContext extensionContext = ExtensionContext.getExtensionContext((ExecutionContext)executionContext);
            SmooksResourceConfiguration populatorConfig = (SmooksResourceConfiguration)extensionContext.getResourceStack().peek();
            SmooksResourceConfiguration decoderConfig = new SmooksResourceConfiguration();
            extensionContext.addResource(decoderConfig);
            try {
                String type = populatorConfig.getStringParameter("type");
                DataDecoder decoder = DataDecoder.Factory.create(type);
                String reType = UUID.randomUUID().toString();
                populatorConfig.removeParameter("type");
                populatorConfig.setParameter("type", reType);
                decoderConfig.setSelector("decoder:" + reType);
                decoderConfig.setTargetProfile(extensionContext.getDefaultProfile());
                if (type != null) {
                    decoderConfig.setResource(decoder.getClass().getName());
                }
                for (int i = 0; i < decodeParams.getLength(); ++i) {
                    Element decoderParam = (Element)decodeParams.item(i);
                    String name = decoderParam.getAttribute("name");
                    if (name.equals("valuePreprocess")) {
                        decoderConfig.setResource(PreprocessDecoder.class.getName());
                        if (type != null) {
                            decoderConfig.setParameter("baseDecoder", decoder.getClass().getName());
                        }
                    }
                    decoderConfig.setParameter(name, DomUtils.getAllText((Element)decoderParam, (boolean)true));
                }
            }
            finally {
                extensionContext.getResourceStack().pop();
            }
        }
    }
}

