/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.db;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.routing.db.DataSelectionException;
import org.milyn.util.FreeMarkerTemplate;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="!parameters.containsKey('executeBefore') || parameters.executeBefore.value == 'true'")
@VisitAfterIf(condition="parameters.containsKey('executeBefore') && parameters.executeBefore.value != 'true'")
public class ResultsetRowSelector
implements SAXVisitBefore,
SAXVisitAfter,
DOMElementVisitor {
    private static Log logger = LogFactory.getLog(ResultsetRowSelector.class);
    @ConfigParam
    private String resultSetName;
    @ConfigParam(name="where")
    private MVELExpressionEvaluator whereEvaluator;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private FreeMarkerTemplate failedSelectError;
    @ConfigParam(name="beanId")
    private String beanIdName;
    private BeanId resultSetBeanId;
    private BeanId beanId;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void intitialize() throws SmooksConfigurationException {
        BeanIdRegister beanIdRegister = BeanRepositoryManager.getInstance((ApplicationContext)this.appContext).getBeanIdRegister();
        this.beanId = beanIdRegister.register(this.beanIdName);
        this.resultSetBeanId = beanIdRegister.register(this.resultSetName);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.selectRow(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.selectRow(executionContext);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.selectRow(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.selectRow(executionContext);
    }

    private void selectRow(ExecutionContext executionContext) throws SmooksException {
        BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository((ExecutionContext)executionContext);
        HashMap<String, Map> beanMapClone = new HashMap<String, Map>(beanRepository.getBeanMap());
        try {
            List resultSet = (List)beanRepository.getBean(this.resultSetBeanId);
            if (resultSet == null) {
                throw new SmooksException("Resultset '" + this.resultSetName + "' not found in bean context.  Make sure an appropriate SQLExecutor resource config wraps this selector config.");
            }
            try {
                Map selectedRow = null;
                Iterator resultIter = resultSet.iterator();
                while (selectedRow == null && resultIter.hasNext()) {
                    Map row = (Map)resultIter.next();
                    beanMapClone.put("row", row);
                    if (!this.whereEvaluator.eval(beanMapClone)) continue;
                    selectedRow = row;
                    beanRepository.addBean(this.beanId, (Object)selectedRow);
                }
                if (selectedRow == null && this.failedSelectError != null) {
                    throw new DataSelectionException(this.failedSelectError.apply((Object)beanRepository.getBeanMap()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Selected resultset where '" + this.whereEvaluator.getExpression() + "': [" + selectedRow + "]."));
                }
            }
            catch (ClassCastException e) {
                throw new SmooksException("Bean '" + this.resultSetName + "' cannot be used as a Reference Data resultset.  The resultset List must contain entries of type Map<String, Object>.");
            }
        }
        catch (ClassCastException e) {
            throw new SmooksException("Bean '" + this.resultSetName + "' cannot be used as a Reference Data resultset.  A resultset must be of type List<Map<String, Object>>. '" + this.resultSetName + "' is of type '" + beanRepository.getBean(this.resultSetBeanId).getClass().getName() + "'.");
        }
    }
}

