/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AcknowledgeModeEnum {
    CLIENT_ACKNOWLEDGE(2),
    AUTO_ACKNOWLEDGE(1),
    DUPS_OK_ACKNOWLEDGE(3);

    private static final Log log;
    private int jmsAckModeInt;

    private AcknowledgeModeEnum(int jmsAckModeInt) {
        this.jmsAckModeInt = jmsAckModeInt;
    }

    public int getAcknowledgeModeInt() {
        return this.jmsAckModeInt;
    }

    public static AcknowledgeModeEnum getAckMode(String ackMode) {
        if (ackMode != null) {
            try {
                return AcknowledgeModeEnum.valueOf(ackMode);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("' " + ackMode + "' is invalid : " + ".Will use default '" + (Object)((Object)AUTO_ACKNOWLEDGE)));
            }
        }
        return AUTO_ACKNOWLEDGE;
    }

    static {
        log = LogFactory.getLog(AcknowledgeModeEnum.class);
    }
}

