/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.expression.ExpressionEvaluator;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.io.AbstractOutputStreamResource;
import org.milyn.javabean.decoders.MVELExpressionEvaluatorDecoder;
import org.milyn.routing.SmooksRoutingException;
import org.milyn.routing.file.FileListAccessor;
import org.milyn.util.DollarBraceDecoder;
import org.milyn.util.FreeMarkerTemplate;
import org.milyn.util.FreeMarkerUtils;

public class FileOutputStreamResource
extends AbstractOutputStreamResource {
    private static final String TMP_FILE_CONTEXT_KEY_PREFIX = FileOutputStreamResource.class.getName() + "#tmpFile:";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Log logger = LogFactory.getLog(FileOutputStreamResource.class);
    @ConfigParam
    private String fileNamePattern;
    private FreeMarkerTemplate fileNameTemplate;
    @ConfigParam
    private String destinationDirectoryPattern;
    private FreeMarkerTemplate destinationDirectoryTemplate;
    private FileFilter fileFilter;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String listFileNamePattern;
    private FreeMarkerTemplate listFileNameTemplate;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private boolean append;
    private String listFileNamePatternCtxKey;
    @ConfigParam(defaultVal="200")
    private int highWaterMark = 200;
    @ConfigParam(defaultVal="60000")
    private long highWaterMarkTimeout = 60000L;
    @ConfigParam(defaultVal="1000")
    private long highWaterMarkPollFrequency = 1000L;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL, decoder=MVELExpressionEvaluatorDecoder.class)
    private ExpressionEvaluator closeOnCondition;

    public FileOutputStreamResource setFileNamePattern(String fileNamePattern) {
        AssertArgument.isNotNullAndNotEmpty((String)fileNamePattern, (String)"fileNamePattern");
        this.fileNamePattern = fileNamePattern;
        return this;
    }

    public FileOutputStreamResource setDestinationDirectoryPattern(String destinationDirectoryPattern) {
        AssertArgument.isNotNullAndNotEmpty((String)destinationDirectoryPattern, (String)"destinationDirectoryPattern");
        this.destinationDirectoryPattern = destinationDirectoryPattern;
        return this;
    }

    public FileOutputStreamResource setListFileNamePattern(String listFileNamePattern) {
        AssertArgument.isNotNullAndNotEmpty((String)listFileNamePattern, (String)"listFileNamePattern");
        this.listFileNamePattern = listFileNamePattern;
        return this;
    }

    public FileOutputStreamResource setListFileNamePatternCtxKey(String listFileNamePatternCtxKey) {
        AssertArgument.isNotNullAndNotEmpty((String)listFileNamePatternCtxKey, (String)"listFileNamePatternCtxKey");
        this.listFileNamePatternCtxKey = listFileNamePatternCtxKey;
        return this;
    }

    public FileOutputStreamResource setHighWaterMark(int highWaterMark) {
        this.highWaterMark = highWaterMark;
        return this;
    }

    public FileOutputStreamResource setHighWaterMarkTimeout(long highWaterMarkTimeout) {
        this.highWaterMarkTimeout = highWaterMarkTimeout;
        return this;
    }

    public FileOutputStreamResource setHighWaterMarkPollFrequency(long highWaterMarkPollFrequency) {
        this.highWaterMarkPollFrequency = highWaterMarkPollFrequency;
        return this;
    }

    public void setCloseOnCondition(String closeOnCondition) {
        AssertArgument.isNotNullAndNotEmpty((String)closeOnCondition, (String)"closeOnCondition");
        this.closeOnCondition = new MVELExpressionEvaluator();
        this.closeOnCondition.setExpression(closeOnCondition);
    }

    public FileOutputStreamResource setAppend(boolean append) {
        this.append = append;
        return this;
    }

    @Initialize
    public void intialize() throws SmooksConfigurationException {
        if (this.fileNamePattern == null) {
            throw new SmooksConfigurationException("Null 'fileNamePattern' configuration parameter.");
        }
        if (this.destinationDirectoryPattern == null) {
            throw new SmooksConfigurationException("Null 'destinationDirectoryPattern' configuration parameter.");
        }
        this.fileNameTemplate = new FreeMarkerTemplate(this.fileNamePattern);
        this.destinationDirectoryTemplate = new FreeMarkerTemplate(this.destinationDirectoryPattern);
        this.fileFilter = new SplitFilenameFilter(this.fileNamePattern);
        if (this.listFileNamePattern != null) {
            this.listFileNameTemplate = new FreeMarkerTemplate(this.listFileNamePattern);
            this.listFileNamePatternCtxKey = FileOutputStreamResource.class.getName() + "#" + this.listFileNamePattern;
        }
    }

    public FileOutputStream getOutputStream(ExecutionContext executionContext) throws SmooksRoutingException, IOException {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext);
        String destinationDirName = this.destinationDirectoryTemplate.apply((Object)beanMap);
        File destinationDirectory = new File(destinationDirName);
        this.assertTargetDirectoryOK(destinationDirectory);
        this.waitWhileAboveHighWaterMark(destinationDirectory);
        if (this.append) {
            File outputFile = new File(destinationDirectory, this.getOutputFileName(executionContext));
            return new FileOutputStream(outputFile, true);
        }
        File tmpFile = File.createTempFile("." + UUID.randomUUID().toString(), ".working", destinationDirectory);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile, false);
        executionContext.setAttribute((Object)(TMP_FILE_CONTEXT_KEY_PREFIX + this.getResourceName()), (Object)tmpFile);
        return fileOutputStream;
    }

    private void assertTargetDirectoryOK(File destinationDirectory) throws SmooksRoutingException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new SmooksRoutingException("The file routing target directory '" + destinationDirectory.getAbsolutePath() + "' exist but is not a directory. destinationDirectoryPattern: '" + this.destinationDirectoryPattern + "'");
        }
        if (!destinationDirectory.exists() && !destinationDirectory.mkdirs()) {
            throw new SmooksRoutingException("Failed to create file routing target directory '" + destinationDirectory.getAbsolutePath() + "'. destinationDirectoryPattern: '" + this.destinationDirectoryPattern + "'");
        }
    }

    private void waitWhileAboveHighWaterMark(File destinationDirectory) throws SmooksRoutingException {
        if (this.highWaterMark == -1) {
            return;
        }
        File[] currentList = destinationDirectory.listFiles(this.fileFilter);
        if (currentList.length >= this.highWaterMark) {
            long start = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destination directoy '" + destinationDirectory.getAbsolutePath() + "' contains " + currentList.length + " file matching pattern '" + this.listFileNamePattern + "'.  High Water Mark is " + this.highWaterMark + ".  Waiting for file count to drop."));
            }
            while (System.currentTimeMillis() < start + this.highWaterMarkTimeout) {
                try {
                    Thread.sleep(this.highWaterMarkPollFrequency);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Interrupted", (Throwable)e);
                    return;
                }
                currentList = destinationDirectory.listFiles(this.fileFilter);
                if (currentList.length >= this.highWaterMark) continue;
                return;
            }
            throw new SmooksRoutingException("Failed to route message to Filesystem destination '" + destinationDirectory.getAbsolutePath() + "'. Timed out (" + this.highWaterMarkTimeout + " ms) waiting for the number of '" + this.listFileNamePattern + "' files to drop below High Water Mark (" + this.highWaterMark + ").  Consider increasing 'highWaterMark' and/or 'highWaterMarkTimeout' param values.");
        }
    }

    protected boolean closeCondition(ExecutionContext executionContext) {
        if (this.closeOnCondition == null) {
            return true;
        }
        return this.closeOnCondition.eval((Object)executionContext.getBeanContext().getBeanMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResource(ExecutionContext executionContext) {
        try {
            super.closeResource(executionContext);
        }
        finally {
            File newFile;
            if (!this.append && (newFile = this.renameWorkingFile(executionContext)) != null) {
                this.addToListFile(executionContext, newFile);
            }
        }
    }

    private File renameWorkingFile(ExecutionContext executionContext) {
        File workingFile = (File)executionContext.getAttribute((Object)(TMP_FILE_CONTEXT_KEY_PREFIX + this.getResourceName()));
        if (workingFile == null || !workingFile.exists()) {
            return null;
        }
        String newFileName = this.getOutputFileName(executionContext);
        File newFile = new File(workingFile.getParentFile(), newFileName);
        if (newFile.exists()) {
            throw new SmooksException("Could not rename [" + workingFile.getAbsolutePath() + "] to [" + newFile.getAbsolutePath() + "]. [" + newFile.getAbsolutePath() + "] already exists.");
        }
        boolean renameTo = workingFile.renameTo(newFile);
        if (!renameTo) {
            throw new SmooksException("Could not rename [" + workingFile.getAbsolutePath() + "] to [" + newFile.getAbsolutePath() + "]");
        }
        workingFile.delete();
        return newFile;
    }

    private String getOutputFileName(ExecutionContext executionContext) {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext);
        return this.fileNameTemplate.apply((Object)beanMap);
    }

    private void addToListFile(ExecutionContext executionContext, File newFile) {
        if (this.listFileNamePatternCtxKey != null) {
            FileWriter writer = (FileWriter)executionContext.getAttribute((Object)this.listFileNamePatternCtxKey);
            if (writer == null) {
                String listFileName = this.getListFileName(executionContext);
                File listFile = new File(newFile.getParentFile(), listFileName);
                FileListAccessor.addFileName(listFile.getAbsolutePath(), executionContext);
                try {
                    writer = new FileWriter(listFile);
                    executionContext.setAttribute((Object)this.listFileNamePatternCtxKey, (Object)writer);
                }
                catch (IOException e) {
                    throw new SmooksException("", (Throwable)e);
                }
            }
            try {
                writer.write(newFile.getAbsolutePath() + LINE_SEPARATOR);
                writer.flush();
            }
            catch (IOException e) {
                throw new SmooksException("IOException while trying to write to list file [" + this.getListFileName(executionContext) + "] :", (Throwable)e);
            }
        }
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        FileWriter writer;
        super.executeExecutionLifecycleCleanup(executionContext);
        if (this.listFileNamePatternCtxKey != null && (writer = (FileWriter)executionContext.getAttribute((Object)this.listFileNamePatternCtxKey)) != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to close list file '" + this.getListFileName(executionContext) + "'."), (Throwable)e);
            }
        }
    }

    private String getListFileName(ExecutionContext executionContext) {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)executionContext);
        return this.listFileNameTemplate.apply((Object)beanMap);
    }

    public static class SplitFilenameFilter
    implements FileFilter {
        private final Pattern regexPattern;

        private SplitFilenameFilter(String filenamePattern) {
            String pattern = DollarBraceDecoder.replaceTokens((String)filenamePattern, (String)".*");
            this.regexPattern = Pattern.compile(pattern);
        }

        public boolean accept(File file) {
            Matcher matcher = this.regexPattern.matcher(file.getName());
            return matcher.matches();
        }
    }
}

