/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.freemarker;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.serialize.ContextObjectSerializationUnit;
import org.milyn.delivery.sax.DefaultSAXElementSerializer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.io.AbstractOutputStreamResource;
import org.milyn.io.NullWriter;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.templating.AbstractTemplateProcessor;
import org.milyn.templating.freemarker.FreeMarkerUtils;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeReport(summary="FreeMarker Template - See Detail.", detailTemplate="reporting/FreeMarkerTemplateProcessor_before.html")
@VisitAfterReport(summary="FreeMarker Template - See Detail.", detailTemplate="reporting/FreeMarkerTemplateProcessor_After.html")
public class FreeMarkerTemplateProcessor
extends AbstractTemplateProcessor
implements SAXElementVisitor {
    private static Log logger = LogFactory.getLog(FreeMarkerTemplateProcessor.class);
    private Template templateBefore;
    private Template templateAfter;
    private Template defaultTemplate;
    private SmooksResourceConfiguration config;
    private DefaultSAXElementSerializer targetWriter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadTemplate(SmooksResourceConfiguration config) throws IOException {
        this.config = config;
        if (config.isInline()) {
            byte[] templateBytes = config.getBytes();
            String[] templates = new String(templateBytes).split("<\\?TEMPLATE-SPLIT-PI\\?>");
            if (templates.length == 1) {
                this.defaultTemplate = this.applyTemplateBefore() ? new Template("free-marker-template", (Reader)new StringReader(templates[0]), new Configuration()) : new Template("free-marker-template", (Reader)new StringReader(templates[0]), new Configuration());
            } else {
                if (templates.length != 2) throw new IOException("Invalid FreeMarker template config.  Zero split tokens.");
                if (this.getAction() != AbstractTemplateProcessor.Action.REPLACE) {
                    throw new UnsupportedOperationException("Split templates only supported on the REPLACE action.");
                }
                this.templateBefore = new Template("free-marker-template-before", (Reader)new StringReader(templates[0]), new Configuration());
                this.templateAfter = new Template("free-marker-template-after", (Reader)new StringReader(templates[1]), new Configuration());
            }
        } else {
            Configuration configuration = new Configuration();
            TemplateLoader[] loaders = new TemplateLoader[]{new FileTemplateLoader(), new ContextClassLoaderTemplateLoader()};
            MultiTemplateLoader multiLoader = new MultiTemplateLoader(loaders);
            configuration.setTemplateLoader((TemplateLoader)multiLoader);
            this.defaultTemplate = this.applyTemplateBefore() ? configuration.getTemplate(config.getResource()) : configuration.getTemplate(config.getResource());
        }
        this.targetWriter = new DefaultSAXElementSerializer();
        this.targetWriter.setWriterOwner((SAXVisitor)this);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.defaultTemplate != null) {
            if (this.applyTemplateBefore()) {
                this.applyTemplate(this.defaultTemplate, element, executionContext);
            }
        } else {
            throw new UnsupportedOperationException("Split templates not supported for DOM based filtering.");
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.defaultTemplate != null) {
            if (!this.applyTemplateBefore()) {
                this.applyTemplate(this.defaultTemplate, element, executionContext);
            }
        } else {
            throw new UnsupportedOperationException("Split templates not supported for DOM based filtering.");
        }
    }

    protected void visit(Element element, ExecutionContext executionContext) throws SmooksException {
        throw new UnsupportedOperationException("This method should not be called on this implementation.");
    }

    private void applyTemplate(Template template, Element element, ExecutionContext executionContext) throws SmooksException {
        Node resultNode;
        String templatingResult;
        try {
            StringWriter writer = new StringWriter();
            Map<String, Object> model = FreeMarkerUtils.getMergedModel(executionContext);
            template.process(model, (Writer)writer);
            ((Writer)writer).flush();
            templatingResult = ((Object)writer).toString();
        }
        catch (TemplateException e) {
            throw new SmooksException("Failed to apply FreeMarker template to fragment '" + DomUtils.getXPath((Node)element) + "'.  Resource: " + this.config, (Throwable)e);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to apply FreeMarker template to fragment '" + DomUtils.getXPath((Node)element) + "'.  Resource: " + this.config, (Throwable)e);
        }
        if (this.getAction() != AbstractTemplateProcessor.Action.ADDTO && element == element.getOwnerDocument().getDocumentElement()) {
            String key = "FreeMarkerObject:" + DomUtils.getXPath((Node)element);
            executionContext.setAttribute((Object)key, (Object)templatingResult);
            resultNode = ContextObjectSerializationUnit.createElement((Document)element.getOwnerDocument(), (String)key);
        } else {
            resultNode = element.getOwnerDocument().createTextNode(templatingResult);
        }
        this.processTemplateAction(element, resultNode, executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        String outputStreamResourceName = this.getOutputStreamResource();
        if (outputStreamResourceName != null) {
            if (this.applyTemplateBefore()) {
                this.applyTemplateToOutputStream(this.defaultTemplate, element, outputStreamResourceName, executionContext);
            }
        } else if (this.getAction() == AbstractTemplateProcessor.Action.INSERT_BEFORE) {
            this.applyTemplate(this.defaultTemplate, element, executionContext);
            if (executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
                this.targetWriter.visitBefore(element, executionContext);
            }
        } else if (this.getAction() == AbstractTemplateProcessor.Action.REPLACE) {
            Writer currentWriter = element.getWriter((SAXVisitor)this);
            if (this.templateBefore != null) {
                this.applyTemplate(this.templateBefore, element, executionContext);
            } else if (executionContext.isDefaultSerializationOn()) {
                element.setWriter((Writer)new NullWriter(currentWriter), (SAXVisitor)this);
            }
        } else if (this.getAction() != AbstractTemplateProcessor.Action.REPLACE && this.getAction() != AbstractTemplateProcessor.Action.BIND_TO) {
            if (executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
                this.targetWriter.visitBefore(element, executionContext);
            }
        } else if (this.getAction() != AbstractTemplateProcessor.Action.BIND_TO && executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
            element.getWriter((SAXVisitor)this);
        }
    }

    public void onChildText(SAXElement element, SAXText childText, ExecutionContext executionContext) throws SmooksException, IOException {
        if (this.getOutputStreamResource() == null && this.getAction() != AbstractTemplateProcessor.Action.REPLACE && this.getAction() != AbstractTemplateProcessor.Action.BIND_TO && executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
            this.targetWriter.onChildText(element, childText, executionContext);
        }
    }

    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        if (this.getOutputStreamResource() == null && this.getAction() != AbstractTemplateProcessor.Action.REPLACE && this.getAction() != AbstractTemplateProcessor.Action.BIND_TO && executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
            this.targetWriter.onChildElement(element, childElement, executionContext);
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        String outputStreamResourceName = this.getOutputStreamResource();
        if (outputStreamResourceName != null) {
            if (!this.applyTemplateBefore()) {
                this.applyTemplateToOutputStream(this.defaultTemplate, element, outputStreamResourceName, executionContext);
            }
        } else if (this.getAction() == AbstractTemplateProcessor.Action.ADDTO) {
            if (!this.targetWriter.isStartWritten(element) && executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
                this.targetWriter.writeStartElement(element);
            }
            this.applyTemplate(this.defaultTemplate, element, executionContext);
            if (executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
                this.targetWriter.visitAfter(element, executionContext);
            }
        } else if (this.getAction() == AbstractTemplateProcessor.Action.INSERT_BEFORE) {
            if (executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
                this.targetWriter.visitAfter(element, executionContext);
            }
        } else if (this.getAction() == AbstractTemplateProcessor.Action.INSERT_AFTER) {
            if (executionContext.getDeliveryConfig().isDefaultSerializationOn()) {
                this.targetWriter.visitAfter(element, executionContext);
            }
            this.applyTemplate(this.defaultTemplate, element, executionContext);
        } else if (this.getAction() == AbstractTemplateProcessor.Action.REPLACE) {
            Writer writer = element.getWriter((SAXVisitor)this);
            if (writer instanceof NullWriter) {
                element.setWriter(((NullWriter)writer).getParentWriter(), (SAXVisitor)this);
            }
            if (this.templateAfter != null) {
                this.applyTemplate(this.templateAfter, element, executionContext);
            } else {
                this.applyTemplate(this.defaultTemplate, element, executionContext);
            }
        } else if (this.getAction() == AbstractTemplateProcessor.Action.BIND_TO) {
            this.applyTemplate(this.defaultTemplate, element, executionContext);
        }
    }

    private void applyTemplateToOutputStream(Template template, SAXElement element, String outputStreamResourceName, ExecutionContext executionContext) {
        Writer writer = AbstractOutputStreamResource.getOutputWriter((String)outputStreamResourceName, (ExecutionContext)executionContext);
        this.applyTemplate(template, element, executionContext, writer);
    }

    private void applyTemplate(Template template, SAXElement element, ExecutionContext executionContext) throws SmooksException {
        if (this.getAction() == AbstractTemplateProcessor.Action.BIND_TO) {
            StringWriter writer = new StringWriter();
            this.applyTemplate(template, element, executionContext, writer);
            BeanRepositoryManager.getBeanRepository((ExecutionContext)executionContext).addBean(this.getBindBeanId(), (Object)((Object)writer).toString());
        } else {
            Writer writer = element.getWriter((SAXVisitor)this);
            this.applyTemplate(template, element, executionContext, writer);
        }
    }

    private void applyTemplate(Template template, SAXElement element, ExecutionContext executionContext, Writer writer) throws SmooksException {
        try {
            Map<String, Object> model = FreeMarkerUtils.getMergedModel(executionContext);
            template.process(model, writer);
            writer.flush();
        }
        catch (TemplateException e) {
            throw new SmooksException("Failed to apply FreeMarker template to fragment '" + SAXUtil.getXPath((SAXElement)element) + "'.  Resource: " + this.config, (Throwable)e);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to apply FreeMarker template to fragment '" + SAXUtil.getXPath((SAXElement)element) + "'.  Resource: " + this.config, (Throwable)e);
        }
    }

    private static class ContextClassLoaderTemplateLoader
    extends URLTemplateLoader {
        private ContextClassLoaderTemplateLoader() {
        }

        protected URL getURL(String name) {
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
    }
}

