/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.xslt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.annotation.Resource;
import org.milyn.delivery.dom.serialize.GhostElementSerializationUnit;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.io.StreamUtils;
import org.milyn.templating.AbstractTemplateProcessor;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@Resource(type="xsl")
public class XslContentHandlerFactory
implements ContentHandlerFactory {
    public static final String IS_XSLT_TEMPLATELET = "is-xslt-templatelet";
    private static Log logger = LogFactory.getLog(XslContentHandlerFactory.class);
    public static final String ORG_MILYN_TEMPLATING_XSLT_SYNCHRONIZED = "org.milyn.templating.xslt.synchronized";
    @AppContext
    private ApplicationContext applicationContext;

    public synchronized ContentHandler create(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException, InstantiationException {
        try {
            return Configurator.configure((ContentHandler)new XslProcessor(), (SmooksResourceConfiguration)resourceConfig, (ApplicationContext)this.applicationContext);
        }
        catch (SmooksConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("XSL ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    @VisitBeforeReport(condition="false")
    @VisitAfterReport(summary="Applied XSL Template.", detailTemplate="reporting/XslTemplateProcessor_After.html")
    private static class XslProcessor
    extends AbstractTemplateProcessor {
        private Templates xslTemplate;
        private boolean isTemplatelet;
        private final boolean isSynchronized = Boolean.getBoolean("org.milyn.templating.xslt.synchronized");

        private XslProcessor() {
        }

        protected void loadTemplate(SmooksResourceConfiguration resourceConfig) throws IOException, TransformerConfigurationException {
            byte[] xslBytes = resourceConfig.getBytes();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            boolean isInlineXSL = resourceConfig.isInline();
            this.isTemplatelet = this.isTemplatelet(isInlineXSL, new String(xslBytes));
            if (this.isTemplatelet) {
                String templateletWrapper = new String(StreamUtils.readStream((InputStream)ClassUtil.getResourceAsStream((String)"doc-files/templatelet.xsl", this.getClass())));
                String templatelet = new String(xslBytes);
                templateletWrapper = StringUtils.replace((String)templateletWrapper, (String)"@@@templatelet@@@", (String)templatelet);
                xslBytes = templateletWrapper.getBytes();
            }
            boolean failOnWarning = resourceConfig.getBoolParameter("failOnWarning", true);
            StreamSource xslStreamSource = new StreamSource(new InputStreamReader((InputStream)new ByteArrayInputStream(xslBytes), this.getEncoding()));
            transformerFactory.setErrorListener(new XslErrorListener(failOnWarning));
            this.xslTemplate = transformerFactory.newTemplates(xslStreamSource);
        }

        private boolean isTemplatelet(boolean inlineXSL, String templateCode) {
            try {
                Document xslDoc = XmlUtil.parseStream((Reader)new StringReader(templateCode));
                Element rootElement = xslDoc.getDocumentElement();
                String rootElementNS = rootElement.getNamespaceURI();
                return inlineXSL && (rootElementNS == null || !rootElementNS.equals("http://www.w3.org/1999/XSL/Transform") || !DomUtils.getName((Element)rootElement).equals("stylesheet"));
            }
            catch (ParserConfigurationException e) {
                throw new SmooksConfigurationException("Unable to parse XSL Document (Stylesheet/Templatelet).", (Throwable)e);
            }
            catch (IOException e) {
                throw new SmooksConfigurationException("Unable to parse XSL Document (Stylesheet/Templatelet).", (Throwable)e);
            }
            catch (SAXException e) {
                return inlineXSL;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visit(Element element, ExecutionContext executionContext) throws SmooksException {
            Element ghostElement;
            block10: {
                Document ownerDoc = element.getOwnerDocument();
                ghostElement = GhostElementSerializationUnit.createElement((Document)ownerDoc);
                try {
                    if (this.isSynchronized) {
                        Templates templates = this.xslTemplate;
                        synchronized (templates) {
                            this.performTransform(element, ghostElement, ownerDoc);
                            break block10;
                        }
                    }
                    this.performTransform(element, ghostElement, ownerDoc);
                }
                catch (TransformerException e) {
                    throw new SmooksException("Error applying XSLT to node [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath((Node)element) + "]", (Throwable)e);
                }
            }
            if (this.getOutputStreamResource() != null || this.getAction() == AbstractTemplateProcessor.Action.BIND_TO) {
                String serializedContent = XmlUtil.serialize((NodeList)ghostElement.getChildNodes());
                Text textNode = element.getOwnerDocument().createTextNode(serializedContent);
                this.processTemplateAction(element, textNode, executionContext);
            } else {
                NodeList children = ghostElement.getChildNodes();
                if (children.getLength() == 1 && children.item(0).getNodeType() == 1) {
                    this.processTemplateAction(element, children.item(0), executionContext);
                } else {
                    this.processTemplateAction(element, ghostElement, executionContext);
                }
            }
        }

        private void performTransform(Element element, Element transRes, Document ownerDoc) throws TransformerException {
            Transformer transformer = this.xslTemplate.newTransformer();
            if (element == ownerDoc.getDocumentElement()) {
                transformer.transform(new DOMSource(ownerDoc), new DOMResult(transRes));
            } else {
                transformer.transform(new DOMSource(element), new DOMResult(transRes));
            }
        }

        private static class XslErrorListener
        implements ErrorListener {
            private final boolean failOnWarning;

            public XslErrorListener(boolean failOnWarning) {
                this.failOnWarning = failOnWarning;
            }

            public void warning(TransformerException exception) throws TransformerException {
                if (this.failOnWarning) {
                    throw exception;
                }
                logger.warn((Object)"XSL Warning.", (Throwable)exception);
            }

            public void error(TransformerException exception) throws TransformerException {
                throw exception;
            }

            public void fatalError(TransformerException exception) throws TransformerException {
                throw exception;
            }
        }
    }
}

