/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.stringtemplate.v4;

import java.io.IOException;
import java.util.Map;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.annotation.Resource;
import org.milyn.delivery.dom.serialize.TextSerializationUnit;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.templating.AbstractTemplateProcessor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STRawGroupDir;
import org.w3c.dom.Element;

@Resource(type="stv4")
public class StringTemplateContentHandlerFactory
implements ContentHandlerFactory {
    @AppContext
    private ApplicationContext applicationContext;

    public synchronized ContentHandler create(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException, InstantiationException {
        try {
            return (ContentHandler)Configurator.configure((Object)new StringTemplateTemplateProcessor(), (SmooksResourceConfiguration)resourceConfig, (ApplicationContext)this.applicationContext);
        }
        catch (SmooksConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("StringTemplate ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.  StringTemplate resource invalid.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    @VisitBeforeReport(condition="false")
    @VisitAfterReport(summary="Applied StringTemplate Template.", detailTemplate="reporting/StringTemplateTemplateProcessor_After.html")
    private static class StringTemplateTemplateProcessor
    extends AbstractTemplateProcessor
    implements Consumer {
        private ST template = null;
        private String templateName;
        STRawGroupDir templateGroupDir;

        private StringTemplateTemplateProcessor() {
        }

        protected void loadTemplate(SmooksResourceConfiguration config) throws IOException {
            String path = config.getResource();
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            String dir = path.substring(0, path.lastIndexOf(47));
            this.templateName = path.substring(path.lastIndexOf(47), path.indexOf(".st"));
            this.templateGroupDir = new STRawGroupDir(dir, this.getEncoding().displayName(), '$', '$');
            this.template = this.templateGroupDir.getInstanceOf(this.templateName);
        }

        protected void visit(Element element, ExecutionContext executionContext) {
            ST transform = this.templateGroupDir.getInstanceOf(this.templateName);
            Map beans = executionContext.getBeanContext().getBeanMap();
            for (Map.Entry entry : beans.entrySet()) {
                transform.add((String)entry.getKey(), entry.getValue());
            }
            String templatingResult = transform.render().trim();
            Element resultNode = TextSerializationUnit.createTextElement((Element)element, (String)templatingResult);
            this.processTemplateAction(element, resultNode, executionContext);
        }

        public boolean consumes(Object object) {
            return this.template.impl.getTemplateSource().indexOf(object.toString()) != -1;
        }
    }
}

