/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.yaml;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMapDigester {
    private static final String KEY_MAP_KEY_ELEMENT = "key";
    private static final String KEY_MAP_KEY_ELEMENT_FROM_ATTRIBUTE = "from";
    private static final String KEY_MAP_KEY_ELEMENT_TO_ATTRIBUTE = "to";

    public static HashMap<String, String> digest(Element keyMapElement) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        NodeList keys = keyMapElement.getElementsByTagNameNS("*", KEY_MAP_KEY_ELEMENT);
        for (int i = 0; keys != null && i < keys.getLength(); ++i) {
            Element keyElement = (Element)keys.item(i);
            String from = DomUtils.getAttributeValue((Element)keyElement, (String)KEY_MAP_KEY_ELEMENT_FROM_ATTRIBUTE);
            if (StringUtils.isBlank((String)from)) {
                throw new SmooksConfigurationException("The 'from' attribute isn't defined or is empty for the key element: " + keyElement);
            }
            from = from.trim();
            String value = DomUtils.getAttributeValue((Element)keyElement, (String)KEY_MAP_KEY_ELEMENT_TO_ATTRIBUTE);
            if (value == null && StringUtils.isBlank((String)(value = DomUtils.getAllText((Element)keyElement, (boolean)true)))) {
                value = null;
            }
            keyMap.put(from, value);
        }
        return keyMap;
    }
}

