/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.plugin.GetTextFunctionType;
import org.mini2Dx.gettext.plugin.antlr.JavaBaseListener;
import org.mini2Dx.gettext.plugin.antlr.JavaLexer;
import org.mini2Dx.gettext.plugin.antlr.JavaParser;
import org.mini2Dx.gettext.plugin.file.SourceFile;

public class JavaFile
extends JavaBaseListener
implements SourceFile {
    public static final String DEFAULT_COMMENT_FORMAT = "#.";
    private final List<TranslationEntry> translationEntries = new ArrayList<TranslationEntry>();
    private final String relativePath;
    private final Map<String, String> staticVariables = new HashMap<String, String>();
    private final Map<String, String> instanceVariables = new HashMap<String, String>();
    private final Map<String, String> localVariables = new HashMap<String, String>();
    private final Map<Integer, String> comments = new HashMap<Integer, String>();
    private ParseState parseState = ParseState.CLASS;
    private boolean nextFieldIsStatic = true;

    public JavaFile(File file, String relativePath) throws IOException {
        this(new FileInputStream(file), relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public JavaFile(InputStream inputStream, String relativePath) throws IOException {
        this(inputStream, relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public JavaFile(InputStream inputStream, String relativePath, String commentFormatPrefix) throws IOException {
        this.relativePath = relativePath;
        JavaLexer lexer = new JavaLexer(CharStreams.fromStream((InputStream)inputStream));
        CommonTokenStream commentStream = new CommonTokenStream((TokenSource)lexer, 1);
        commentStream.getNumberOfOnChannelTokens();
        for (Token token : commentStream.get(0, commentStream.size())) {
            if (token.getChannel() != 1) continue;
            String comment = token.getText();
            if (comment.startsWith("//")) {
                comment = comment.substring(2);
            }
            if (!comment.startsWith(commentFormatPrefix)) continue;
            comment = comment.substring(commentFormatPrefix.length());
            this.comments.put(token.getLine(), comment);
        }
        lexer.reset();
        CommonTokenStream codeStream = new CommonTokenStream((TokenSource)lexer, 0);
        JavaParser parser = new JavaParser((TokenStream)codeStream);
        JavaParser.CompilationUnitContext context = parser.compilationUnit();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)context);
        inputStream.close();
    }

    @Override
    public void enterMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
        this.parseState = ParseState.METHOD;
    }

    @Override
    public void exitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
        this.localVariables.clear();
        this.parseState = ParseState.CLASS;
    }

    @Override
    public void enterFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
        for (int i = 0; i < ctx.fieldModifier().size(); ++i) {
            if (ctx.fieldModifier(i).STATIC() == null) continue;
            this.nextFieldIsStatic = true;
            return;
        }
        this.nextFieldIsStatic = false;
    }

    @Override
    public void exitVariableDeclarator(JavaParser.VariableDeclaratorContext ctx) {
        String value;
        if (ctx.variableInitializer() != null) {
            value = ctx.variableInitializer().getText();
            if (value.startsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            } else if (this.staticVariables.containsKey(value)) {
                value = this.staticVariables.get(value);
            } else if (this.instanceVariables.containsKey(value)) {
                value = this.instanceVariables.get(value);
            } else if (this.localVariables.containsKey(value)) {
                value = this.localVariables.get(value);
            }
            value = value.replace("\"+\"", "");
        } else {
            value = "";
        }
        if (this.nextFieldIsStatic) {
            this.staticVariables.put(ctx.variableDeclaratorId().getText(), value);
        } else {
            switch (this.parseState) {
                case CLASS: {
                    this.instanceVariables.put(ctx.variableDeclaratorId().getText(), value);
                    break;
                }
                default: {
                    this.localVariables.put(ctx.variableDeclaratorId().getText(), value);
                }
            }
        }
    }

    @Override
    public void exitMethodInvocation_lfno_primary(JavaParser.MethodInvocation_lfno_primaryContext ctx) {
        this.generateTranslationEntry(ctx.getStart().getLine(), ctx.Identifier(), ctx.argumentList());
    }

    @Override
    public void exitMethodInvocation(JavaParser.MethodInvocationContext ctx) {
        this.generateTranslationEntry(ctx.getStart().getLine(), ctx.Identifier(), ctx.argumentList());
    }

    private void generateTranslationEntry(int lineNumber, TerminalNode identifier, JavaParser.ArgumentListContext argListCtxt) {
        if (identifier == null) {
            return;
        }
        if (!this.isGetTextMethod(identifier.getText())) {
            return;
        }
        TranslationEntry translationEntry = new TranslationEntry();
        translationEntry.setReference(this.relativePath + ":" + lineNumber);
        if (this.comments.containsKey(lineNumber - 1)) {
            translationEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
        }
        GetTextFunctionType functionType = this.getFunctionType(identifier, argListCtxt);
        switch (functionType) {
            case TR: 
            case TR_WITH_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 0));
                break;
            }
            case TR_WITH_LOCALE: 
            case TR_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                break;
            }
            case TRC: 
            case TRC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 0));
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                break;
            }
            case TRC_WITH_LOCALE: 
            case TRC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 1));
                translationEntry.setId(this.getArgument(argListCtxt, 2));
                break;
            }
            case TRN: 
            case TRN_WITH_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 0));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 1));
                break;
            }
            case TRN_WITH_LOCALE: 
            case TRN_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 2));
                break;
            }
            case TRNC: 
            case TRNC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 0));
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 2));
                break;
            }
            case TRNC_WITH_LOCALE: 
            case TRNC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 1));
                translationEntry.setId(this.getArgument(argListCtxt, 2));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 3));
            }
        }
        this.translationEntries.add(translationEntry);
    }

    private String getArgument(JavaParser.ArgumentListContext argumentListContext, int index) {
        if (index < 0) {
            return "";
        }
        if (index >= argumentListContext.expression().size()) {
            return "";
        }
        JavaParser.AssignmentExpressionContext expressionContext = argumentListContext.expression(index).assignmentExpression();
        if (expressionContext == null) {
            return "";
        }
        String value = expressionContext.getText().trim();
        if (this.staticVariables.containsKey(value)) {
            return this.staticVariables.get(value);
        }
        if (this.localVariables.containsKey(value)) {
            return this.localVariables.get(value);
        }
        if (this.instanceVariables.containsKey(value)) {
            return this.instanceVariables.get(value);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1).replace("\"+\"", "");
        }
        throw new RuntimeException("Could not determine variable value for " + value);
    }

    private GetTextFunctionType getFunctionType(TerminalNode identifier, JavaParser.ArgumentListContext argumentListContext) {
        String methodName = identifier.getText();
        int totalArgs = argumentListContext.expression().size();
        boolean firstArgIsLocale = true;
        if (argumentListContext.expression().size() > 1) {
            JavaParser.AssignmentExpressionContext expressionContext = argumentListContext.expression(0).assignmentExpression();
            if (expressionContext != null) {
                String value;
                String string = value = expressionContext.assignment() != null ? expressionContext.assignment().getText().trim() : expressionContext.conditionalExpression().getText().trim();
                if (this.staticVariables.containsKey(value)) {
                    firstArgIsLocale = false;
                } else if (this.localVariables.containsKey(value)) {
                    firstArgIsLocale = false;
                } else if (value.startsWith("\"") && value.endsWith("\"")) {
                    firstArgIsLocale = false;
                }
            }
        } else {
            firstArgIsLocale = false;
        }
        switch (methodName) {
            case "trnc": {
                if (firstArgIsLocale) {
                    return totalArgs > 4 ? GetTextFunctionType.TRNC_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TRNC_WITH_LOCALE;
                }
                return totalArgs > 3 ? GetTextFunctionType.TRNC_WITH_VALUES : GetTextFunctionType.TRNC;
            }
            case "trn": {
                if (firstArgIsLocale) {
                    return totalArgs > 3 ? GetTextFunctionType.TRN_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TRN_WITH_LOCALE;
                }
                return totalArgs > 2 ? GetTextFunctionType.TRN_WITH_VALUES : GetTextFunctionType.TRN;
            }
            case "trc": {
                if (firstArgIsLocale) {
                    return totalArgs > 3 ? GetTextFunctionType.TRC_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TRC_WITH_LOCALE;
                }
                return totalArgs > 2 ? GetTextFunctionType.TRC_WITH_VALUES : GetTextFunctionType.TRC;
            }
        }
        if (firstArgIsLocale) {
            return totalArgs > 2 ? GetTextFunctionType.TR_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TR_WITH_LOCALE;
        }
        return totalArgs > 1 ? GetTextFunctionType.TR_WITH_VALUES : GetTextFunctionType.TR;
    }

    private boolean isGetTextMethod(String methodName) {
        if (methodName.equals("tr")) {
            return true;
        }
        if (methodName.equals("trn")) {
            return true;
        }
        if (methodName.equals("trc")) {
            return true;
        }
        return methodName.equals("trnc");
    }

    @Override
    public void getTranslationEntries(List<TranslationEntry> result) {
        result.addAll(this.translationEntries);
    }

    @Override
    public void dispose() {
        this.staticVariables.clear();
        this.instanceVariables.clear();
        this.localVariables.clear();
        this.comments.clear();
        this.translationEntries.clear();
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    private static enum ParseState {
        CLASS,
        METHOD;

    }
}

