/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.plugin.GetTextFunctionType;
import org.mini2Dx.gettext.plugin.antlr.LuaBaseListener;
import org.mini2Dx.gettext.plugin.antlr.LuaLexer;
import org.mini2Dx.gettext.plugin.antlr.LuaParser;
import org.mini2Dx.gettext.plugin.file.SourceFile;

public class LuaFile
extends LuaBaseListener
implements SourceFile {
    public static final String DEFAULT_COMMENT_FORMAT = "#.";
    private final List<TranslationEntry> translationEntries = new ArrayList<TranslationEntry>();
    private final String relativePath;
    private final Map<String, String> variables = new HashMap<String, String>();
    private final Map<Integer, String> comments = new HashMap<Integer, String>();

    public LuaFile(File file, String relativePath) throws IOException {
        this(new FileInputStream(file), relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public LuaFile(InputStream inputStream, String relativePath) throws IOException {
        this(inputStream, relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public LuaFile(InputStream inputStream, String relativePath, String commentFormatPrefix) throws IOException {
        this.relativePath = relativePath;
        LuaLexer lexer = new LuaLexer(CharStreams.fromStream((InputStream)inputStream));
        CommonTokenStream commentStream = new CommonTokenStream((TokenSource)lexer, 1);
        commentStream.getNumberOfOnChannelTokens();
        for (Token token : commentStream.get(0, commentStream.size())) {
            if (token.getChannel() != 1) continue;
            String comment = token.getText();
            if (comment.startsWith("--")) {
                comment = comment.substring(2);
            }
            if (!comment.startsWith(commentFormatPrefix)) continue;
            comment = comment.substring(commentFormatPrefix.length());
            this.comments.put(token.getLine(), comment.trim());
        }
        lexer.reset();
        CommonTokenStream codeStream = new CommonTokenStream((TokenSource)lexer, 0);
        LuaParser parser = new LuaParser((TokenStream)codeStream);
        LuaParser.ChunkContext context = parser.chunk();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)context);
        inputStream.close();
    }

    @Override
    public void exitStat(LuaParser.StatContext ctx) {
        if (ctx.namelist() != null && ctx.explist() != null) {
            int i;
            ArrayList<String> variableNames = new ArrayList<String>();
            for (i = 0; i < ctx.namelist().NAME().size(); ++i) {
                variableNames.add(ctx.namelist().NAME().get(i).getText());
            }
            for (i = 0; i < ctx.explist().exp().size(); ++i) {
                String value = ctx.explist().exp(i).getText();
                if (this.variables.containsKey(value)) {
                    value = this.variables.get(value);
                } else if (value.startsWith("\"") && value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replace("\"..\"", "");
                }
                for (String variableName : variableNames) {
                    this.variables.put(variableName, value);
                }
            }
        }
    }

    @Override
    public void exitPrefixexp(LuaParser.PrefixexpContext ctx) {
        for (int i = 0; i < ctx.nameAndArgs().size(); ++i) {
            this.generateTranslationEntry(ctx.getStart().getLine(), ctx.nameAndArgs(i));
        }
    }

    @Override
    public void exitFunctioncall(LuaParser.FunctioncallContext ctx) {
        for (int i = 0; i < ctx.nameAndArgs().size(); ++i) {
            this.generateTranslationEntry(ctx.getStart().getLine(), ctx.nameAndArgs(i));
        }
    }

    private void generateTranslationEntry(int lineNumber, LuaParser.NameAndArgsContext ctx) {
        if (ctx == null || ctx.NAME() == null) {
            throw new RuntimeException("Error parsing lua file at line: " + lineNumber);
        }
        String functionName = ctx.NAME().getText();
        if (!this.isGetTextFunction(functionName)) {
            return;
        }
        TranslationEntry translationEntry = new TranslationEntry();
        translationEntry.setReference(this.relativePath + ":" + lineNumber);
        if (this.comments.containsKey(lineNumber - 1)) {
            translationEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
        }
        GetTextFunctionType functionType = this.getFunctionType(functionName, ctx.args());
        switch (functionType) {
            case TR: 
            case TR_WITH_VALUES: {
                translationEntry.setId(this.getArgument(ctx.args(), 0));
                break;
            }
            case TR_WITH_LOCALE: 
            case TR_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(ctx.args(), 1));
                break;
            }
            case TRC: 
            case TRC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(ctx.args(), 0));
                translationEntry.setId(this.getArgument(ctx.args(), 1));
                break;
            }
            case TRC_WITH_LOCALE: 
            case TRC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(ctx.args(), 1));
                translationEntry.setId(this.getArgument(ctx.args(), 2));
                break;
            }
            case TRN: 
            case TRN_WITH_VALUES: {
                translationEntry.setId(this.getArgument(ctx.args(), 0));
                translationEntry.setIdPlural(this.getArgument(ctx.args(), 1));
                break;
            }
            case TRN_WITH_LOCALE: 
            case TRN_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(ctx.args(), 1));
                translationEntry.setIdPlural(this.getArgument(ctx.args(), 2));
                break;
            }
            case TRNC: 
            case TRNC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(ctx.args(), 0));
                translationEntry.setId(this.getArgument(ctx.args(), 1));
                translationEntry.setIdPlural(this.getArgument(ctx.args(), 2));
                break;
            }
            case TRNC_WITH_LOCALE: 
            case TRNC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(ctx.args(), 1));
                translationEntry.setId(this.getArgument(ctx.args(), 2));
                translationEntry.setIdPlural(this.getArgument(ctx.args(), 3));
            }
        }
        this.translationEntries.add(translationEntry);
    }

    private GetTextFunctionType getFunctionType(String functionName, LuaParser.ArgsContext argsContext) {
        int totalArgs = argsContext.explist().exp().size();
        switch (functionName.toLowerCase()) {
            case "trnc": {
                return totalArgs > 1 ? GetTextFunctionType.TRNC_WITH_VALUES : GetTextFunctionType.TRNC;
            }
            case "trn": {
                return totalArgs > 1 ? GetTextFunctionType.TRN_WITH_VALUES : GetTextFunctionType.TRN;
            }
            case "trc": {
                return totalArgs > 2 ? GetTextFunctionType.TRC_WITH_VALUES : GetTextFunctionType.TRC;
            }
        }
        return totalArgs > 1 ? GetTextFunctionType.TR_WITH_VALUES : GetTextFunctionType.TR;
    }

    private String getArgument(LuaParser.ArgsContext argsContext, int index) {
        if (index < 0) {
            return "";
        }
        if (index >= argsContext.explist().exp().size()) {
            return "";
        }
        LuaParser.ExpContext expContext = argsContext.explist().exp(index);
        String value = expContext.getText().trim();
        if (this.variables.containsKey(value)) {
            return this.variables.get(value);
        }
        if (value.startsWith("\"") && value.startsWith("\"")) {
            return value.substring(1, value.length() - 1).replace("\"..\"", "");
        }
        throw new RuntimeException("Could not determine variable value for " + value);
    }

    @Override
    public void getTranslationEntries(List<TranslationEntry> result) {
        result.addAll(this.translationEntries);
    }

    @Override
    public void dispose() {
        this.comments.clear();
        this.variables.clear();
        this.translationEntries.clear();
    }

    private boolean isGetTextFunction(String functionName) {
        if (functionName.startsWith(":")) {
            functionName = functionName.substring(1);
        }
        if (functionName.equals("tr")) {
            return true;
        }
        if (functionName.equals("trn")) {
            return true;
        }
        if (functionName.equals("trc")) {
            return true;
        }
        return functionName.equals("trnc");
    }

    public String getRelativePath() {
        return this.relativePath;
    }
}

