/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.Utils;
import org.mini2Dx.gettext.plugin.file.SourceFile;

public class TextFile
implements SourceFile {
    public static final String DEFAULT_COMMENT_FORMAT = "#.";
    private final List<TranslationEntry> translationEntries = new ArrayList<TranslationEntry>();
    private final String relativePath;

    public TextFile(File file, String relativePath) throws IOException {
        this(new FileInputStream(file), relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public TextFile(InputStream inputStream, String relativePath) throws IOException {
        this(inputStream, relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public TextFile(InputStream inputStream, String relativePath, String commentFormatPrefix) throws IOException {
        this.relativePath = relativePath;
        Scanner scanner = new Scanner(inputStream);
        TranslationEntry entry = null;
        int lineNumber = 1;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (entry == null) {
                entry = new TranslationEntry();
            }
            if (!line.trim().isEmpty()) {
                if (line.startsWith(commentFormatPrefix)) {
                    entry.getExtractedComments().add(line.substring(commentFormatPrefix.length()).trim());
                } else {
                    entry.setReference(this.relativePath + ":" + lineNumber);
                    entry.setId(Utils.escapeDoubleQuotes((String)line));
                    this.translationEntries.add(entry);
                    entry = null;
                }
            }
            ++lineNumber;
        }
        scanner.close();
        inputStream.close();
    }

    @Override
    public void getTranslationEntries(List<TranslationEntry> result) {
        result.addAll(this.translationEntries);
    }

    @Override
    public void dispose() {
        this.translationEntries.clear();
    }

    public String getRelativePath() {
        return this.relativePath;
    }
}

