/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.plugin.GetTextFunctionType;
import org.mini2Dx.gettext.plugin.antlr.JavaBaseListener;
import org.mini2Dx.gettext.plugin.antlr.JavaLexer;
import org.mini2Dx.gettext.plugin.antlr.JavaParser;
import org.mini2Dx.gettext.plugin.file.SourceFile;

public class JavaFile
extends JavaBaseListener
implements SourceFile {
    public static final String DEFAULT_COMMENT_FORMAT = "#.";
    public static final String DEFAULT_FORCE_EXTRACT_FORMAT = "#!extract";
    protected final List<TranslationEntry> translationEntries = new ArrayList<TranslationEntry>();
    protected final String relativePath;
    protected final Map<String, String> staticVariables = new HashMap<String, String>();
    protected final Map<String, String> instanceVariables = new HashMap<String, String>();
    protected final Map<String, String> localVariables = new HashMap<String, String>();
    protected final Map<String, Integer> staticVariablesByLineNumber = new HashMap<String, Integer>();
    protected final Map<String, Integer> instanceVariablesByLineNumber = new HashMap<String, Integer>();
    protected final Map<String, Integer> localVariablesByLineNumber = new HashMap<String, Integer>();
    protected final Map<Integer, String> comments = new HashMap<Integer, String>();
    protected final Set<Integer> forceExtract = new HashSet<Integer>();
    private ParseState parseState = ParseState.CLASS;
    private boolean nextFieldIsStatic = true;

    public JavaFile(File file, String relativePath) throws IOException {
        this(new FileInputStream(file), relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public JavaFile(InputStream inputStream, String relativePath) throws IOException {
        this(inputStream, relativePath, DEFAULT_COMMENT_FORMAT);
    }

    public JavaFile(InputStream inputStream, String relativePath, String commentFormatPrefix) throws IOException {
        this(inputStream, relativePath, commentFormatPrefix, DEFAULT_FORCE_EXTRACT_FORMAT);
    }

    public JavaFile(InputStream inputStream, String relativePath, String commentFormatPrefix, String forceExtractFormat) throws IOException {
        this.relativePath = relativePath;
        JavaLexer lexer = new JavaLexer(CharStreams.fromStream((InputStream)inputStream));
        CommonTokenStream commentStream = new CommonTokenStream((TokenSource)lexer, 1);
        commentStream.getNumberOfOnChannelTokens();
        for (Token token : commentStream.get(0, commentStream.size())) {
            if (token.getChannel() != 1) continue;
            String comment = token.getText();
            if (comment.startsWith("//")) {
                comment = comment.substring(2);
            }
            if (comment.startsWith(commentFormatPrefix)) {
                comment = comment.substring(commentFormatPrefix.length());
                this.comments.put(token.getLine(), comment);
                continue;
            }
            if (!comment.startsWith(forceExtractFormat)) continue;
            this.forceExtract.add(token.getLine());
        }
        lexer.reset();
        CommonTokenStream codeStream = new CommonTokenStream((TokenSource)lexer, 0);
        JavaParser parser = new JavaParser((TokenStream)codeStream);
        JavaParser.CompilationUnitContext context = parser.compilationUnit();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)context);
        inputStream.close();
    }

    @Override
    public void enterMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
        this.parseState = ParseState.METHOD;
    }

    @Override
    public void exitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
        this.localVariables.clear();
        this.parseState = ParseState.CLASS;
    }

    @Override
    public void enterFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
        for (int i = 0; i < ctx.fieldModifier().size(); ++i) {
            if (ctx.fieldModifier(i).STATIC() == null) continue;
            this.nextFieldIsStatic = true;
            return;
        }
        this.nextFieldIsStatic = false;
    }

    @Override
    public void exitVariableDeclarator(JavaParser.VariableDeclaratorContext ctx) {
        String value;
        int lineNumber = ctx.start.getLine();
        if (ctx.variableInitializer() != null) {
            value = ctx.variableInitializer().getText();
            if (value.startsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            } else if (this.staticVariables.containsKey(value)) {
                value = this.staticVariables.get(value);
            } else if (this.instanceVariables.containsKey(value)) {
                value = this.instanceVariables.get(value);
            } else if (this.localVariables.containsKey(value)) {
                value = this.localVariables.get(value);
            }
            value = value.replace("\"+\"", "");
        } else {
            value = "";
        }
        if (this.nextFieldIsStatic) {
            String variableName = ctx.variableDeclaratorId().getText();
            this.staticVariables.put(variableName, value);
            this.staticVariablesByLineNumber.put(variableName, lineNumber);
        } else {
            String variableName = ctx.variableDeclaratorId().getText();
            switch (this.parseState) {
                case CLASS: {
                    this.instanceVariables.put(variableName, value);
                    this.instanceVariablesByLineNumber.put(variableName, lineNumber);
                    break;
                }
                default: {
                    this.localVariables.put(variableName, value);
                    this.localVariablesByLineNumber.put(variableName, lineNumber);
                }
            }
        }
        if (value == null || value.isEmpty()) {
            return;
        }
        if (this.forceExtract.contains(lineNumber - 1)) {
            this.createForcedEntryForValue(lineNumber, value);
        } else if (this.comments.containsKey(lineNumber - 1) && this.forceExtract.contains(lineNumber - 2)) {
            this.createForcedEntryForValue(lineNumber, value);
        }
    }

    private void createForcedEntryForValue(int lineNumber, String value) {
        TranslationEntry additionalEntry = new TranslationEntry();
        additionalEntry.setReference(this.relativePath + ":" + lineNumber);
        additionalEntry.setId(value);
        if (this.comments.containsKey(lineNumber - 1)) {
            additionalEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
        } else if (this.forceExtract.contains(lineNumber - 1) && this.comments.containsKey(lineNumber - 2)) {
            additionalEntry.getExtractedComments().add(this.comments.get(lineNumber - 2));
        }
        this.translationEntries.add(additionalEntry);
    }

    @Override
    public void exitMethodInvocation_lfno_primary(JavaParser.MethodInvocation_lfno_primaryContext ctx) {
        if (ctx.methodName() != null) {
            this.generateTranslationEntry(ctx.getStart().getLine(), ctx.methodName().getText(), ctx.argumentList());
        } else {
            this.generateTranslationEntry(ctx.getStart().getLine(), ctx.Identifier().getText(), ctx.argumentList());
        }
    }

    @Override
    public void exitMethodInvocation(JavaParser.MethodInvocationContext ctx) {
        if (ctx.methodName() != null) {
            this.generateTranslationEntry(ctx.getStart().getLine(), ctx.methodName().getText(), ctx.argumentList());
        } else {
            this.generateTranslationEntry(ctx.getStart().getLine(), ctx.Identifier().getText(), ctx.argumentList());
        }
    }

    protected boolean generateTranslationEntry(int lineNumber, String methodName, JavaParser.ArgumentListContext argListCtxt) {
        if (methodName == null) {
            return false;
        }
        if (!this.isGetTextMethod(lineNumber, methodName)) {
            return false;
        }
        TranslationEntry translationEntry = new TranslationEntry();
        translationEntry.setReference(this.relativePath + ":" + lineNumber);
        if (this.comments.containsKey(lineNumber - 1)) {
            translationEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
        }
        GetTextFunctionType functionType = this.getFunctionType(methodName, argListCtxt);
        switch (functionType) {
            case TR: 
            case TR_WITH_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 0));
                break;
            }
            case TR_WITH_LOCALE: 
            case TR_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                break;
            }
            case TRC: 
            case TRC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 0));
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                break;
            }
            case TRC_WITH_LOCALE: 
            case TRC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 1));
                translationEntry.setId(this.getArgument(argListCtxt, 2));
                break;
            }
            case TRN: 
            case TRN_WITH_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 0));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 1));
                break;
            }
            case TRN_WITH_LOCALE: 
            case TRN_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 2));
                break;
            }
            case TRNC: 
            case TRNC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 0));
                translationEntry.setId(this.getArgument(argListCtxt, 1));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 2));
                break;
            }
            case TRNC_WITH_LOCALE: 
            case TRNC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(argListCtxt, 1));
                translationEntry.setId(this.getArgument(argListCtxt, 2));
                translationEntry.setIdPlural(this.getArgument(argListCtxt, 3));
                break;
            }
            case FORCE_EXTRACT: {
                boolean initialEntryDone = false;
                for (int i = 0; i < argListCtxt.expression().size(); ++i) {
                    String argument;
                    int variableLineNumber;
                    String value = argListCtxt.expression(i).assignmentExpression().getText().trim();
                    if (this.staticVariables.containsKey(value) && (this.forceExtract.contains((variableLineNumber = this.staticVariablesByLineNumber.get(value).intValue()) - 1) || this.comments.containsKey(variableLineNumber - 1) && this.forceExtract.contains(variableLineNumber - 2)) || this.localVariables.containsKey(value) && (this.forceExtract.contains((variableLineNumber = this.localVariablesByLineNumber.get(value).intValue()) - 1) || this.comments.containsKey(variableLineNumber - 1) && this.forceExtract.contains(variableLineNumber - 2)) || this.instanceVariables.containsKey(value) && (this.forceExtract.contains((variableLineNumber = this.instanceVariablesByLineNumber.get(value).intValue()) - 1) || this.comments.containsKey(variableLineNumber - 1) && this.forceExtract.contains(variableLineNumber - 2)) || (argument = this.getArgument(argListCtxt, i)) == null || argument.isEmpty()) continue;
                    if (initialEntryDone) {
                        TranslationEntry additionalEntry = new TranslationEntry();
                        additionalEntry.setReference(this.relativePath + ":" + lineNumber);
                        additionalEntry.setId(argument);
                        if (this.comments.containsKey(lineNumber - 1)) {
                            additionalEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
                        } else if (this.forceExtract.contains(lineNumber - 1) && this.comments.containsKey(lineNumber - 2)) {
                            additionalEntry.getExtractedComments().add(this.comments.get(lineNumber - 2));
                        }
                        this.translationEntries.add(additionalEntry);
                        continue;
                    }
                    translationEntry.setId(argument);
                    initialEntryDone = true;
                }
                break;
            }
        }
        this.translationEntries.add(translationEntry);
        return true;
    }

    protected String getArgument(JavaParser.ArgumentListContext argumentListContext, int index) {
        if (index < 0) {
            return "";
        }
        if (index >= argumentListContext.expression().size()) {
            return "";
        }
        JavaParser.AssignmentExpressionContext expressionContext = argumentListContext.expression(index).assignmentExpression();
        if (expressionContext == null) {
            return "";
        }
        String value = expressionContext.getText().trim();
        if (this.staticVariables.containsKey(value)) {
            return this.staticVariables.get(value);
        }
        if (this.localVariables.containsKey(value)) {
            return this.localVariables.get(value);
        }
        if (this.instanceVariables.containsKey(value)) {
            return this.instanceVariables.get(value);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1).replace("\"+\"", "");
        }
        throw new RuntimeException("Could not determine variable value for " + value);
    }

    private GetTextFunctionType getFunctionType(String methodName, JavaParser.ArgumentListContext argumentListContext) {
        int totalArgs = argumentListContext.expression().size();
        boolean firstArgIsLocale = true;
        if (argumentListContext.expression().size() > 1) {
            JavaParser.AssignmentExpressionContext expressionContext = argumentListContext.expression(0).assignmentExpression();
            if (expressionContext != null) {
                String value;
                String string = value = expressionContext.assignment() != null ? expressionContext.assignment().getText().trim() : expressionContext.conditionalExpression().getText().trim();
                if (this.staticVariables.containsKey(value)) {
                    firstArgIsLocale = false;
                } else if (this.localVariables.containsKey(value)) {
                    firstArgIsLocale = false;
                } else if (value.startsWith("\"") && value.endsWith("\"")) {
                    firstArgIsLocale = false;
                }
            }
        } else {
            firstArgIsLocale = false;
        }
        switch (methodName) {
            case "trnc": {
                if (firstArgIsLocale) {
                    return totalArgs > 4 ? GetTextFunctionType.TRNC_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TRNC_WITH_LOCALE;
                }
                return totalArgs > 3 ? GetTextFunctionType.TRNC_WITH_VALUES : GetTextFunctionType.TRNC;
            }
            case "trn": {
                if (firstArgIsLocale) {
                    return totalArgs > 3 ? GetTextFunctionType.TRN_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TRN_WITH_LOCALE;
                }
                return totalArgs > 2 ? GetTextFunctionType.TRN_WITH_VALUES : GetTextFunctionType.TRN;
            }
            case "trc": {
                if (firstArgIsLocale) {
                    return totalArgs > 3 ? GetTextFunctionType.TRC_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TRC_WITH_LOCALE;
                }
                return totalArgs > 2 ? GetTextFunctionType.TRC_WITH_VALUES : GetTextFunctionType.TRC;
            }
            case "tr": {
                if (firstArgIsLocale) {
                    return totalArgs > 2 ? GetTextFunctionType.TR_WITH_LOCALE_AND_VALUES : GetTextFunctionType.TR_WITH_LOCALE;
                }
                return totalArgs > 1 ? GetTextFunctionType.TR_WITH_VALUES : GetTextFunctionType.TR;
            }
        }
        return GetTextFunctionType.FORCE_EXTRACT;
    }

    private boolean isGetTextMethod(int lineNumber, String methodName) {
        if (this.forceExtract.contains(lineNumber - 1)) {
            return true;
        }
        if (this.comments.containsKey(lineNumber - 1) && this.forceExtract.contains(lineNumber - 2)) {
            return true;
        }
        if (methodName.equals("tr")) {
            return true;
        }
        if (methodName.equals("trn")) {
            return true;
        }
        if (methodName.equals("trc")) {
            return true;
        }
        return methodName.equals("trnc");
    }

    @Override
    public void getTranslationEntries(List<TranslationEntry> result) {
        result.addAll(this.translationEntries);
    }

    @Override
    public void dispose() {
        this.staticVariables.clear();
        this.instanceVariables.clear();
        this.localVariables.clear();
        this.comments.clear();
        this.translationEntries.clear();
    }

    protected String getComment(int line) {
        if (this.comments.containsKey(line)) {
            return this.comments.get(line);
        }
        return null;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    private static enum ParseState {
        CLASS,
        METHOD;

    }
}

