/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Tuple;
import org.antlr.v4.runtime.misc.Tuple2;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.plugin.GetTextFunctionType;
import org.mini2Dx.gettext.plugin.antlr.LuaBaseListener;
import org.mini2Dx.gettext.plugin.antlr.LuaLexer;
import org.mini2Dx.gettext.plugin.antlr.LuaParser;
import org.mini2Dx.gettext.plugin.file.SourceFile;

public class LuaFile
extends LuaBaseListener
implements SourceFile {
    public static final String DEFAULT_COMMENT_FORMAT = "#.";
    public static final String DEFAULT_FORCE_EXTRACT_FORMAT = "#!extract";
    protected final String relativePath;
    protected final List<TranslationEntry> translationEntries = new ArrayList<TranslationEntry>();
    protected final Map<String, ArrayList<Tuple2<Integer, String>>> tables = new HashMap<String, ArrayList<Tuple2<Integer, String>>>();
    protected final Map<String, String> variables = new HashMap<String, String>();
    protected final Map<String, Integer> variableByLineNumber = new HashMap<String, Integer>();
    protected final Map<Integer, String> comments = new HashMap<Integer, String>();
    protected final Set<Integer> forceExtract = new HashSet<Integer>();

    public LuaFile(File file, String relativePath) throws IOException {
        this(new FileInputStream(file), relativePath, DEFAULT_COMMENT_FORMAT, DEFAULT_FORCE_EXTRACT_FORMAT);
    }

    public LuaFile(InputStream inputStream, String relativePath) throws IOException {
        this(inputStream, relativePath, DEFAULT_COMMENT_FORMAT, DEFAULT_FORCE_EXTRACT_FORMAT);
    }

    public LuaFile(InputStream inputStream, String relativePath, String commentFormatPrefix) throws IOException {
        this(inputStream, relativePath, commentFormatPrefix, DEFAULT_FORCE_EXTRACT_FORMAT);
    }

    public LuaFile(InputStream inputStream, String relativePath, String commentFormatPrefix, String forceExtractFormat) throws IOException {
        this.relativePath = relativePath;
        LuaLexer lexer = new LuaLexer(CharStreams.fromStream((InputStream)inputStream));
        CommonTokenStream commentStream = new CommonTokenStream((TokenSource)lexer, 1);
        commentStream.getNumberOfOnChannelTokens();
        for (Token token : commentStream.get(0, commentStream.size())) {
            if (token.getChannel() != 1) continue;
            String comment = token.getText();
            if (comment.startsWith("--")) {
                comment = comment.substring(2);
            }
            if (comment.startsWith(commentFormatPrefix)) {
                comment = comment.substring(commentFormatPrefix.length());
                this.comments.put(token.getLine(), comment.trim());
                continue;
            }
            if (!comment.startsWith(forceExtractFormat)) continue;
            this.forceExtract.add(token.getLine());
        }
        lexer.reset();
        CommonTokenStream codeStream = new CommonTokenStream((TokenSource)lexer, 0);
        LuaParser parser = new LuaParser((TokenStream)codeStream);
        LuaParser.ChunkContext context = parser.chunk();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)context);
        inputStream.close();
    }

    @Override
    public void exitTableconstructor(LuaParser.TableconstructorContext ctx) {
        ArrayList<Tuple2> tableFields = new ArrayList<Tuple2>();
        int lineNumber = ctx.start.getLine();
        if (ctx.fieldlist() != null) {
            List<? extends LuaParser.FieldContext> fields = ctx.fieldlist().field();
            for (LuaParser.FieldContext fieldContext : fields) {
                tableFields.add(Tuple.create((Object)lineNumber, (Object)this.stripQuotes(fieldContext.getText())));
            }
        }
        this.tables.put(String.valueOf(lineNumber), tableFields);
        if (this.comments.containsKey(lineNumber - 1)) {
            if (this.forceExtract.contains(lineNumber - 2)) {
                this.extractFromTable(lineNumber, String.valueOf(lineNumber));
            }
        } else if (this.forceExtract.contains(lineNumber - 1)) {
            this.extractFromTable(lineNumber, String.valueOf(lineNumber));
        }
    }

    private void extractFromTable(int lineNumber, String key) {
        ArrayList<Tuple2<Integer, String>> entries = this.tables.get(key);
        for (int i = 0; i < entries.size(); ++i) {
            Tuple2<Integer, String> entry = entries.get(i);
            TranslationEntry translationEntry = new TranslationEntry();
            translationEntry.setReference(this.relativePath + ":" + entry.getItem1());
            String comment = this.getComment(lineNumber);
            if (comment != null) {
                translationEntry.getExtractedComments().add(comment);
            }
            translationEntry.setId((String)entry.getItem2());
            this.translationEntries.add(translationEntry);
        }
    }

    @Override
    public void exitStat(LuaParser.StatContext ctx) {
        if (ctx.namelist() != null && ctx.explist() != null) {
            int i;
            ArrayList<String> variableNames = new ArrayList<String>();
            for (i = 0; i < ctx.namelist().NAME().size(); ++i) {
                variableNames.add(ctx.namelist().NAME().get(i).getText());
            }
            for (i = 0; i < ctx.explist().exp().size(); ++i) {
                String value = ctx.explist().exp(i).getText();
                if (this.variables.containsKey(value)) {
                    value = this.variables.get(value);
                } else if (value.startsWith("\"") && value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replace("\"..\"", "");
                }
                for (String variableName : variableNames) {
                    this.variables.put(variableName, value);
                    this.variableByLineNumber.put(variableName, ctx.start.getLine());
                }
            }
        }
    }

    @Override
    public void exitPrefixexp(LuaParser.PrefixexpContext ctx) {
        for (int i = 0; i < ctx.nameAndArgs().size(); ++i) {
            this.generateTranslationEntry(ctx.getStart().getLine(), "", ctx.nameAndArgs(i).NAME().getText(), ctx.nameAndArgs(i).args());
        }
    }

    @Override
    public void exitFunctioncall(LuaParser.FunctioncallContext ctx) {
        if (ctx.varOrExp() != null) {
            for (int i = 0; i < ctx.nameAndArgs().size(); ++i) {
                this.generateTranslationEntry(ctx.getStart().getLine(), ctx.varOrExp().var().NAME().getText(), ctx.nameAndArgs(i).NAME() != null ? ctx.nameAndArgs(i).NAME().getText() : ctx.varOrExp().var().NAME().getText(), ctx.nameAndArgs(i).args());
            }
        } else {
            for (int i = 0; i < ctx.nameAndArgs().size(); ++i) {
                this.generateTranslationEntry(ctx.getStart().getLine(), "", ctx.nameAndArgs(i).NAME().getText(), ctx.nameAndArgs(i).args());
            }
        }
    }

    protected boolean generateTranslationEntry(int lineNumber, String variableName, String functionName, LuaParser.ArgsContext args) {
        if (!this.isGetTextFunction(lineNumber, functionName)) {
            return false;
        }
        TranslationEntry translationEntry = new TranslationEntry();
        translationEntry.setReference(this.relativePath + ":" + lineNumber);
        if (this.comments.containsKey(lineNumber - 1)) {
            translationEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
        } else if (this.forceExtract.contains(lineNumber - 1) && this.comments.containsKey(lineNumber - 2)) {
            translationEntry.getExtractedComments().add(this.comments.get(lineNumber - 2));
        }
        GetTextFunctionType functionType = this.getFunctionType(functionName, args);
        switch (functionType) {
            case TR: 
            case TR_WITH_VALUES: {
                translationEntry.setId(this.getArgument(lineNumber, args, 0));
                break;
            }
            case TR_WITH_LOCALE: 
            case TR_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(lineNumber, args, 1));
                break;
            }
            case TRC: 
            case TRC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(lineNumber, args, 0));
                translationEntry.setId(this.getArgument(lineNumber, args, 1));
                break;
            }
            case TRC_WITH_LOCALE: 
            case TRC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(lineNumber, args, 1));
                translationEntry.setId(this.getArgument(lineNumber, args, 2));
                break;
            }
            case TRN: 
            case TRN_WITH_VALUES: {
                translationEntry.setId(this.getArgument(lineNumber, args, 0));
                translationEntry.setIdPlural(this.getArgument(lineNumber, args, 1));
                break;
            }
            case TRN_WITH_LOCALE: 
            case TRN_WITH_LOCALE_AND_VALUES: {
                translationEntry.setId(this.getArgument(lineNumber, args, 1));
                translationEntry.setIdPlural(this.getArgument(lineNumber, args, 2));
                break;
            }
            case TRNC: 
            case TRNC_WITH_VALUES: {
                translationEntry.setContext(this.getArgument(lineNumber, args, 0));
                translationEntry.setId(this.getArgument(lineNumber, args, 1));
                translationEntry.setIdPlural(this.getArgument(lineNumber, args, 2));
                break;
            }
            case TRNC_WITH_LOCALE: 
            case TRNC_WITH_LOCALE_AND_VALUES: {
                translationEntry.setContext(this.getArgument(lineNumber, args, 1));
                translationEntry.setId(this.getArgument(lineNumber, args, 2));
                translationEntry.setIdPlural(this.getArgument(lineNumber, args, 3));
                break;
            }
            case FORCE_EXTRACT: {
                if (this.tables.containsKey(String.valueOf(lineNumber))) {
                    return false;
                }
                boolean initialEntryDone = false;
                for (int i = 0; i < args.explist().exp().size(); ++i) {
                    String resolvedValue;
                    LuaParser.ExpContext expContext = args.explist().exp(i);
                    String value = expContext.getText().trim();
                    if (this.variables.containsKey(value)) {
                        int variableLineNumber = this.variableByLineNumber.get(value);
                        if (this.forceExtract.contains(variableLineNumber - 1) || this.comments.containsKey(variableLineNumber - 1) && this.forceExtract.contains(variableLineNumber - 2)) continue;
                        resolvedValue = this.variables.get(value);
                    } else {
                        if (!value.startsWith("\"")) continue;
                        resolvedValue = this.stripQuotes(value);
                    }
                    if (initialEntryDone) {
                        TranslationEntry additionalEntry = new TranslationEntry();
                        additionalEntry.setReference(this.relativePath + ":" + lineNumber);
                        additionalEntry.setId(resolvedValue);
                        if (this.comments.containsKey(lineNumber - 1)) {
                            additionalEntry.getExtractedComments().add(this.comments.get(lineNumber - 1));
                        } else if (this.forceExtract.contains(lineNumber - 1) && this.comments.containsKey(lineNumber - 2)) {
                            additionalEntry.getExtractedComments().add(this.comments.get(lineNumber - 2));
                        }
                        this.translationEntries.add(additionalEntry);
                        continue;
                    }
                    translationEntry.setId(resolvedValue);
                    initialEntryDone = true;
                }
                break;
            }
        }
        this.translationEntries.add(translationEntry);
        return true;
    }

    private GetTextFunctionType getFunctionType(String functionName, LuaParser.ArgsContext argsContext) {
        int totalArgs = argsContext.explist().exp().size();
        switch (functionName.toLowerCase()) {
            case "trnc": {
                return totalArgs > 1 ? GetTextFunctionType.TRNC_WITH_VALUES : GetTextFunctionType.TRNC;
            }
            case "trn": {
                return totalArgs > 1 ? GetTextFunctionType.TRN_WITH_VALUES : GetTextFunctionType.TRN;
            }
            case "trc": {
                return totalArgs > 2 ? GetTextFunctionType.TRC_WITH_VALUES : GetTextFunctionType.TRC;
            }
            case "tr": {
                return totalArgs > 1 ? GetTextFunctionType.TR_WITH_VALUES : GetTextFunctionType.TR;
            }
        }
        return GetTextFunctionType.FORCE_EXTRACT;
    }

    protected String getArgument(int lineNumber, LuaParser.ArgsContext argsContext, int index) {
        if (argsContext.explist() == null) {
            return "";
        }
        if (argsContext.explist().exp() == null) {
            return "";
        }
        if (index < 0) {
            return "";
        }
        if (index >= argsContext.explist().exp().size()) {
            return "";
        }
        LuaParser.ExpContext expContext = argsContext.explist().exp(index);
        String value = expContext.getText().trim();
        if (this.variables.containsKey(value)) {
            return this.variables.get(value);
        }
        if (value.startsWith("\"") && value.startsWith("\"")) {
            return value.substring(1, value.length() - 1).replace("\"..\"", "");
        }
        throw new RuntimeException("Could not determine variable value for " + value + " on line " + lineNumber);
    }

    @Override
    public void getTranslationEntries(List<TranslationEntry> result) {
        result.addAll(this.translationEntries);
    }

    @Override
    public void dispose() {
        this.comments.clear();
        this.variables.clear();
        this.translationEntries.clear();
    }

    private boolean isGetTextFunction(int lineNumber, String functionName) {
        if (this.forceExtract.contains(lineNumber - 1)) {
            return true;
        }
        if (this.comments.containsKey(lineNumber - 1) && this.forceExtract.contains(lineNumber - 2)) {
            return true;
        }
        if (functionName.startsWith(":")) {
            functionName = functionName.substring(1);
        }
        if (functionName.equals("tr")) {
            return true;
        }
        if (functionName.equals("trn")) {
            return true;
        }
        if (functionName.equals("trc")) {
            return true;
        }
        return functionName.equals("trnc");
    }

    protected String getComment(int line) {
        if (this.comments.containsKey(line)) {
            return this.comments.get(line);
        }
        return null;
    }

    protected String stripQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public String getRelativePath() {
        return this.relativePath;
    }
}

