/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.mini2Dx.gettext.plugin.file.JavaFile;
import org.mini2Dx.gettext.plugin.file.LuaFile;
import org.mini2Dx.gettext.plugin.file.SourceFile;
import org.mini2Dx.gettext.plugin.file.TextFile;

public class SourceFileParser {
    public static SourceFile parse(File file, String relativePath, String commentFormat, String forceExtractFormat) throws IOException {
        String suffix;
        String filename = file.getName().toLowerCase();
        if (!filename.contains(".")) {
            throw new RuntimeException("Cannot file type for file " + relativePath);
        }
        switch (suffix = filename.substring(filename.lastIndexOf(46) + 1)) {
            case "lua": {
                return new LuaFile(new FileInputStream(file), relativePath, commentFormat, forceExtractFormat);
            }
            case "java": {
                return new JavaFile(new FileInputStream(file), relativePath, commentFormat, forceExtractFormat);
            }
            case "txt": {
                return new TextFile(new FileInputStream(file), relativePath, commentFormat);
            }
        }
        throw new RuntimeException("Unable to generate .pot file from " + suffix + " file type");
    }
}

