/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.mini2Dx.gettext.PoParseSettings;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.antlr.GetTextBaseListener;
import org.mini2Dx.gettext.antlr.GetTextLexer;
import org.mini2Dx.gettext.antlr.GetTextParser;

public class PoFile
extends GetTextBaseListener {
    private static final String EMPTY_STRING = "";
    private final Locale locale;
    private final PoParseSettings parseSettings;
    private final List<TranslationEntry> entries = new ArrayList<TranslationEntry>();
    private TranslationEntry currentEntry = null;

    public PoFile(Locale locale, File file) throws IOException {
        this(locale, new FileReader(file));
    }

    public PoFile(Locale locale, Reader reader) throws IOException {
        this(locale, reader, PoParseSettings.DEFAULT);
    }

    public PoFile(Locale locale, InputStream inputStream) throws IOException {
        this(locale, inputStream, PoParseSettings.DEFAULT);
    }

    public PoFile(Locale locale, File file, PoParseSettings parseSettings) throws IOException {
        this(locale, new FileReader(file), parseSettings);
    }

    public PoFile(Locale locale, Reader reader, PoParseSettings parseSettings) throws IOException {
        this.locale = locale;
        this.parseSettings = parseSettings;
        this.read((CharStream)CharStreams.fromReader((Reader)reader));
        reader.close();
    }

    public PoFile(Locale locale, InputStream inputStream, PoParseSettings parseSettings) throws IOException {
        this.locale = locale;
        this.parseSettings = parseSettings;
        this.read(CharStreams.fromStream((InputStream)inputStream));
        inputStream.close();
    }

    public PoFile(Locale locale) {
        this.locale = locale;
        this.parseSettings = PoParseSettings.DEFAULT;
    }

    private void read(CharStream charStream) {
        GetTextLexer lexer = new GetTextLexer(charStream);
        GetTextParser parser = new GetTextParser((TokenStream)new BufferedTokenStream((TokenSource)lexer));
        GetTextParser.PoContext context = parser.po();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        parseTreeWalker.walk((ParseTreeListener)this, (ParseTree)context);
    }

    public void saveTo(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file, StandardCharsets.UTF_8.name());
        for (TranslationEntry translationEntry : this.entries) {
            translationEntry.writeTo(printWriter);
            printWriter.println();
        }
        printWriter.flush();
        printWriter.close();
    }

    @Override
    public void enterEntry(GetTextParser.EntryContext ctx) {
        this.currentEntry = new TranslationEntry();
    }

    @Override
    public void exitEntry(GetTextParser.EntryContext ctx) {
        this.entries.add(this.currentEntry);
        this.currentEntry = null;
    }

    @Override
    public void exitMessageContext(GetTextParser.MessageContextContext ctx) {
        if (ctx.quotedTextLiteral() != null && ctx.quotedTextLiteral().size() > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < ctx.quotedTextLiteral().size(); ++i) {
                if (ctx.quotedTextLiteral(i) == null) continue;
                result.append(this.unquoteText(ctx.quotedTextLiteral(i).getText()));
            }
            this.currentEntry.setContext(result.toString());
        } else if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.setContext(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitMessageId(GetTextParser.MessageIdContext ctx) {
        if (ctx.quotedTextLiteral() != null && ctx.quotedTextLiteral().size() > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < ctx.quotedTextLiteral().size(); ++i) {
                if (ctx.quotedTextLiteral(i) == null) continue;
                result.append(this.unquoteText(ctx.quotedTextLiteral(i).getText()));
            }
            this.currentEntry.setId(result.toString());
        } else if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.setId(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitMessageIdPlural(GetTextParser.MessageIdPluralContext ctx) {
        if (ctx.quotedTextLiteral() != null && ctx.quotedTextLiteral().size() > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < ctx.quotedTextLiteral().size(); ++i) {
                if (ctx.quotedTextLiteral(i) == null) continue;
                result.append(this.unquoteText(ctx.quotedTextLiteral(i).getText()));
            }
            this.currentEntry.setIdPlural(result.toString());
        } else if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.setIdPlural(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitMessageNumStr(GetTextParser.MessageNumStrContext ctx) {
        int index = ctx.numericIndexLiteral() != null ? Integer.parseInt(ctx.numericIndexLiteral().digits().getText()) : 0;
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.setString(index, ctx.unquotedTextLiteral().getText());
        } else {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < ctx.quotedTextLiteral().size(); ++i) {
                if (ctx.quotedTextLiteral(i) == null) continue;
                result.append(this.unquoteText(ctx.quotedTextLiteral(i).getText()));
            }
            this.currentEntry.setString(index, result.toString());
        }
    }

    @Override
    public void exitMessageStr(GetTextParser.MessageStrContext ctx) {
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.setString(0, ctx.unquotedTextLiteral().getText());
        } else {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < ctx.quotedTextLiteral().size(); ++i) {
                if (ctx.quotedTextLiteral(i) == null) continue;
                result.append(this.unquoteText(ctx.quotedTextLiteral(i).getText()));
            }
            this.currentEntry.setString(0, result.toString());
        }
    }

    @Override
    public void exitExtractedComment(GetTextParser.ExtractedCommentContext ctx) {
        if (!this.parseSettings.extractedComments) {
            return;
        }
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.getExtractedComments().add(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitFlag(GetTextParser.FlagContext ctx) {
        if (!this.parseSettings.flags) {
            return;
        }
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.getFlags().add(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitMergeComment(GetTextParser.MergeCommentContext ctx) {
        if (!this.parseSettings.mergeComments) {
            return;
        }
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.getMergeComments().add(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitReference(GetTextParser.ReferenceContext ctx) {
        if (!this.parseSettings.reference) {
            return;
        }
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.setReference(ctx.unquotedTextLiteral().getText());
        }
    }

    @Override
    public void exitTranslatorComment(GetTextParser.TranslatorCommentContext ctx) {
        if (!this.parseSettings.translatorComments) {
            return;
        }
        if (ctx.unquotedTextLiteral() != null) {
            this.currentEntry.getTranslatorComments().add(ctx.unquotedTextLiteral().getText());
        }
    }

    private String unquoteText(String str) {
        if (str.length() == 2) {
            return EMPTY_STRING;
        }
        return str.substring(1, str.length() - 1);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<TranslationEntry> getEntries() {
        return this.entries;
    }
}

