/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext;

import java.util.HashMap;
import java.util.Map;
import org.mini2Dx.gettext.TranslationEntry;

public class TranslationContext {
    private final Map<String, TranslationEntry> entriesBySingularId = new HashMap<String, TranslationEntry>();
    private final Map<String, TranslationEntry> entriesByPluralId = new HashMap<String, TranslationEntry>();

    public String tr(String sourceText) {
        return this.getResult(sourceText, this.entriesBySingularId.get(sourceText));
    }

    public String trn(String sourceText, String sourcePluralText, int n) {
        TranslationEntry entry = sourcePluralText == null || !this.entriesByPluralId.containsKey(sourcePluralText) ? this.entriesBySingularId.get(sourceText) : this.entriesByPluralId.get(sourcePluralText);
        if (n >= entry.getStrings().size()) {
            return entry.getStrings().get(entry.getStrings().size() - 1);
        }
        return entry.getStrings().get(n);
    }

    public TranslationEntry getEntryBySingularForm(String id) {
        return this.entriesBySingularId.get(id);
    }

    public TranslationEntry getEntryByPluralForm(String idPlural) {
        return this.entriesByPluralId.get(idPlural);
    }

    public void add(TranslationEntry entry) {
        if (entry.getId() != null) {
            this.entriesBySingularId.put(entry.getId(), entry);
        }
        if (entry.getIdPlural() != null) {
            this.entriesByPluralId.put(entry.getIdPlural(), entry);
        }
    }

    private String getResult(String sourceText, TranslationEntry entry) {
        if (entry == null) {
            return sourceText;
        }
        if (entry.getStrings().isEmpty()) {
            return sourceText;
        }
        return entry.getStrings().get(0);
    }
}

