/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TranslationEntry {
    private final List<String> translatorComments = new ArrayList<String>(2);
    private final List<String> extractedComments = new ArrayList<String>(2);
    private final List<String> flags = new ArrayList<String>(2);
    private final List<String> mergeComments = new ArrayList<String>(2);
    private String reference;
    private String context;
    private String id;
    private String idPlural;
    private final ArrayList<String> strings = new ArrayList(2);

    public void writeTo(PrintWriter printWriter) {
        for (String comment : this.translatorComments) {
            printWriter.println("# " + comment);
        }
        for (String comment : this.extractedComments) {
            printWriter.println("#. " + comment);
        }
        for (String comment : this.flags) {
            printWriter.println("#, " + comment);
        }
        for (String comment : this.mergeComments) {
            printWriter.println("#| " + comment);
        }
        if (this.reference != null && !this.reference.isEmpty()) {
            printWriter.println("#: " + this.reference);
        }
        if (this.context != null && !this.context.isEmpty()) {
            if (this.context.contains("\"")) {
                printWriter.println("msgctxt " + this.context);
            } else {
                printWriter.println("msgctxt \"" + this.context + "\"");
            }
        }
        if (this.id != null && !this.id.isEmpty()) {
            if (this.id.contains("\"")) {
                printWriter.println("msgid " + this.id);
            } else {
                printWriter.println("msgid \"" + this.id + "\"");
            }
        }
        if (this.idPlural != null && !this.idPlural.isEmpty()) {
            if (this.idPlural.contains("\"")) {
                printWriter.println("msgid_plural " + this.idPlural);
            } else {
                printWriter.println("msgid_plural \"" + this.idPlural + "\"");
            }
        }
        if (this.strings.isEmpty()) {
            if (this.idPlural != null && !this.idPlural.isEmpty()) {
                printWriter.println("msgstr[0] \"\"");
                printWriter.println("msgstr[1] \"\"");
                printWriter.println("msgstr[2] \"\"");
            } else {
                printWriter.println("msgstr \"\"");
            }
        } else if (this.strings.size() > 1) {
            for (int i = 0; i < this.strings.size(); ++i) {
                String str = this.strings.get(i);
                if (str == null) {
                    printWriter.println("msgstr[" + i + "] \"\"");
                    continue;
                }
                if (str.contains("\"")) {
                    printWriter.println("msgstr[" + i + "] " + str);
                    continue;
                }
                printWriter.println("msgstr[" + i + "] \"" + str + "\"");
            }
            if (this.idPlural.contains("\"")) {
                printWriter.println("msgid_plural " + this.idPlural);
            } else {
                printWriter.println("msgid_plural \"" + this.idPlural + "\"");
            }
        } else if (this.strings.get(0).contains("\"")) {
            printWriter.println("msgstr " + this.strings.get(0));
        } else {
            printWriter.println("msgstr \"" + this.strings.get(0) + "\"");
        }
    }

    public List<String> getTranslatorComments() {
        return this.translatorComments;
    }

    public List<String> getExtractedComments() {
        return this.extractedComments;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getMergeComments() {
        return this.mergeComments;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdPlural() {
        return this.idPlural;
    }

    public void setIdPlural(String idPlural) {
        this.idPlural = idPlural;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public void setString(int index, String str) {
        this.strings.ensureCapacity(index);
        while (index >= this.strings.size()) {
            this.strings.add(null);
        }
        this.strings.set(index, str);
    }
}

