/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mini2Dx.gettext.PoFile;
import org.mini2Dx.gettext.TranslationEntry;
import org.mini2Dx.gettext.TranslationMap;

public class GetText {
    private static final Map<Locale, TranslationMap> TRANSLATIONS = new HashMap<Locale, TranslationMap>();
    private static Locale LOCALE = Locale.ENGLISH;

    public static String tr(String sourceText) {
        return GetText.tr(LOCALE, sourceText);
    }

    public static String tr(String sourceText, Object ... values) {
        return GetText.tr(LOCALE, sourceText, values);
    }

    public static String trc(String context, String sourceText) {
        return GetText.trc(LOCALE, context, sourceText);
    }

    public static String trc(String context, String sourceText, Object ... values) {
        return GetText.trc(LOCALE, context, sourceText, values);
    }

    public static String trn(String sourceText, String sourcePluralText, int n) {
        return GetText.trn(LOCALE, sourceText, sourcePluralText, n);
    }

    public static String trn(String sourceText, String sourcePluralText, int n, Object ... values) {
        return GetText.trn(LOCALE, sourceText, sourcePluralText, n, values);
    }

    public static String trnc(String context, String sourceText, String sourcePluralText, int n) {
        return GetText.trnc(LOCALE, context, sourceText, sourcePluralText, n);
    }

    public static String trnc(String context, String sourceText, String sourcePluralText, int n, Object ... values) {
        return GetText.trnc(LOCALE, context, sourceText, sourcePluralText, n, values);
    }

    public static String tr(Locale locale, String sourceText) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return sourceText;
        }
        return translationMap.tr(sourceText);
    }

    public static String tr(Locale locale, String sourceText, Object ... values) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return MessageFormat.format(TranslationMap.messageFormatSanitise(sourceText), values);
        }
        return translationMap.tr(sourceText, values);
    }

    public static String trc(Locale locale, String context, String sourceText) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return sourceText;
        }
        return translationMap.trc(context, sourceText);
    }

    public static String trc(Locale locale, String context, String sourceText, Object ... values) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return MessageFormat.format(TranslationMap.messageFormatSanitise(sourceText), values);
        }
        return translationMap.trc(context, sourceText, values);
    }

    public static String trn(Locale locale, String sourceText, String sourcePluralText, int n) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return sourcePluralText;
        }
        return translationMap.trn(sourceText, sourcePluralText, n);
    }

    public static String trn(Locale locale, String sourceText, String sourcePluralText, int n, Object ... values) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            if (n > 1) {
                return MessageFormat.format(TranslationMap.messageFormatSanitise(sourcePluralText), values);
            }
            return MessageFormat.format(TranslationMap.messageFormatSanitise(sourceText), values);
        }
        return translationMap.trn(sourceText, sourcePluralText, n, values);
    }

    public static String trnc(Locale locale, String context, String sourceText, String sourcePluralText, int n) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return sourcePluralText;
        }
        return translationMap.trnc(context, sourceText, sourcePluralText, n);
    }

    public static String trnc(Locale locale, String context, String sourceText, String sourcePluralText, int n, Object ... values) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            if (n > 1) {
                return MessageFormat.format(TranslationMap.messageFormatSanitise(sourcePluralText), values);
            }
            return MessageFormat.format(TranslationMap.messageFormatSanitise(sourceText), values);
        }
        return translationMap.trnc(context, sourceText, sourcePluralText, n, values);
    }

    public static TranslationEntry getTranslationEntry(Locale locale, String context, String sourceText) {
        TranslationMap translationMap = TRANSLATIONS.get(locale);
        if (translationMap == null) {
            return null;
        }
        return translationMap.getEntry(context, sourceText);
    }

    public static void add(PoFile poFile) {
        if (!TRANSLATIONS.containsKey(poFile.getLocale())) {
            TRANSLATIONS.put(poFile.getLocale(), new TranslationMap(poFile.getLocale()));
        }
        TRANSLATIONS.get(poFile.getLocale()).add(poFile);
    }

    public static void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        LOCALE = locale;
    }
}

