/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.ruby;

import java.util.Map;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.mini2Dx.miniscript.core.EmbeddedScriptInvoker;
import org.mini2Dx.miniscript.core.GameScript;
import org.mini2Dx.miniscript.core.PerThreadGameScript;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionResult;
import org.mini2Dx.miniscript.core.ScriptExecutor;
import org.mini2Dx.miniscript.core.exception.ScriptSkippedException;
import org.mini2Dx.miniscript.ruby.RubyEmbeddedScriptInvoker;
import org.mini2Dx.miniscript.ruby.RubyScriptExecutorPool;

public class RubyScriptExecutor
implements ScriptExecutor<EmbedEvalUnit> {
    private final RubyScriptExecutorPool executorPool;

    public RubyScriptExecutor(RubyScriptExecutorPool executorPool) {
        this.executorPool = executorPool;
    }

    public GameScript<EmbedEvalUnit> compile(String script) {
        return new PerThreadGameScript(script);
    }

    public ScriptExecutionResult execute(int scriptId, GameScript<EmbedEvalUnit> s, ScriptBindings bindings, boolean returnResult) throws Exception {
        PerThreadGameScript script = (PerThreadGameScript)s;
        ScriptingContainer scriptingContainer = this.executorPool.getLocalScriptingContainer();
        RubyEmbeddedScriptInvoker embeddedScriptInvoker = (RubyEmbeddedScriptInvoker)((Object)this.executorPool.getEmbeddedScriptInvokerPool().allocate());
        embeddedScriptInvoker.setScriptBindings(bindings);
        embeddedScriptInvoker.setScriptExecutor(this);
        embeddedScriptInvoker.setParentScriptId(scriptId);
        scriptingContainer.getVarMap().putAll((Map)bindings);
        scriptingContainer.getVarMap().put("scriptParentId", (Object)-1);
        scriptingContainer.getVarMap().put("scriptId", (Object)scriptId);
        scriptingContainer.getVarMap().put("scripts", (Object)embeddedScriptInvoker);
        if (!script.hasScript()) {
            script.setScript((Object)scriptingContainer.parse(script.getContent(), new int[0]));
        }
        try {
            EmbedEvalUnit embedEvalUnit = (EmbedEvalUnit)script.getScript();
            embedEvalUnit.run();
        }
        catch (Exception e) {
            if (e instanceof ScriptSkippedException || e.getCause() instanceof ScriptSkippedException) {
                throw new ScriptSkippedException();
            }
            throw e;
        }
        this.executorPool.getEmbeddedScriptInvokerPool().release((Object)embeddedScriptInvoker);
        if (!returnResult) {
            scriptingContainer.clear();
            return null;
        }
        ScriptExecutionResult executionResult = new ScriptExecutionResult(scriptingContainer.getVarMap().getMap());
        scriptingContainer.clear();
        return executionResult;
    }

    public void executeEmbedded(int parentScriptId, int scriptId, GameScript<EmbedEvalUnit> s, EmbeddedScriptInvoker embeddedScriptInvoker, ScriptBindings bindings) throws Exception {
        throw new RuntimeException("Embedded synchronous script invokes not supported in Ruby.");
    }

    public void release() {
        this.executorPool.release(this);
    }
}

