/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.ruby;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.mini2Dx.miniscript.core.GameScript;
import org.mini2Dx.miniscript.core.GameScriptingEngine;
import org.mini2Dx.miniscript.core.PerThreadGameScript;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionTask;
import org.mini2Dx.miniscript.core.ScriptExecutor;
import org.mini2Dx.miniscript.core.ScriptExecutorPool;
import org.mini2Dx.miniscript.core.ScriptInvocationListener;
import org.mini2Dx.miniscript.core.SynchronizedObjectPool;
import org.mini2Dx.miniscript.core.exception.InsufficientCompilersException;
import org.mini2Dx.miniscript.core.exception.NoSuchScriptException;
import org.mini2Dx.miniscript.core.exception.ScriptExecutorUnavailableException;
import org.mini2Dx.miniscript.core.util.ReadWriteBlockingQueue;
import org.mini2Dx.miniscript.core.util.ReadWriteMap;
import org.mini2Dx.miniscript.ruby.RubyEmbeddedScriptInvoker;
import org.mini2Dx.miniscript.ruby.RubyScriptExecutor;

public class RubyScriptExecutorPool
implements ScriptExecutorPool<EmbedEvalUnit> {
    private final Map<Long, ScriptingContainer> threadCompilers = new ReadWriteMap();
    private final Map<Integer, PerThreadGameScript<EmbedEvalUnit>> scripts = new ReadWriteMap();
    private final Map<String, Integer> filepathToScriptId = new ReadWriteMap();
    private final Map<Integer, String> scriptIdToFilepath = new ReadWriteMap();
    private final BlockingQueue<ScriptExecutor<EmbedEvalUnit>> executors;
    private final GameScriptingEngine gameScriptingEngine;
    private final SynchronizedObjectPool<RubyEmbeddedScriptInvoker> embeddedScriptInvokerPool = new SynchronizedObjectPool<RubyEmbeddedScriptInvoker>(){

        protected RubyEmbeddedScriptInvoker construct() {
            return new RubyEmbeddedScriptInvoker(RubyScriptExecutorPool.this.gameScriptingEngine, RubyScriptExecutorPool.this);
        }
    };

    public RubyScriptExecutorPool(GameScriptingEngine gameScriptingEngine, int poolSize) {
        this.gameScriptingEngine = gameScriptingEngine;
        this.executors = new ReadWriteBlockingQueue(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.executors.offer(new RubyScriptExecutor(this));
        }
    }

    public int getCompiledScriptId(String filepath) {
        return this.filepathToScriptId.getOrDefault(filepath, -1);
    }

    public String getCompiledScriptPath(int scriptId) {
        return this.scriptIdToFilepath.get(scriptId);
    }

    public int preCompileScript(String filepath, String scriptContent) throws InsufficientCompilersException {
        PerThreadGameScript script = new PerThreadGameScript(scriptContent);
        this.scripts.put(script.getId(), (PerThreadGameScript<EmbedEvalUnit>)script);
        this.filepathToScriptId.put(filepath, script.getId());
        this.scriptIdToFilepath.put(script.getId(), filepath);
        return script.getId();
    }

    public ScriptExecutionTask<?> execute(int taskId, int scriptId, ScriptBindings scriptBindings, ScriptInvocationListener invocationListener, boolean syncCall) {
        ScriptExecutor<EmbedEvalUnit> executor = this.allocateExecutor();
        if (executor == null) {
            throw new ScriptExecutorUnavailableException(scriptId);
        }
        if (!this.scripts.containsKey(scriptId)) {
            executor.release();
            throw new NoSuchScriptException(scriptId);
        }
        return new ScriptExecutionTask(taskId, this.gameScriptingEngine, executor, scriptId, (GameScript)this.scripts.get(scriptId), scriptBindings, invocationListener, syncCall);
    }

    public void release(ScriptExecutor<EmbedEvalUnit> executor) {
        try {
            this.executors.put(executor);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private ScriptExecutor<EmbedEvalUnit> allocateExecutor() {
        try {
            return this.executors.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ScriptingContainer getLocalScriptingContainer() {
        long threadId = Thread.currentThread().getId();
        if (!this.threadCompilers.containsKey(threadId)) {
            ScriptingContainer scriptingContainer = new ScriptingContainer(LocalContextScope.SINGLETHREAD, LocalVariableBehavior.PERSISTENT);
            scriptingContainer.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
            this.threadCompilers.put(threadId, scriptingContainer);
        }
        return this.threadCompilers.get(threadId);
    }

    public GameScriptingEngine getGameScriptingEngine() {
        return this.gameScriptingEngine;
    }

    GameScript<EmbedEvalUnit> getScript(int scriptId) {
        return (GameScript)this.scripts.get(scriptId);
    }

    public SynchronizedObjectPool<RubyEmbeddedScriptInvoker> getEmbeddedScriptInvokerPool() {
        return this.embeddedScriptInvokerPool;
    }
}

