/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsserverlookup.android21;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.RouteInfo;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.minidns.dnsserverlookup.AbstractDNSServerLookupMechanism;

public class AndroidUsingLinkProperties
extends AbstractDNSServerLookupMechanism {
    private final ConnectivityManager connectivityManager;

    protected AndroidUsingLinkProperties(Context context) {
        super(AndroidUsingLinkProperties.class.getSimpleName(), 998);
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public boolean isAvailable() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @TargetApi(value=21)
    public List<String> getDnsServerAddresses() {
        Network[] networks = this.connectivityManager.getAllNetworks();
        if (networks == null) {
            return null;
        }
        ArrayList<String> servers = new ArrayList<String>(networks.length * 2);
        for (Network network : networks) {
            LinkProperties linkProperties = this.connectivityManager.getLinkProperties(network);
            if (linkProperties == null) continue;
            if (AndroidUsingLinkProperties.hasDefaultRoute(linkProperties)) {
                servers.addAll(0, AndroidUsingLinkProperties.toListOfStrings((Collection)linkProperties.getDnsServers()));
                continue;
            }
            servers.addAll(AndroidUsingLinkProperties.toListOfStrings((Collection)linkProperties.getDnsServers()));
        }
        if (servers.isEmpty()) {
            return null;
        }
        return servers;
    }

    @TargetApi(value=21)
    private static boolean hasDefaultRoute(LinkProperties linkProperties) {
        for (RouteInfo route : linkProperties.getRoutes()) {
            if (!route.isDefaultRoute()) continue;
            return true;
        }
        return false;
    }
}

