/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.minidns.cache.LRUCache;
import org.minidns.dnsmessage.DNSMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DNSName;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class ExtendedLRUCache
extends LRUCache {
    public ExtendedLRUCache() {
        this(512);
    }

    public ExtendedLRUCache(int capacity) {
        super(capacity);
    }

    public ExtendedLRUCache(int capacity, long maxTTL) {
        super(capacity, maxTTL);
    }

    @Override
    protected void putNormalized(DNSMessage q, DNSMessage message) {
        super.putNormalized(q, message);
        HashMap<DNSMessage, List<Record<? extends Data>>> extraCaches = new HashMap<DNSMessage, List<Record<? extends Data>>>(message.additionalSection.size());
        this.gather(extraCaches, q, message.answerSection, null);
        this.gather(extraCaches, q, message.authoritySection, null);
        this.gather(extraCaches, q, message.additionalSection, null);
        this.putExtraCaches(message, extraCaches);
    }

    @Override
    public void offer(DNSMessage query, DNSMessage reply, DNSName authoritativeZone) {
        assert (!reply.authoritativeAnswer);
        HashMap<DNSMessage, List<Record<? extends Data>>> extraCaches = new HashMap<DNSMessage, List<Record<? extends Data>>>(reply.additionalSection.size());
        this.gather(extraCaches, query, reply.authoritySection, authoritativeZone);
        this.gather(extraCaches, query, reply.additionalSection, authoritativeZone);
        this.putExtraCaches(reply, extraCaches);
    }

    private final void gather(Map<DNSMessage, List<Record<? extends Data>>> extraCaches, DNSMessage q, List<Record<? extends Data>> records, DNSName authoritativeZone) {
        for (Record<? extends Data> extraRecord : records) {
            DNSMessage.Builder additionalRecordQuestionBuilder;
            if (!this.shouldGather(extraRecord, q.getQuestion(), authoritativeZone) || (additionalRecordQuestionBuilder = extraRecord.getQuestionMessage()) == null) continue;
            additionalRecordQuestionBuilder.copyFlagsFrom(q);
            additionalRecordQuestionBuilder.setAdditionalResourceRecords((Collection)q.additionalSection);
            DNSMessage additionalRecordQuestion = additionalRecordQuestionBuilder.build();
            if (additionalRecordQuestion.equals((Object)q)) continue;
            List<Record<? extends Data>> additionalRecords = extraCaches.get(additionalRecordQuestion);
            if (additionalRecords == null) {
                additionalRecords = new LinkedList<Record<? extends Data>>();
                extraCaches.put(additionalRecordQuestion, additionalRecords);
            }
            additionalRecords.add(extraRecord);
        }
    }

    private final void putExtraCaches(DNSMessage reply, Map<DNSMessage, List<Record<? extends Data>>> extraCaches) {
        for (Map.Entry<DNSMessage, List<Record<? extends Data>>> entry : extraCaches.entrySet()) {
            DNSMessage question = entry.getKey();
            DNSMessage answer = reply.asBuilder().setQuestion(question.getQuestion()).setAuthoritativeAnswer(true).addAnswers((Collection)entry.getValue()).build();
            super.putNormalized(question, answer);
        }
    }

    protected boolean shouldGather(Record<? extends Data> extraRecord, Question question, DNSName authoritativeZone) {
        boolean extraRecordIsChildOfQuestion = extraRecord.name.isChildOf(question.name);
        boolean extraRecordIsChildOfAuthoritativeZone = false;
        if (authoritativeZone != null) {
            extraRecordIsChildOfAuthoritativeZone = extraRecord.name.isChildOf(authoritativeZone);
        }
        return extraRecordIsChildOfQuestion || extraRecordIsChildOfAuthoritativeZone;
    }
}

