/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.minidns.DnsCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Record;

public class LruCache
extends DnsCache {
    protected long missCount = 0L;
    protected long expireCount = 0L;
    protected long hitCount = 0L;
    protected int capacity;
    protected long maxTTL;
    protected LinkedHashMap<DnsMessage, DnsMessage> backend;

    public LruCache(final int capacity, long maxTTL) {
        this.capacity = capacity;
        this.maxTTL = maxTTL;
        this.backend = new LinkedHashMap<DnsMessage, DnsMessage>(Math.min(capacity + (capacity + 3) / 4 + 2, 11), 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<DnsMessage, DnsMessage> eldest) {
                return this.size() > capacity;
            }
        };
    }

    public LruCache(int capacity) {
        this(capacity, Long.MAX_VALUE);
    }

    public LruCache() {
        this(512);
    }

    @Override
    protected synchronized void putNormalized(DnsMessage q, DnsMessage message) {
        if (message.receiveTimestamp <= 0L) {
            return;
        }
        this.backend.put(q, message);
    }

    @Override
    protected synchronized DnsMessage getNormalized(DnsMessage q) {
        DnsMessage message = this.backend.get(q);
        if (message == null) {
            ++this.missCount;
            return null;
        }
        long ttl = this.maxTTL;
        for (Record r : message.answerSection) {
            ttl = Math.min(ttl, r.ttl);
        }
        if (message.receiveTimestamp + ttl < System.currentTimeMillis()) {
            ++this.missCount;
            ++this.expireCount;
            this.backend.remove(q);
            return null;
        }
        ++this.hitCount;
        return message;
    }

    public synchronized void clear() {
        this.backend.clear();
        this.missCount = 0L;
        this.hitCount = 0L;
        this.expireCount = 0L;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getExpireCount() {
        return this.expireCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public String toString() {
        return "LRUCache{usage=" + this.backend.size() + "/" + this.capacity + ", hits=" + this.hitCount + ", misses=" + this.missCount + ", expires=" + this.expireCount + "}";
    }

    @Override
    public void offer(DnsMessage query, DnsMessage reply, DnsName knownAuthoritativeZone) {
    }
}

