/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.IOException;
import org.minidns.dnsmessage.DnsMessage;

public abstract class MiniDnsException
extends IOException {
    private static final long serialVersionUID = 1L;

    protected MiniDnsException(String message) {
        super(message);
    }

    public static class NullResultException
    extends MiniDnsException {
        private static final long serialVersionUID = 1L;
        private final DnsMessage request;

        public NullResultException(DnsMessage request) {
            super("The request yielded a 'null' result while resolving.");
            this.request = request;
        }

        public DnsMessage getRequest() {
            return this.request;
        }
    }

    public static class IdMismatch
    extends MiniDnsException {
        private static final long serialVersionUID = 1L;
        private final DnsMessage request;
        private final DnsMessage response;

        public IdMismatch(DnsMessage request, DnsMessage response) {
            super(IdMismatch.getString(request, response));
            assert (request.id != response.id);
            this.request = request;
            this.response = response;
        }

        public DnsMessage getRequest() {
            return this.request;
        }

        public DnsMessage getResponse() {
            return this.response;
        }

        private static String getString(DnsMessage request, DnsMessage response) {
            return "The response's ID doesn't matches the request ID. Request: " + request.id + ". Response: " + response.id;
        }
    }
}

