/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MiniDnsInitialization {
    private static final Logger LOGGER;
    static final String VERSION;

    static {
        String miniDnsVersion;
        LOGGER = Logger.getLogger(MiniDnsInitialization.class.getName());
        BufferedReader reader = null;
        try {
            InputStream is = MiniDnsInitialization.class.getClassLoader().getResourceAsStream("org.minidns/version");
            reader = new BufferedReader(new InputStreamReader(is));
            miniDnsVersion = reader.readLine();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not determine MiniDNS version", e);
            miniDnsVersion = "unkown";
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "IOException closing stream", e);
                }
            }
        }
        VERSION = miniDnsVersion;
    }
}

