/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.IOException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minidns.DnsCache;
import org.minidns.MiniDnsFuture;
import org.minidns.cache.LruCache;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.CachedDnsQueryResult;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.Data;
import org.minidns.record.NS;
import org.minidns.record.Record;
import org.minidns.source.DnsDataSource;
import org.minidns.source.NetworkDataSource;

public abstract class AbstractDnsClient {
    protected static final LruCache DEFAULT_CACHE = new LruCache();
    protected static final Logger LOGGER = Logger.getLogger(AbstractDnsClient.class.getName());
    private final DnsDataSource.OnResponseCallback onResponseCallback = new DnsDataSource.OnResponseCallback(){

        @Override
        public void onResponse(DnsMessage requestMessage, DnsQueryResult responseMessage) {
            Question q = requestMessage.getQuestion();
            if (AbstractDnsClient.this.cache != null && AbstractDnsClient.this.isResponseCacheable(q, responseMessage)) {
                AbstractDnsClient.this.cache.put(requestMessage.asNormalizedVersion(), responseMessage);
            }
        }
    };
    protected final Random random;
    protected final Random insecureRandom = new Random();
    protected final DnsCache cache;
    protected DnsDataSource dataSource = new NetworkDataSource();
    protected static IpVersionSetting DEFAULT_IP_VERSION_SETTING = IpVersionSetting.v4v6;
    protected IpVersionSetting ipVersionSetting = DEFAULT_IP_VERSION_SETTING;

    public static void setDefaultIpVersion(IpVersionSetting preferedIpVersion) {
        if (preferedIpVersion == null) {
            throw new IllegalArgumentException();
        }
        DEFAULT_IP_VERSION_SETTING = preferedIpVersion;
    }

    public void setPreferedIpVersion(IpVersionSetting preferedIpVersion) {
        if (preferedIpVersion == null) {
            throw new IllegalArgumentException();
        }
        this.ipVersionSetting = preferedIpVersion;
    }

    public IpVersionSetting getPreferedIpVersion() {
        return this.ipVersionSetting;
    }

    protected AbstractDnsClient(DnsCache cache) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e1) {
            random = new SecureRandom();
        }
        this.random = random;
        this.cache = cache;
    }

    protected AbstractDnsClient() {
        this(DEFAULT_CACHE);
    }

    public final DnsQueryResult query(String name, Record.TYPE type, Record.CLASS clazz) throws IOException {
        Question q = new Question((CharSequence)name, type, clazz);
        return this.query(q);
    }

    public final DnsQueryResult query(DnsName name, Record.TYPE type) throws IOException {
        Question q = new Question(name, type, Record.CLASS.IN);
        return this.query(q);
    }

    public final DnsQueryResult query(CharSequence name, Record.TYPE type) throws IOException {
        Question q = new Question(name, type, Record.CLASS.IN);
        return this.query(q);
    }

    public DnsQueryResult query(Question q) throws IOException {
        DnsMessage.Builder query = this.buildMessage(q);
        return this.query(query);
    }

    protected abstract DnsQueryResult query(DnsMessage.Builder var1) throws IOException;

    public final MiniDnsFuture<DnsQueryResult, IOException> queryAsync(CharSequence name, Record.TYPE type) {
        Question q = new Question(name, type, Record.CLASS.IN);
        return this.queryAsync(q);
    }

    public final MiniDnsFuture<DnsQueryResult, IOException> queryAsync(Question q) {
        DnsMessage.Builder query = this.buildMessage(q);
        return this.queryAsync(query);
    }

    protected MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage.Builder query) {
        DnsQueryResult result;
        MiniDnsFuture.InternalMiniDnsFuture<DnsQueryResult, IOException> future = new MiniDnsFuture.InternalMiniDnsFuture<DnsQueryResult, IOException>();
        try {
            result = this.query(query);
        }
        catch (IOException e) {
            future.setException(e);
            return future;
        }
        future.setResult(result);
        return future;
    }

    public final DnsQueryResult query(Question q, InetAddress server, int port) throws IOException {
        DnsMessage query = this.getQueryFor(q);
        return this.query(query, server, port);
    }

    public final DnsQueryResult query(DnsMessage requestMessage, InetAddress address, int port) throws IOException {
        DnsQueryResult responseMessage;
        CachedDnsQueryResult cachedDnsQueryResult = responseMessage = this.cache == null ? null : this.cache.get(requestMessage);
        if (responseMessage != null) {
            return responseMessage;
        }
        Question q = requestMessage.getQuestion();
        Level TRACE_LOG_LEVEL = Level.FINE;
        LOGGER.log(TRACE_LOG_LEVEL, "Asking {0} on {1} for {2} with:\n{3}", new Object[]{address, port, q, requestMessage});
        try {
            responseMessage = this.dataSource.query(requestMessage, address, port);
        }
        catch (IOException e) {
            LOGGER.log(TRACE_LOG_LEVEL, "IOException {0} on {1} while resolving {2}: {3}", new Object[]{address, port, q, e});
            throw e;
        }
        LOGGER.log(TRACE_LOG_LEVEL, "Response from {0} on {1} for {2}:\n{3}", new Object[]{address, port, q, responseMessage});
        this.onResponseCallback.onResponse(requestMessage, responseMessage);
        return responseMessage;
    }

    public final MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage requestMessage, InetAddress address, int port) {
        CachedDnsQueryResult responseMessage;
        CachedDnsQueryResult cachedDnsQueryResult = responseMessage = this.cache == null ? null : this.cache.get(requestMessage);
        if (responseMessage != null) {
            return MiniDnsFuture.from(responseMessage);
        }
        Question q = requestMessage.getQuestion();
        Level TRACE_LOG_LEVEL = Level.FINE;
        LOGGER.log(TRACE_LOG_LEVEL, "Asynchronusly asking {0} on {1} for {2} with:\n{3}", new Object[]{address, port, q, requestMessage});
        return this.dataSource.queryAsync(requestMessage, address, port, this.onResponseCallback);
    }

    protected boolean isResponseCacheable(Question q, DnsQueryResult result) {
        DnsMessage dnsMessage = result.response;
        for (Record record : dnsMessage.answerSection) {
            if (!record.isAnswer(q)) continue;
            return true;
        }
        return false;
    }

    final DnsMessage.Builder buildMessage(Question question) {
        DnsMessage.Builder message = DnsMessage.builder();
        message.setQuestion(question);
        message.setId(this.random.nextInt());
        message = this.newQuestion(message);
        return message;
    }

    protected abstract DnsMessage.Builder newQuestion(DnsMessage.Builder var1);

    public DnsQueryResult query(String name, Record.TYPE type, Record.CLASS clazz, InetAddress address, int port) throws IOException {
        Question q = new Question((CharSequence)name, type, clazz);
        return this.query(q, address, port);
    }

    public DnsQueryResult query(String name, Record.TYPE type, Record.CLASS clazz, InetAddress address) throws IOException {
        Question q = new Question((CharSequence)name, type, clazz);
        return this.query(q, address);
    }

    public DnsQueryResult query(String name, Record.TYPE type, InetAddress address) throws IOException {
        Question q = new Question((CharSequence)name, type, Record.CLASS.IN);
        return this.query(q, address);
    }

    public final DnsQueryResult query(DnsMessage query, InetAddress host) throws IOException {
        return this.query(query, host, 53);
    }

    public DnsQueryResult query(Question q, InetAddress address) throws IOException {
        return this.query(q, address, 53);
    }

    public final MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage query, InetAddress dnsServer) {
        return this.queryAsync(query, dnsServer, 53);
    }

    public DnsDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DnsDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException();
        }
        this.dataSource = dataSource;
    }

    public DnsCache getCache() {
        return this.cache;
    }

    protected DnsMessage getQueryFor(Question q) {
        DnsMessage.Builder messageBuilder = this.buildMessage(q);
        DnsMessage query = messageBuilder.build();
        return query;
    }

    private <D extends Data> Set<D> getCachedRecordsFor(DnsName dnsName, Record.TYPE type) {
        Question dnsNameNs = new Question(dnsName, type);
        DnsMessage queryDnsNameNs = this.getQueryFor(dnsNameNs);
        CachedDnsQueryResult cachedResult = this.cache.get(queryDnsNameNs);
        if (cachedResult == null) {
            return Collections.emptySet();
        }
        return cachedResult.response.getAnswersFor(dnsNameNs);
    }

    public Set<NS> getCachedNameserverRecordsFor(DnsName dnsName) {
        return this.getCachedRecordsFor(dnsName, Record.TYPE.NS);
    }

    public Set<A> getCachedIPv4AddressesFor(DnsName dnsName) {
        return this.getCachedRecordsFor(dnsName, Record.TYPE.A);
    }

    public Set<AAAA> getCachedIPv6AddressesFor(DnsName dnsName) {
        return this.getCachedRecordsFor(dnsName, Record.TYPE.AAAA);
    }

    private <D extends Data> Set<D> getCachedIPNameserverAddressesFor(DnsName dnsName, Record.TYPE type) {
        Set<NS> nsSet = this.getCachedNameserverRecordsFor(dnsName);
        if (nsSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<A> res = new HashSet<A>(3 * nsSet.size());
        for (NS ns : nsSet) {
            Set<A> addresses;
            switch (type) {
                case A: {
                    addresses = this.getCachedIPv4AddressesFor(ns.target);
                    break;
                }
                case AAAA: {
                    addresses = this.getCachedIPv6AddressesFor(ns.target);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            res.addAll(addresses);
        }
        return res;
    }

    public Set<A> getCachedIPv4NameserverAddressesFor(DnsName dnsName) {
        return this.getCachedIPNameserverAddressesFor(dnsName, Record.TYPE.A);
    }

    public Set<AAAA> getCachedIPv6NameserverAddressesFor(DnsName dnsName) {
        return this.getCachedIPNameserverAddressesFor(dnsName, Record.TYPE.AAAA);
    }

    public static enum IpVersionSetting {
        v4only(true, false),
        v6only(false, true),
        v4v6(true, true),
        v6v4(true, true);

        public final boolean v4;
        public final boolean v6;

        private IpVersionSetting(boolean v4, boolean v6) {
            this.v4 = v4;
            this.v6 = v6;
        }
    }
}

