/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class RrSet {
    public final DnsName name;
    public final Record.TYPE type;
    public final Record.CLASS clazz;
    public final Set<Record<? extends Data>> records;

    private RrSet(DnsName name, Record.TYPE type, Record.CLASS clazz, Set<Record<? extends Data>> records) {
        this.name = name;
        this.type = type;
        this.clazz = clazz;
        this.records = Collections.unmodifiableSet(records);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.name).append('\t').append(this.clazz).append('\t').append(this.type).append('\n');
        for (Record<? extends Data> record : this.records) {
            sb.append(record).append('\n');
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DnsName name;
        private Record.TYPE type;
        private Record.CLASS clazz;
        Set<Record<? extends Data>> records = new LinkedHashSet<Record<? extends Data>>(8);

        private Builder() {
        }

        public Builder addRecord(Record<? extends Data> record) {
            if (this.name == null) {
                this.name = record.name;
                this.type = record.type;
                this.clazz = record.clazz;
            } else if (!this.couldContain(record)) {
                throw new IllegalArgumentException("Can not add " + record + " to RRSet " + this.name + ' ' + this.type + ' ' + this.clazz);
            }
            boolean didNotExist = this.records.add(record);
            assert (didNotExist);
            return this;
        }

        public boolean couldContain(Record<? extends Data> record) {
            if (this.name == null) {
                return true;
            }
            return this.name.equals((Object)record.name) && this.type == record.type && this.clazz == record.clazz;
        }

        public boolean addIfPossible(Record<? extends Data> record) {
            if (!this.couldContain(record)) {
                return false;
            }
            this.addRecord(record);
            return true;
        }

        public RrSet build() {
            if (this.name == null) {
                throw new IllegalStateException();
            }
            return new RrSet(this.name, this.type, this.clazz, this.records);
        }
    }
}

