/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.minidns.dnslabel.DnsLabel;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DigestCalculator;
import org.minidns.dnssec.DnssecUnverifiedReason;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.SignatureVerifier;
import org.minidns.dnssec.algorithms.AlgorithmMap;
import org.minidns.record.DNSKEY;
import org.minidns.record.Data;
import org.minidns.record.DelegatingDnssecRR;
import org.minidns.record.NSEC;
import org.minidns.record.NSEC3;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;
import org.minidns.util.Base32;

class Verifier {
    private static final AlgorithmMap algorithmMap = AlgorithmMap.INSTANCE;

    Verifier() {
    }

    public static DnssecUnverifiedReason verify(Record<DNSKEY> dnskeyRecord, DelegatingDnssecRR ds) throws DnssecValidationFailedException {
        byte[] digest;
        DNSKEY dnskey = (DNSKEY)dnskeyRecord.payloadData;
        DigestCalculator digestCalculator = algorithmMap.getDsDigestCalculator(ds.digestType);
        if (digestCalculator == null) {
            return new DnssecUnverifiedReason.AlgorithmNotSupportedReason(ds.digestTypeByte, ds.getType(), dnskeyRecord);
        }
        byte[] dnskeyData = dnskey.toByteArray();
        byte[] dnskeyOwner = dnskeyRecord.name.getBytes();
        byte[] combined = new byte[dnskeyOwner.length + dnskeyData.length];
        System.arraycopy(dnskeyOwner, 0, combined, 0, dnskeyOwner.length);
        System.arraycopy(dnskeyData, 0, combined, dnskeyOwner.length, dnskeyData.length);
        try {
            digest = digestCalculator.digest(combined);
        }
        catch (Exception e) {
            return new DnssecUnverifiedReason.AlgorithmExceptionThrownReason(ds.digestType, "DS", dnskeyRecord, e);
        }
        if (!ds.digestEquals(digest)) {
            throw new DnssecValidationFailedException(dnskeyRecord, "SEP is not properly signed by parent DS!");
        }
        return null;
    }

    public static DnssecUnverifiedReason verify(List<Record<? extends Data>> records, RRSIG rrsig, DNSKEY key) throws IOException {
        SignatureVerifier signatureVerifier = algorithmMap.getSignatureVerifier(rrsig.algorithm);
        if (signatureVerifier == null) {
            return new DnssecUnverifiedReason.AlgorithmNotSupportedReason(rrsig.algorithmByte, rrsig.getType(), records.get(0));
        }
        byte[] combine = Verifier.combine(rrsig, records);
        if (signatureVerifier.verify(combine, rrsig, key)) {
            return null;
        }
        throw new DnssecValidationFailedException(records, "Signature is invalid.");
    }

    public static DnssecUnverifiedReason verifyNsec(Record<NSEC> nsecRecord, Question q) {
        NSEC nsec = (NSEC)nsecRecord.payloadData;
        if (nsecRecord.name.equals((Object)q.name) && !nsec.types.contains(q.type)) {
            return null;
        }
        if (Verifier.nsecMatches(q.name, nsecRecord.name, nsec.next)) {
            return null;
        }
        return new DnssecUnverifiedReason.NSECDoesNotMatchReason(q, nsecRecord);
    }

    public static DnssecUnverifiedReason verifyNsec3(DnsName zone, Record<NSEC3> nsec3record, Question q) {
        NSEC3 nsec3 = (NSEC3)nsec3record.payloadData;
        DigestCalculator digestCalculator = algorithmMap.getNsecDigestCalculator(nsec3.hashAlgorithm);
        if (digestCalculator == null) {
            return new DnssecUnverifiedReason.AlgorithmNotSupportedReason(nsec3.hashAlgorithmByte, nsec3.getType(), nsec3record);
        }
        byte[] bytes = Verifier.nsec3hash(digestCalculator, nsec3, q.name, nsec3.iterations);
        String s = Base32.encodeToString((byte[])bytes);
        DnsName computedNsec3Record = DnsName.from((String)(s + "." + zone));
        if (nsec3record.name.equals((Object)computedNsec3Record)) {
            if (nsec3.types.contains(q.type)) {
                return new DnssecUnverifiedReason.NSECDoesNotMatchReason(q, nsec3record);
            }
            return null;
        }
        if (Verifier.nsecMatches(s, nsec3record.name.getHostpart(), Base32.encodeToString((byte[])nsec3.getNextHashed()))) {
            return null;
        }
        return new DnssecUnverifiedReason.NSECDoesNotMatchReason(q, nsec3record);
    }

    static byte[] combine(RRSIG rrsig, List<Record<? extends Data>> records) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            rrsig.writePartialSignature(dos);
            DnsName sigName = records.get((int)0).name;
            if (!sigName.isRootLabel()) {
                if (sigName.getLabelCount() < rrsig.labels) {
                    throw new DnssecValidationFailedException("Invalid RRsig record");
                }
                if (sigName.getLabelCount() > rrsig.labels) {
                    sigName = DnsName.from((DnsLabel)DnsLabel.WILDCARD_LABEL, (DnsName)sigName.stripToLabels((int)rrsig.labels));
                }
            }
            ArrayList<byte[]> recordBytes = new ArrayList<byte[]>(records.size());
            for (Record<? extends Data> record : records) {
                Record ref = new Record(sigName, record.type, record.clazzValue, rrsig.originalTtl, record.payloadData);
                recordBytes.add(ref.toByteArray());
            }
            final int offset = sigName.size() + 10;
            Collections.sort(recordBytes, new Comparator<byte[]>(){

                @Override
                public int compare(byte[] b1, byte[] b2) {
                    for (int i = offset; i < b1.length && i < b2.length; ++i) {
                        if (b1[i] == b2[i]) continue;
                        return (b1[i] & 0xFF) - (b2[i] & 0xFF);
                    }
                    return b1.length - b2.length;
                }
            });
            for (byte[] recordByte : recordBytes) {
                dos.write(recordByte);
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    static boolean nsecMatches(String test, String lowerBound, String upperBound) {
        return Verifier.nsecMatches(DnsName.from((String)test), DnsName.from((String)lowerBound), DnsName.from((String)upperBound));
    }

    static boolean nsecMatches(DnsName test, DnsName lowerBound, DnsName upperBound) {
        int lowerParts = lowerBound.getLabelCount();
        int upperParts = upperBound.getLabelCount();
        int testParts = test.getLabelCount();
        if (testParts > lowerParts && !test.isChildOf(lowerBound) && test.stripToLabels(lowerParts).compareTo(lowerBound) < 0) {
            return false;
        }
        if (testParts <= lowerParts && test.compareTo(lowerBound.stripToLabels(testParts)) < 0) {
            return false;
        }
        if (testParts > upperParts && !test.isChildOf(upperBound) && test.stripToLabels(upperParts).compareTo(upperBound) > 0) {
            return false;
        }
        return testParts > upperParts || test.compareTo(upperBound.stripToLabels(testParts)) < 0;
    }

    static byte[] nsec3hash(DigestCalculator digestCalculator, NSEC3 nsec3, DnsName ownerName, int iterations) {
        return Verifier.nsec3hash(digestCalculator, nsec3.getSalt(), ownerName.getBytes(), iterations);
    }

    static byte[] nsec3hash(DigestCalculator digestCalculator, byte[] salt, byte[] data, int iterations) {
        while (iterations-- >= 0) {
            byte[] combined = new byte[data.length + salt.length];
            System.arraycopy(data, 0, combined, 0, data.length);
            System.arraycopy(salt, 0, combined, data.length, salt.length);
            data = digestCalculator.digest(combined);
        }
        return data;
    }
}

