/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minidns.constants.DnssecConstants;
import org.minidns.dnssec.DigestCalculator;
import org.minidns.dnssec.DnssecValidatorInitializationException;
import org.minidns.dnssec.SignatureVerifier;
import org.minidns.dnssec.algorithms.DsaSignatureVerifier;
import org.minidns.dnssec.algorithms.EcdsaSignatureVerifier;
import org.minidns.dnssec.algorithms.EcgostSignatureVerifier;
import org.minidns.dnssec.algorithms.JavaSecDigestCalculator;
import org.minidns.dnssec.algorithms.RsaSignatureVerifier;
import org.minidns.record.NSEC3;

public final class AlgorithmMap {
    private Logger LOGGER = Logger.getLogger(AlgorithmMap.class.getName());
    public static final AlgorithmMap INSTANCE = new AlgorithmMap();
    private final Map<DnssecConstants.DigestAlgorithm, DigestCalculator> dsDigestMap = new HashMap<DnssecConstants.DigestAlgorithm, DigestCalculator>();
    private final Map<DnssecConstants.SignatureAlgorithm, SignatureVerifier> signatureMap = new HashMap<DnssecConstants.SignatureAlgorithm, SignatureVerifier>();
    private final Map<NSEC3.HashAlgorithm, DigestCalculator> nsecDigestMap = new HashMap<NSEC3.HashAlgorithm, DigestCalculator>();

    private AlgorithmMap() {
        try {
            this.dsDigestMap.put(DnssecConstants.DigestAlgorithm.SHA1, new JavaSecDigestCalculator("SHA-1"));
            this.nsecDigestMap.put(NSEC3.HashAlgorithm.SHA1, new JavaSecDigestCalculator("SHA-1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new DnssecValidatorInitializationException("SHA-1 is mandatory", e);
        }
        try {
            this.dsDigestMap.put(DnssecConstants.DigestAlgorithm.SHA256, new JavaSecDigestCalculator("SHA-256"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new DnssecValidatorInitializationException("SHA-256 is mandatory", e);
        }
        try {
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.RSAMD5, new RsaSignatureVerifier("MD5withRSA"));
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.FINER, "Platform does not support RSA/MD5", e);
        }
        try {
            DsaSignatureVerifier sha1withDSA = new DsaSignatureVerifier("SHA1withDSA");
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.DSA, sha1withDSA);
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.DSA_NSEC3_SHA1, sha1withDSA);
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.FINE, "Platform does not support DSA/SHA-1", e);
        }
        try {
            RsaSignatureVerifier sha1withRSA = new RsaSignatureVerifier("SHA1withRSA");
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.RSASHA1, sha1withRSA);
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.RSASHA1_NSEC3_SHA1, sha1withRSA);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DnssecValidatorInitializationException("Platform does not support RSA/SHA-1", e);
        }
        try {
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.RSASHA256, new RsaSignatureVerifier("SHA256withRSA"));
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support RSA/SHA-256", e);
        }
        try {
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.RSASHA512, new RsaSignatureVerifier("SHA512withRSA"));
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support RSA/SHA-512", e);
        }
        try {
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.ECC_GOST, new EcgostSignatureVerifier());
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.FINE, "Platform does not support GOST R 34.10-2001", e);
        }
        try {
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.ECDSAP256SHA256, new EcdsaSignatureVerifier.P256SHA256());
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support ECDSA/SHA-256", e);
        }
        try {
            this.signatureMap.put(DnssecConstants.SignatureAlgorithm.ECDSAP384SHA384, new EcdsaSignatureVerifier.P384SHA284());
        }
        catch (NoSuchAlgorithmException e) {
            this.LOGGER.log(Level.INFO, "Platform does not support ECDSA/SHA-384", e);
        }
    }

    public DigestCalculator getDsDigestCalculator(DnssecConstants.DigestAlgorithm algorithm) {
        return this.dsDigestMap.get(algorithm);
    }

    public SignatureVerifier getSignatureVerifier(DnssecConstants.SignatureAlgorithm algorithm) {
        return this.signatureMap.get(algorithm);
    }

    public DigestCalculator getNsecDigestCalculator(NSEC3.HashAlgorithm algorithm) {
        return this.nsecDigestMap.get(algorithm);
    }
}

