/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.hla;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.minidns.AbstractDnsClient;
import org.minidns.MiniDnsException;
import org.minidns.dnsname.DnsName;
import org.minidns.hla.ResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.InternetAddressRR;
import org.minidns.record.SRV;
import org.minidns.util.SrvUtil;

public class SrvResolverResult
extends ResolverResult<SRV> {
    private final ResolverApi resolver;
    private final AbstractDnsClient.IpVersionSetting ipVersion;
    private List<ResolvedSrvRecord> sortedSrvResolvedAddresses;

    SrvResolverResult(ResolverResult<SRV> srvResult, ResolverApi resolver) throws MiniDnsException.NullResultException {
        super(srvResult.question, srvResult.answer, srvResult.unverifiedReasons);
        this.resolver = resolver;
        this.ipVersion = resolver.getClient().getPreferedIpVersion();
    }

    public List<ResolvedSrvRecord> getSortedSrvResolvedAddresses() throws IOException {
        if (this.sortedSrvResolvedAddresses != null) {
            return this.sortedSrvResolvedAddresses;
        }
        this.throwIseIfErrorResponse();
        List srvRecords = SrvUtil.sortSrvRecords(this.getAnswers());
        ArrayList<ResolvedSrvRecord> res = new ArrayList<ResolvedSrvRecord>(srvRecords.size());
        for (SRV srvRecord : srvRecords) {
            ResolverResult<A> aRecordsResult = null;
            ResolverResult<AAAA> aaaaRecordsResult = null;
            Set<Object> aRecords = Collections.emptySet();
            if (this.ipVersion.v4 && (aRecordsResult = this.resolver.resolve(srvRecord.target, A.class)).wasSuccessful() && !aRecordsResult.hasUnverifiedReasons()) {
                aRecords = aRecordsResult.getAnswers();
            }
            Set<Object> aaaaRecords = Collections.emptySet();
            if (this.ipVersion.v6 && (aaaaRecordsResult = this.resolver.resolve(srvRecord.target, AAAA.class)).wasSuccessful() && !aaaaRecordsResult.hasUnverifiedReasons()) {
                aaaaRecords = aaaaRecordsResult.getAnswers();
            }
            if (aRecords.isEmpty() && aaaaRecords.isEmpty()) continue;
            ArrayList srvAddresses = new ArrayList(aRecords.size() + aaaaRecords.size());
            switch (this.ipVersion) {
                case v4only: {
                    srvAddresses.addAll(aRecords);
                    break;
                }
                case v6only: {
                    srvAddresses.addAll(aaaaRecords);
                    break;
                }
                case v4v6: {
                    srvAddresses.addAll(aRecords);
                    srvAddresses.addAll(aaaaRecords);
                    break;
                }
                case v6v4: {
                    srvAddresses.addAll(aaaaRecords);
                    srvAddresses.addAll(aRecords);
                }
            }
            ResolvedSrvRecord resolvedSrvAddresses = new ResolvedSrvRecord(this.question.name, srvRecord, srvAddresses, aRecordsResult, aaaaRecordsResult);
            res.add(resolvedSrvAddresses);
        }
        this.sortedSrvResolvedAddresses = res;
        return res;
    }

    public static class ResolvedSrvRecord {
        public final DnsName name;
        public final SRV srv;
        public final List<InternetAddressRR> addresses;
        public final ResolverResult<A> aRecordsResult;
        public final ResolverResult<AAAA> aaaaRecordsResult;
        public final int port;

        private ResolvedSrvRecord(DnsName name, SRV srv, List<InternetAddressRR> addresses, ResolverResult<A> aRecordsResult, ResolverResult<AAAA> aaaaRecordsResult) {
            this.name = name;
            this.srv = srv;
            this.addresses = Collections.unmodifiableList(addresses);
            this.port = srv.port;
            this.aRecordsResult = aRecordsResult;
            this.aaaaRecordsResult = aaaaRecordsResult;
        }
    }
}

