/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS24;

import org.apache.milagro.amcl.BLS24.BIG;
import org.apache.milagro.amcl.BLS24.ECP;
import org.apache.milagro.amcl.BLS24.ECP4;
import org.apache.milagro.amcl.BLS24.FP;
import org.apache.milagro.amcl.BLS24.FP2;
import org.apache.milagro.amcl.BLS24.FP24;
import org.apache.milagro.amcl.BLS24.FP4;
import org.apache.milagro.amcl.BLS24.FP8;
import org.apache.milagro.amcl.BLS24.ROM;

public final class PAIR192 {
    public static final boolean USE_GLV = true;
    public static final boolean USE_GS_G2 = true;
    public static final boolean USE_GS_GT = true;
    public static final boolean GT_STRONG = false;

    public static FP24 line(ECP4 A, ECP4 B, FP Qx, FP Qy) {
        FP8 c;
        FP8 b;
        FP8 a;
        if (A == B) {
            FP4 XX = new FP4(A.getx());
            FP4 YY = new FP4(A.gety());
            FP4 ZZ = new FP4(A.getz());
            FP4 YZ = new FP4(YY);
            YZ.mul(ZZ);
            XX.sqr();
            YY.sqr();
            ZZ.sqr();
            YZ.imul(4);
            YZ.neg();
            YZ.norm();
            YZ.qmul(Qy);
            XX.imul(6);
            XX.qmul(Qx);
            int sb = 57;
            ZZ.imul(sb);
            ZZ.times_i();
            ZZ.add(ZZ);
            YZ.times_i();
            YZ.norm();
            ZZ.norm();
            YY.add(YY);
            ZZ.sub(YY);
            ZZ.norm();
            a = new FP8(YZ, ZZ);
            b = new FP8(0);
            c = new FP8(XX);
            c.times_i();
            A.dbl();
        } else {
            FP4 X1 = new FP4(A.getx());
            FP4 Y1 = new FP4(A.gety());
            FP4 T1 = new FP4(A.getz());
            FP4 T2 = new FP4(A.getz());
            T1.mul(B.gety());
            T2.mul(B.getx());
            X1.sub(T2);
            X1.norm();
            Y1.sub(T1);
            Y1.norm();
            T1.copy(X1);
            X1.qmul(Qy);
            X1.times_i();
            X1.norm();
            T1.mul(B.gety());
            T2.copy(Y1);
            T2.mul(B.getx());
            T2.sub(T1);
            T2.norm();
            Y1.qmul(Qx);
            Y1.neg();
            Y1.norm();
            a = new FP8(X1, T2);
            b = new FP8(0);
            c = new FP8(Y1);
            c.times_i();
            A.add(B);
        }
        return new FP24(a, b, c);
    }

    public static FP24 ate(ECP4 P1, ECP Q1) {
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG n = new BIG(x);
        ECP4 P = new ECP4(P1);
        ECP Q = new ECP(Q1);
        P.affine();
        Q.affine();
        BIG n3 = new BIG(n);
        n3.pmul(3);
        n3.norm();
        FP Qx = new FP(Q.getx());
        FP Qy = new FP(Q.gety());
        ECP4 A = new ECP4();
        FP24 r = new FP24(1);
        A.copy(P);
        ECP4 MP = new ECP4();
        MP.copy(P);
        MP.neg();
        int nb = n3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            r.sqr();
            FP24 lv = PAIR192.line(A, A, Qx, Qy);
            r.smul(lv, 1);
            int bt = n3.bit(i) - n.bit(i);
            if (bt == 1) {
                lv = PAIR192.line(A, P, Qx, Qy);
                r.smul(lv, 1);
            }
            if (bt != -1) continue;
            lv = PAIR192.line(A, MP, Qx, Qy);
            r.smul(lv, 1);
        }
        return r;
    }

    public static FP24 ate2(ECP4 P1, ECP Q1, ECP4 R1, ECP S1) {
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG n = new BIG(x);
        ECP4 P = new ECP4(P1);
        ECP Q = new ECP(Q1);
        P.affine();
        Q.affine();
        ECP4 R = new ECP4(R1);
        ECP S = new ECP(S1);
        R.affine();
        S.affine();
        BIG n3 = new BIG(n);
        n3.pmul(3);
        n3.norm();
        FP Qx = new FP(Q.getx());
        FP Qy = new FP(Q.gety());
        FP Sx = new FP(S.getx());
        FP Sy = new FP(S.gety());
        ECP4 A = new ECP4();
        ECP4 B = new ECP4();
        FP24 r = new FP24(1);
        A.copy(P);
        B.copy(R);
        ECP4 MP = new ECP4();
        MP.copy(P);
        MP.neg();
        ECP4 MR = new ECP4();
        MR.copy(R);
        MR.neg();
        int nb = n3.nbits();
        for (int i = nb - 2; i >= 1; --i) {
            r.sqr();
            FP24 lv = PAIR192.line(A, A, Qx, Qy);
            r.smul(lv, 1);
            lv = PAIR192.line(B, B, Sx, Sy);
            r.smul(lv, 1);
            int bt = n3.bit(i) - n.bit(i);
            if (bt == 1) {
                lv = PAIR192.line(A, P, Qx, Qy);
                r.smul(lv, 1);
                lv = PAIR192.line(B, R, Sx, Sy);
                r.smul(lv, 1);
            }
            if (bt != -1) continue;
            lv = PAIR192.line(A, MP, Qx, Qy);
            r.smul(lv, 1);
            lv = PAIR192.line(B, MR, Sx, Sy);
            r.smul(lv, 1);
        }
        return r;
    }

    public static FP24 fexp(FP24 m) {
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG x = new BIG(ROM.CURVE_Bnx);
        FP24 r = new FP24(m);
        FP24 lv = new FP24(r);
        lv.inverse();
        r.conj();
        r.mul(lv);
        lv.copy(r);
        r.frob(f, 4);
        r.mul(lv);
        FP24 t7 = new FP24(r);
        t7.usqr();
        FP24 t1 = t7.pow(x);
        x.fshr(1);
        FP24 t2 = t1.pow(x);
        x.fshl(1);
        FP24 t3 = new FP24(t1);
        t3.conj();
        t2.mul(t3);
        t2.mul(r);
        t3 = t2.pow(x);
        FP24 t4 = t3.pow(x);
        FP24 t5 = t4.pow(x);
        t3.frob(f, 6);
        t4.frob(f, 5);
        t3.mul(t4);
        FP24 t6 = t5.pow(x);
        t5.frob(f, 4);
        t3.mul(t5);
        FP24 t0 = new FP24(t2);
        t0.conj();
        t6.mul(t0);
        t5.copy(t6);
        t5.frob(f, 3);
        t3.mul(t5);
        t5 = t6.pow(x);
        t6 = t5.pow(x);
        t0.copy(t5);
        t0.frob(f, 2);
        t3.mul(t0);
        t0.copy(t6);
        t0.frob(f, 1);
        t3.mul(t0);
        t5 = t6.pow(x);
        t2.frob(f, 7);
        t5.mul(t7);
        t3.mul(t2);
        t3.mul(t5);
        r.mul(t3);
        r.reduce();
        return r;
    }

    public static BIG[] glv(BIG e) {
        BIG[] u = new BIG[2];
        BIG q = new BIG(ROM.CURVE_Order);
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG x2 = BIG.smul(x, x);
        x = BIG.smul(x2, x2);
        u[0] = new BIG(e);
        u[0].mod(x);
        u[1] = new BIG(e);
        u[1].div(x);
        u[1].rsub(q);
        return u;
    }

    public static BIG[] gs(BIG e) {
        BIG[] u = new BIG[8];
        BIG q = new BIG(ROM.CURVE_Order);
        BIG x = new BIG(ROM.CURVE_Bnx);
        BIG w = new BIG(e);
        for (int i = 0; i < 7; ++i) {
            u[i] = new BIG(w);
            u[i].mod(x);
            w.div(x);
        }
        u[7] = new BIG(w);
        return u;
    }

    public static ECP G1mul(ECP P, BIG e) {
        ECP R = new ECP();
        R.copy(P);
        ECP Q = new ECP();
        Q.copy(P);
        Q.affine();
        BIG q = new BIG(ROM.CURVE_Order);
        FP cru = new FP(new BIG(ROM.CURVE_Cru));
        BIG t = new BIG(0);
        BIG[] u = PAIR192.glv(e);
        Q.getx().mul(cru);
        int np = u[0].nbits();
        t.copy(BIG.modneg(u[0], q));
        int nn = t.nbits();
        if (nn < np) {
            u[0].copy(t);
            R.neg();
        }
        np = u[1].nbits();
        t.copy(BIG.modneg(u[1], q));
        nn = t.nbits();
        if (nn < np) {
            u[1].copy(t);
            Q.neg();
        }
        u[0].norm();
        u[1].norm();
        R = R.mul2(u[0], Q, u[1]);
        return R;
    }

    public static ECP4 G2mul(ECP4 P, BIG e) {
        int i;
        ECP4[] Q = new ECP4[8];
        FP2[] F = ECP4.frob_constants();
        BIG q = new BIG(ROM.CURVE_Order);
        BIG[] u = PAIR192.gs(e);
        BIG t = new BIG(0);
        Q[0] = new ECP4();
        Q[0].copy(P);
        for (i = 1; i < 8; ++i) {
            Q[i] = new ECP4();
            Q[i].copy(Q[i - 1]);
            Q[i].frob(F, 1);
        }
        for (i = 0; i < 8; ++i) {
            int np = u[i].nbits();
            t.copy(BIG.modneg(u[i], q));
            int nn = t.nbits();
            if (nn < np) {
                u[i].copy(t);
                Q[i].neg();
            }
            u[i].norm();
        }
        ECP4 R = ECP4.mul8(Q, u);
        return R;
    }

    public static FP24 GTpow(FP24 d, BIG e) {
        int i;
        FP24[] g = new FP24[8];
        FP2 f = new FP2(new BIG(ROM.Fra), new BIG(ROM.Frb));
        BIG q = new BIG(ROM.CURVE_Order);
        BIG t = new BIG(0);
        BIG[] u = PAIR192.gs(e);
        g[0] = new FP24(d);
        for (i = 1; i < 8; ++i) {
            g[i] = new FP24(0);
            g[i].copy(g[i - 1]);
            g[i].frob(f, 1);
        }
        for (i = 0; i < 8; ++i) {
            int np = u[i].nbits();
            t.copy(BIG.modneg(u[i], q));
            int nn = t.nbits();
            if (nn < np) {
                u[i].copy(t);
                g[i].conj();
            }
            u[i].norm();
        }
        FP24 r = FP24.pow8(g, u);
        return r;
    }
}

