/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS383;

import org.apache.milagro.amcl.BLS383.BIG;
import org.apache.milagro.amcl.BLS383.DBIG;
import org.apache.milagro.amcl.BLS383.FP;
import org.apache.milagro.amcl.BLS383.ROM;

public final class FP2 {
    private final FP a;
    private final FP b;

    public void reduce() {
        this.a.reduce();
        this.b.reduce();
    }

    public void norm() {
        this.a.norm();
        this.b.norm();
    }

    public boolean iszilch() {
        return this.a.iszilch() && this.b.iszilch();
    }

    public void cmove(FP2 g, int d) {
        this.a.cmove(g.a, d);
        this.b.cmove(g.b, d);
    }

    public boolean isunity() {
        FP one = new FP(1);
        return this.a.equals(one) && this.b.iszilch();
    }

    public boolean equals(FP2 x) {
        return this.a.equals(x.a) && this.b.equals(x.b);
    }

    public FP2(int c) {
        this.a = new FP(c);
        this.b = new FP(0);
    }

    public FP2(FP2 x) {
        this.a = new FP(x.a);
        this.b = new FP(x.b);
    }

    public FP2(FP c, FP d) {
        this.a = new FP(c);
        this.b = new FP(d);
    }

    public FP2(BIG c, BIG d) {
        this.a = new FP(c);
        this.b = new FP(d);
    }

    public FP2(FP c) {
        this.a = new FP(c);
        this.b = new FP(0);
    }

    public FP2(BIG c) {
        this.a = new FP(c);
        this.b = new FP(0);
    }

    public BIG getA() {
        return this.a.redc();
    }

    public BIG getB() {
        return this.b.redc();
    }

    public void copy(FP2 x) {
        this.a.copy(x.a);
        this.b.copy(x.b);
    }

    public void zero() {
        this.a.zero();
        this.b.zero();
    }

    public void one() {
        this.a.one();
        this.b.zero();
    }

    public void neg() {
        FP m = new FP(this.a);
        FP t = new FP(0);
        m.add(this.b);
        m.neg();
        t.copy(m);
        t.add(this.b);
        this.b.copy(m);
        this.b.add(this.a);
        this.a.copy(t);
    }

    public void conj() {
        this.b.neg();
        this.b.norm();
    }

    public void add(FP2 x) {
        this.a.add(x.a);
        this.b.add(x.b);
    }

    public void sub(FP2 x) {
        FP2 m = new FP2(x);
        m.neg();
        this.add(m);
    }

    public void rsub(FP2 x) {
        this.neg();
        this.add(x);
    }

    public void pmul(FP s) {
        this.a.mul(s);
        this.b.mul(s);
    }

    public void imul(int c) {
        this.a.imul(c);
        this.b.imul(c);
    }

    public void sqr() {
        FP w1 = new FP(this.a);
        FP w3 = new FP(this.a);
        FP mb = new FP(this.b);
        w1.add(this.b);
        mb.neg();
        w3.add(this.a);
        w3.norm();
        this.b.mul(w3);
        this.a.add(mb);
        w1.norm();
        this.a.norm();
        this.a.mul(w1);
    }

    public void mul(FP2 y) {
        if ((long)(this.a.XES + this.b.XES) * (long)(y.a.XES + y.b.XES) > 0x800000L) {
            if (this.a.XES > 1) {
                this.a.reduce();
            }
            if (this.b.XES > 1) {
                this.b.reduce();
            }
        }
        DBIG pR = new DBIG(0);
        BIG C = new BIG(this.a.x);
        BIG D = new BIG(y.a.x);
        pR.ucopy(new BIG(ROM.Modulus));
        DBIG A = BIG.mul(this.a.x, y.a.x);
        DBIG B = BIG.mul(this.b.x, y.b.x);
        C.add(this.b.x);
        C.norm();
        D.add(y.b.x);
        D.norm();
        DBIG E = BIG.mul(C, D);
        DBIG F = new DBIG(A);
        F.add(B);
        B.rsub(pR);
        A.add(B);
        A.norm();
        E.sub(F);
        E.norm();
        this.a.x.copy(FP.mod(A));
        this.a.XES = 3;
        this.b.x.copy(FP.mod(E));
        this.b.XES = 2;
    }

    public boolean sqrt() {
        if (this.iszilch()) {
            return true;
        }
        FP w1 = new FP(this.b);
        FP w2 = new FP(this.a);
        w1.sqr();
        w2.sqr();
        w1.add(w2);
        if (w1.jacobi() != 1) {
            this.zero();
            return false;
        }
        w1 = w1.sqrt();
        w2.copy(this.a);
        w2.add(w1);
        w2.norm();
        w2.div2();
        if (w2.jacobi() != 1) {
            w2.copy(this.a);
            w2.sub(w1);
            w2.norm();
            w2.div2();
            if (w2.jacobi() != 1) {
                this.zero();
                return false;
            }
        }
        w2 = w2.sqrt();
        this.a.copy(w2);
        w2.add(w2);
        w2.inverse();
        this.b.mul(w2);
        return true;
    }

    public String toString() {
        return "[" + this.a.toString() + "," + this.b.toString() + "]";
    }

    public String toRawString() {
        return "[" + this.a.toRawString() + "," + this.b.toRawString() + "]";
    }

    public void inverse() {
        this.norm();
        FP w1 = new FP(this.a);
        FP w2 = new FP(this.b);
        w1.sqr();
        w2.sqr();
        w1.add(w2);
        w1.inverse();
        this.a.mul(w1);
        w1.neg();
        w1.norm();
        this.b.mul(w1);
    }

    public void div2() {
        this.a.div2();
        this.b.div2();
    }

    public void times_i() {
        FP z = new FP(this.a);
        this.a.copy(this.b);
        this.a.neg();
        this.b.copy(z);
    }

    public void mul_ip() {
        FP2 t = new FP2(this);
        FP z = new FP(this.a);
        this.a.copy(this.b);
        this.a.neg();
        this.b.copy(z);
        this.add(t);
    }

    public void div_ip2() {
        FP2 t = new FP2(0);
        this.norm();
        t.a.copy(this.a);
        t.a.add(this.b);
        t.b.copy(this.b);
        t.b.sub(this.a);
        this.copy(t);
        this.norm();
    }

    public void div_ip() {
        FP2 t = new FP2(0);
        this.norm();
        t.a.copy(this.a);
        t.a.add(this.b);
        t.b.copy(this.b);
        t.b.sub(this.a);
        this.copy(t);
        this.norm();
        this.div2();
    }
}

