/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS48;

import org.apache.milagro.amcl.BLS48.BIG;
import org.apache.milagro.amcl.BLS48.FP2;
import org.apache.milagro.amcl.BLS48.FP4;
import org.apache.milagro.amcl.BLS48.FP8;
import org.apache.milagro.amcl.BLS48.ROM;

public final class ECP8 {
    private FP8 x;
    private FP8 y;
    private FP8 z;

    public ECP8() {
        this.x = new FP8(0);
        this.y = new FP8(1);
        this.z = new FP8(0);
    }

    public ECP8(ECP8 e) {
        this.x = new FP8(e.x);
        this.y = new FP8(e.y);
        this.z = new FP8(e.z);
    }

    public boolean is_infinity() {
        return this.x.iszilch() && this.z.iszilch();
    }

    public void copy(ECP8 P) {
        this.x.copy(P.x);
        this.y.copy(P.y);
        this.z.copy(P.z);
    }

    public void inf() {
        this.x.zero();
        this.y.one();
        this.z.zero();
    }

    public void cmove(ECP8 Q, int d) {
        this.x.cmove(Q.x, d);
        this.y.cmove(Q.y, d);
        this.z.cmove(Q.z, d);
    }

    public static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    public void select(ECP8[] W, int b) {
        ECP8 MP = new ECP8();
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(W[0], ECP8.teq(babs, 0));
        this.cmove(W[1], ECP8.teq(babs, 1));
        this.cmove(W[2], ECP8.teq(babs, 2));
        this.cmove(W[3], ECP8.teq(babs, 3));
        this.cmove(W[4], ECP8.teq(babs, 4));
        this.cmove(W[5], ECP8.teq(babs, 5));
        this.cmove(W[6], ECP8.teq(babs, 6));
        this.cmove(W[7], ECP8.teq(babs, 7));
        MP.copy(this);
        MP.neg();
        this.cmove(MP, m & 1);
    }

    public boolean equals(ECP8 Q) {
        FP8 a = new FP8(this.x);
        FP8 b = new FP8(Q.x);
        a.mul(Q.z);
        b.mul(this.z);
        if (!a.equals(b)) {
            return false;
        }
        a.copy(this.y);
        a.mul(Q.z);
        b.copy(Q.y);
        b.mul(this.z);
        return a.equals(b);
    }

    public void neg() {
        this.y.norm();
        this.y.neg();
        this.y.norm();
    }

    public void affine() {
        if (this.is_infinity()) {
            return;
        }
        FP8 one = new FP8(1);
        if (this.z.equals(one)) {
            this.x.reduce();
            this.y.reduce();
            return;
        }
        this.z.inverse();
        this.x.mul(this.z);
        this.x.reduce();
        this.y.mul(this.z);
        this.y.reduce();
        this.z.copy(one);
    }

    public FP8 getX() {
        ECP8 W = new ECP8(this);
        W.affine();
        return W.x;
    }

    public FP8 getY() {
        ECP8 W = new ECP8(this);
        W.affine();
        return W.y;
    }

    public FP8 getx() {
        return this.x;
    }

    public FP8 gety() {
        return this.y;
    }

    public FP8 getz() {
        return this.z;
    }

    public void toBytes(byte[] b) {
        int i;
        byte[] t = new byte[70];
        ECP8 W = new ECP8(this);
        W.affine();
        int MB = 70;
        W.x.geta().geta().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i] = t[i];
        }
        W.x.geta().geta().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + MB] = t[i];
        }
        W.x.geta().getb().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 2 * MB] = t[i];
        }
        W.x.geta().getb().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 3 * MB] = t[i];
        }
        W.x.getb().geta().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 4 * MB] = t[i];
        }
        W.x.getb().geta().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 5 * MB] = t[i];
        }
        W.x.getb().getb().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 6 * MB] = t[i];
        }
        W.x.getb().getb().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 7 * MB] = t[i];
        }
        W.y.geta().geta().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 8 * MB] = t[i];
        }
        W.y.geta().geta().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 9 * MB] = t[i];
        }
        W.y.geta().getb().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 10 * MB] = t[i];
        }
        W.y.geta().getb().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 11 * MB] = t[i];
        }
        W.y.getb().geta().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 12 * MB] = t[i];
        }
        W.y.getb().geta().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 13 * MB] = t[i];
        }
        W.y.getb().getb().getA().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 14 * MB] = t[i];
        }
        W.y.getb().getb().getB().toBytes(t);
        for (i = 0; i < MB; ++i) {
            b[i + 15 * MB] = t[i];
        }
    }

    public static ECP8 fromBytes(byte[] b) {
        int i;
        int i2;
        int i3;
        int i4;
        byte[] t = new byte[70];
        int MB = 70;
        for (i4 = 0; i4 < MB; ++i4) {
            t[i4] = b[i4];
        }
        BIG ra = BIG.fromBytes(t);
        for (i4 = 0; i4 < MB; ++i4) {
            t[i4] = b[i4 + MB];
        }
        BIG rb = BIG.fromBytes(t);
        FP2 ra4 = new FP2(ra, rb);
        for (i3 = 0; i3 < MB; ++i3) {
            t[i3] = b[i3 + 2 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i3 = 0; i3 < MB; ++i3) {
            t[i3] = b[i3 + 3 * MB];
        }
        rb = BIG.fromBytes(t);
        FP2 rb4 = new FP2(ra, rb);
        FP4 ra8 = new FP4(ra4, rb4);
        for (i2 = 0; i2 < MB; ++i2) {
            t[i2] = b[i2 + 4 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i2 = 0; i2 < MB; ++i2) {
            t[i2] = b[i2 + 5 * MB];
        }
        rb = BIG.fromBytes(t);
        ra4 = new FP2(ra, rb);
        for (i2 = 0; i2 < MB; ++i2) {
            t[i2] = b[i2 + 6 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i2 = 0; i2 < MB; ++i2) {
            t[i2] = b[i2 + 7 * MB];
        }
        rb = BIG.fromBytes(t);
        rb4 = new FP2(ra, rb);
        FP4 rb8 = new FP4(ra4, rb4);
        FP8 rx = new FP8(ra8, rb8);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 8 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 9 * MB];
        }
        rb = BIG.fromBytes(t);
        ra4 = new FP2(ra, rb);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 10 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 11 * MB];
        }
        rb = BIG.fromBytes(t);
        rb4 = new FP2(ra, rb);
        ra8 = new FP4(ra4, rb4);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 12 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 13 * MB];
        }
        rb = BIG.fromBytes(t);
        ra4 = new FP2(ra, rb);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 14 * MB];
        }
        ra = BIG.fromBytes(t);
        for (i = 0; i < MB; ++i) {
            t[i] = b[i + 15 * MB];
        }
        rb = BIG.fromBytes(t);
        rb4 = new FP2(ra, rb);
        rb8 = new FP4(ra4, rb4);
        FP8 ry = new FP8(ra8, rb8);
        return new ECP8(rx, ry);
    }

    public String toString() {
        ECP8 W = new ECP8(this);
        W.affine();
        if (W.is_infinity()) {
            return "infinity";
        }
        return "(" + W.x.toString() + "," + W.y.toString() + ")";
    }

    public static FP8 RHS(FP8 x) {
        x.norm();
        FP8 r = new FP8(x);
        r.sqr();
        FP8 b = new FP8(new FP4(new FP2(new BIG(ROM.CURVE_B))));
        b.times_i();
        r.mul(x);
        r.add(b);
        r.reduce();
        return r;
    }

    public ECP8(FP8 ix, FP8 iy) {
        this.x = new FP8(ix);
        this.y = new FP8(iy);
        this.z = new FP8(1);
        FP8 rhs = ECP8.RHS(this.x);
        FP8 y2 = new FP8(this.y);
        y2.sqr();
        if (!y2.equals(rhs)) {
            this.inf();
        }
    }

    public ECP8(FP8 ix) {
        this.x = new FP8(ix);
        this.y = new FP8(1);
        this.z = new FP8(1);
        FP8 rhs = ECP8.RHS(this.x);
        if (rhs.sqrt()) {
            this.y.copy(rhs);
        } else {
            this.inf();
        }
    }

    public int dbl() {
        FP8 iy = new FP8(this.y);
        FP8 t0 = new FP8(this.y);
        t0.sqr();
        FP8 t1 = new FP8(iy);
        t1.mul(this.z);
        FP8 t2 = new FP8(this.z);
        t2.sqr();
        this.z.copy(t0);
        this.z.add(t0);
        this.z.norm();
        this.z.add(this.z);
        this.z.add(this.z);
        this.z.norm();
        t2.imul(51);
        t2.times_i();
        FP8 x3 = new FP8(t2);
        x3.mul(this.z);
        FP8 y3 = new FP8(t0);
        y3.add(t2);
        y3.norm();
        this.z.mul(t1);
        t1.copy(t2);
        t1.add(t2);
        t2.add(t1);
        t2.norm();
        t0.sub(t2);
        t0.norm();
        y3.mul(t0);
        y3.add(x3);
        t1.copy(this.x);
        t1.mul(iy);
        this.x.copy(t0);
        this.x.norm();
        this.x.mul(t1);
        this.x.add(this.x);
        this.x.norm();
        this.y.copy(y3);
        this.y.norm();
        return 1;
    }

    public int add(ECP8 Q) {
        int b = 51;
        FP8 t0 = new FP8(this.x);
        t0.mul(Q.x);
        FP8 t1 = new FP8(this.y);
        t1.mul(Q.y);
        FP8 t2 = new FP8(this.z);
        t2.mul(Q.z);
        FP8 t3 = new FP8(this.x);
        t3.add(this.y);
        t3.norm();
        FP8 t4 = new FP8(Q.x);
        t4.add(Q.y);
        t4.norm();
        t3.mul(t4);
        t4.copy(t0);
        t4.add(t1);
        t3.sub(t4);
        t3.norm();
        t4.copy(this.y);
        t4.add(this.z);
        t4.norm();
        FP8 x3 = new FP8(Q.y);
        x3.add(Q.z);
        x3.norm();
        t4.mul(x3);
        x3.copy(t1);
        x3.add(t2);
        t4.sub(x3);
        t4.norm();
        x3.copy(this.x);
        x3.add(this.z);
        x3.norm();
        FP8 y3 = new FP8(Q.x);
        y3.add(Q.z);
        y3.norm();
        x3.mul(y3);
        y3.copy(t0);
        y3.add(t2);
        y3.rsub(x3);
        y3.norm();
        x3.copy(t0);
        x3.add(t0);
        t0.add(x3);
        t0.norm();
        t2.imul(b);
        t2.times_i();
        FP8 z3 = new FP8(t1);
        z3.add(t2);
        z3.norm();
        t1.sub(t2);
        t1.norm();
        y3.imul(b);
        y3.times_i();
        x3.copy(y3);
        x3.mul(t4);
        t2.copy(t3);
        t2.mul(t1);
        x3.rsub(t2);
        y3.mul(t0);
        t1.mul(z3);
        y3.add(t1);
        t0.mul(t3);
        z3.mul(t4);
        z3.add(t0);
        this.x.copy(x3);
        this.x.norm();
        this.y.copy(y3);
        this.y.norm();
        this.z.copy(z3);
        this.z.norm();
        return 0;
    }

    public int sub(ECP8 Q) {
        ECP8 NQ = new ECP8(Q);
        NQ.neg();
        int D = this.add(NQ);
        return D;
    }

    public static FP2[] frob_constants() {
        BIG Fra = new BIG(ROM.Fra);
        BIG Frb = new BIG(ROM.Frb);
        FP2 X = new FP2(Fra, Frb);
        FP2 F0 = new FP2(X);
        F0.sqr();
        FP2 F2 = new FP2(F0);
        F2.mul_ip();
        F2.norm();
        FP2 F1 = new FP2(F2);
        F1.sqr();
        F2.mul(F1);
        F2.mul_ip();
        F2.norm();
        F1.copy(X);
        F1.mul_ip();
        F1.inverse();
        F0.copy(F1);
        F0.sqr();
        F0.mul_ip();
        F0.norm();
        F1.mul(F0);
        FP2[] F = new FP2[]{F0, F1, F2};
        return F;
    }

    public void frob(FP2[] F, int n) {
        for (int i = 0; i < n; ++i) {
            this.x.frob(F[2]);
            this.x.qmul(F[0]);
            this.x.div_i2();
            this.y.frob(F[2]);
            this.y.qmul(F[1]);
            this.y.div_i();
            this.z.frob(F[2]);
        }
    }

    public ECP8 mul(BIG e) {
        int i;
        BIG mt = new BIG();
        BIG t = new BIG();
        ECP8 P = new ECP8();
        ECP8 Q = new ECP8();
        ECP8 C = new ECP8();
        ECP8[] W = new ECP8[8];
        byte[] w = new byte[146];
        if (this.is_infinity()) {
            return new ECP8();
        }
        Q.copy(this);
        Q.dbl();
        W[0] = new ECP8();
        W[0].copy(this);
        for (i = 1; i < 8; ++i) {
            W[i] = new ECP8();
            W[i].copy(W[i - 1]);
            W[i].add(Q);
        }
        t.copy(e);
        int s = t.parity();
        t.inc(1);
        t.norm();
        int ns = t.parity();
        mt.copy(t);
        mt.inc(1);
        mt.norm();
        t.cmove(mt, s);
        Q.cmove(this, ns);
        C.copy(Q);
        int nb = 1 + (t.nbits() + 3) / 4;
        for (i = 0; i < nb; ++i) {
            w[i] = (byte)(t.lastbits(5) - 16);
            t.dec(w[i]);
            t.norm();
            t.fshr(4);
        }
        w[nb] = (byte)t.lastbits(5);
        P.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            Q.select(W, w[i]);
            P.dbl();
            P.dbl();
            P.dbl();
            P.dbl();
            P.add(Q);
        }
        P.sub(C);
        P.affine();
        return P;
    }

    public static ECP8 mul16(ECP8[] Q, BIG[] u) {
        int i;
        ECP8 W = new ECP8();
        ECP8 P = new ECP8();
        ECP8[] T1 = new ECP8[8];
        ECP8[] T2 = new ECP8[8];
        ECP8[] T3 = new ECP8[8];
        ECP8[] T4 = new ECP8[8];
        BIG mt = new BIG();
        BIG[] t = new BIG[16];
        byte[] w1 = new byte[581];
        byte[] s1 = new byte[581];
        byte[] w2 = new byte[581];
        byte[] s2 = new byte[581];
        byte[] w3 = new byte[581];
        byte[] s3 = new byte[581];
        byte[] w4 = new byte[581];
        byte[] s4 = new byte[581];
        for (i = 0; i < 16; ++i) {
            t[i] = new BIG(u[i]);
            t[i].norm();
        }
        T1[0] = new ECP8();
        T1[0].copy(Q[0]);
        T1[1] = new ECP8();
        T1[1].copy(T1[0]);
        T1[1].add(Q[1]);
        T1[2] = new ECP8();
        T1[2].copy(T1[0]);
        T1[2].add(Q[2]);
        T1[3] = new ECP8();
        T1[3].copy(T1[1]);
        T1[3].add(Q[2]);
        T1[4] = new ECP8();
        T1[4].copy(T1[0]);
        T1[4].add(Q[3]);
        T1[5] = new ECP8();
        T1[5].copy(T1[1]);
        T1[5].add(Q[3]);
        T1[6] = new ECP8();
        T1[6].copy(T1[2]);
        T1[6].add(Q[3]);
        T1[7] = new ECP8();
        T1[7].copy(T1[3]);
        T1[7].add(Q[3]);
        FP2[] F = ECP8.frob_constants();
        for (i = 0; i < 8; ++i) {
            T2[i] = new ECP8();
            T2[i].copy(T1[i]);
            T2[i].frob(F, 4);
            T3[i] = new ECP8();
            T3[i].copy(T2[i]);
            T3[i].frob(F, 4);
            T4[i] = new ECP8();
            T4[i].copy(T3[i]);
            T4[i].frob(F, 4);
        }
        int pb1 = 1 - t[0].parity();
        t[0].inc(pb1);
        t[0].norm();
        int pb2 = 1 - t[4].parity();
        t[4].inc(pb2);
        t[4].norm();
        int pb3 = 1 - t[8].parity();
        t[8].inc(pb3);
        t[8].norm();
        int pb4 = 1 - t[12].parity();
        t[12].inc(pb4);
        t[12].norm();
        mt.zero();
        for (i = 0; i < 16; ++i) {
            mt.or(t[i]);
        }
        int nb = 1 + mt.nbits();
        s1[nb - 1] = 1;
        s2[nb - 1] = 1;
        s3[nb - 1] = 1;
        s4[nb - 1] = 1;
        for (i = 0; i < nb - 1; ++i) {
            t[0].fshr(1);
            s1[i] = (byte)(2 * t[0].parity() - 1);
            t[4].fshr(1);
            s2[i] = (byte)(2 * t[4].parity() - 1);
            t[8].fshr(1);
            s3[i] = (byte)(2 * t[8].parity() - 1);
            t[12].fshr(1);
            s4[i] = (byte)(2 * t[12].parity() - 1);
        }
        for (i = 0; i < nb; ++i) {
            byte bt;
            int j;
            w1[i] = 0;
            int k = 1;
            for (j = 1; j < 4; ++j) {
                bt = (byte)(s1[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w1[n] = (byte)(w1[n] + bt * (byte)k);
                k *= 2;
            }
            w2[i] = 0;
            k = 1;
            for (j = 5; j < 8; ++j) {
                bt = (byte)(s2[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w2[n] = (byte)(w2[n] + bt * (byte)k);
                k *= 2;
            }
            w3[i] = 0;
            k = 1;
            for (j = 9; j < 12; ++j) {
                bt = (byte)(s3[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w3[n] = (byte)(w3[n] + bt * (byte)k);
                k *= 2;
            }
            w4[i] = 0;
            k = 1;
            for (j = 13; j < 16; ++j) {
                bt = (byte)(s4[i] * t[j].parity());
                t[j].fshr(1);
                t[j].dec(bt >> 1);
                t[j].norm();
                int n = i;
                w4[n] = (byte)(w4[n] + bt * (byte)k);
                k *= 2;
            }
        }
        P.select(T1, 2 * w1[nb - 1] + 1);
        W.select(T2, 2 * w2[nb - 1] + 1);
        P.add(W);
        W.select(T3, 2 * w3[nb - 1] + 1);
        P.add(W);
        W.select(T4, 2 * w4[nb - 1] + 1);
        P.add(W);
        for (i = nb - 2; i >= 0; --i) {
            P.dbl();
            W.select(T1, 2 * w1[i] + s1[i]);
            P.add(W);
            W.select(T2, 2 * w2[i] + s2[i]);
            P.add(W);
            W.select(T3, 2 * w3[i] + s3[i]);
            P.add(W);
            W.select(T4, 2 * w4[i] + s4[i]);
            P.add(W);
        }
        W.copy(P);
        W.sub(Q[0]);
        P.cmove(W, pb1);
        W.copy(P);
        W.sub(Q[4]);
        P.cmove(W, pb2);
        W.copy(P);
        W.sub(Q[8]);
        P.cmove(W, pb3);
        W.copy(P);
        W.sub(Q[12]);
        P.cmove(W, pb4);
        P.affine();
        return P;
    }

    public static ECP8 mapit(byte[] h) {
        FP2 X2;
        FP4 X4;
        FP8 X;
        ECP8 Q;
        BIG q = new BIG(ROM.Modulus);
        BIG x = BIG.fromBytes(h);
        BIG one = new BIG(1);
        x.mod(q);
        while ((Q = new ECP8(X = new FP8(X4 = new FP4(X2 = new FP2(one, x))))).is_infinity()) {
            x.inc(1);
            x.norm();
        }
        FP2[] F = ECP8.frob_constants();
        x = new BIG(ROM.CURVE_Bnx);
        ECP8 xQ = Q.mul(x);
        ECP8 x2Q = xQ.mul(x);
        ECP8 x3Q = x2Q.mul(x);
        ECP8 x4Q = x3Q.mul(x);
        ECP8 x5Q = x4Q.mul(x);
        ECP8 x6Q = x5Q.mul(x);
        ECP8 x7Q = x6Q.mul(x);
        ECP8 x8Q = x7Q.mul(x);
        x8Q.sub(x7Q);
        x8Q.sub(Q);
        x7Q.sub(x6Q);
        x7Q.frob(F, 1);
        x6Q.sub(x5Q);
        x6Q.frob(F, 2);
        x5Q.sub(x4Q);
        x5Q.frob(F, 3);
        x4Q.sub(x3Q);
        x4Q.frob(F, 4);
        x3Q.sub(x2Q);
        x3Q.frob(F, 5);
        x2Q.sub(xQ);
        x2Q.frob(F, 6);
        xQ.sub(Q);
        xQ.frob(F, 7);
        Q.dbl();
        Q.frob(F, 8);
        Q.add(x8Q);
        Q.add(x7Q);
        Q.add(x6Q);
        Q.add(x5Q);
        Q.add(x4Q);
        Q.add(x3Q);
        Q.add(x2Q);
        Q.add(xQ);
        Q.affine();
        return Q;
    }

    public static ECP8 generator() {
        return new ECP8(new FP8(new FP4(new FP2(new BIG(ROM.CURVE_Pxaaa), new BIG(ROM.CURVE_Pxaab)), new FP2(new BIG(ROM.CURVE_Pxaba), new BIG(ROM.CURVE_Pxabb))), new FP4(new FP2(new BIG(ROM.CURVE_Pxbaa), new BIG(ROM.CURVE_Pxbab)), new FP2(new BIG(ROM.CURVE_Pxbba), new BIG(ROM.CURVE_Pxbbb)))), new FP8(new FP4(new FP2(new BIG(ROM.CURVE_Pyaaa), new BIG(ROM.CURVE_Pyaab)), new FP2(new BIG(ROM.CURVE_Pyaba), new BIG(ROM.CURVE_Pyabb))), new FP4(new FP2(new BIG(ROM.CURVE_Pybaa), new BIG(ROM.CURVE_Pybab)), new FP2(new BIG(ROM.CURVE_Pybba), new BIG(ROM.CURVE_Pybbb)))));
    }
}

