/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS48;

import org.apache.milagro.amcl.BLS48.BIG;
import org.apache.milagro.amcl.BLS48.FP2;
import org.apache.milagro.amcl.BLS48.FP8;

public final class FP16 {
    private final FP8 a;
    private final FP8 b;

    public void reduce() {
        this.a.reduce();
        this.b.reduce();
    }

    public void norm() {
        this.a.norm();
        this.b.norm();
    }

    public boolean iszilch() {
        return this.a.iszilch() && this.b.iszilch();
    }

    public void cmove(FP16 g, int d) {
        this.a.cmove(g.a, d);
        this.b.cmove(g.b, d);
    }

    public boolean isunity() {
        FP8 one = new FP8(1);
        return this.a.equals(one) && this.b.iszilch();
    }

    public boolean isreal() {
        return this.b.iszilch();
    }

    public FP8 real() {
        return this.a;
    }

    public FP8 geta() {
        return this.a;
    }

    public FP8 getb() {
        return this.b;
    }

    public boolean equals(FP16 x) {
        return this.a.equals(x.a) && this.b.equals(x.b);
    }

    public FP16(int c) {
        this.a = new FP8(c);
        this.b = new FP8(0);
    }

    public FP16(FP16 x) {
        this.a = new FP8(x.a);
        this.b = new FP8(x.b);
    }

    public FP16(FP8 c, FP8 d) {
        this.a = new FP8(c);
        this.b = new FP8(d);
    }

    public FP16(FP8 c) {
        this.a = new FP8(c);
        this.b = new FP8(0);
    }

    public void copy(FP16 x) {
        this.a.copy(x.a);
        this.b.copy(x.b);
    }

    public void zero() {
        this.a.zero();
        this.b.zero();
    }

    public void one() {
        this.a.one();
        this.b.zero();
    }

    public void neg() {
        this.norm();
        FP8 m = new FP8(this.a);
        FP8 t = new FP8(0);
        m.add(this.b);
        m.neg();
        t.copy(m);
        t.add(this.b);
        this.b.copy(m);
        this.b.add(this.a);
        this.a.copy(t);
        this.norm();
    }

    public void conj() {
        this.b.neg();
        this.norm();
    }

    public void nconj() {
        this.a.neg();
        this.norm();
    }

    public void add(FP16 x) {
        this.a.add(x.a);
        this.b.add(x.b);
    }

    public void sub(FP16 x) {
        FP16 m = new FP16(x);
        m.neg();
        this.add(m);
    }

    public void rsub(FP16 x) {
        this.neg();
        this.add(x);
    }

    public void pmul(FP8 s) {
        this.a.mul(s);
        this.b.mul(s);
    }

    public void qmul(FP2 s) {
        this.a.qmul(s);
        this.b.qmul(s);
    }

    public void imul(int c) {
        this.a.imul(c);
        this.b.imul(c);
    }

    public void sqr() {
        FP8 t1 = new FP8(this.a);
        FP8 t2 = new FP8(this.b);
        FP8 t3 = new FP8(this.a);
        t3.mul(this.b);
        t1.add(this.b);
        t2.times_i();
        t2.add(this.a);
        t1.norm();
        t2.norm();
        this.a.copy(t1);
        this.a.mul(t2);
        t2.copy(t3);
        t2.times_i();
        t2.add(t3);
        t2.norm();
        t2.neg();
        this.a.add(t2);
        this.b.copy(t3);
        this.b.add(t3);
        this.norm();
    }

    public void mul(FP16 y) {
        FP8 t1 = new FP8(this.a);
        FP8 t2 = new FP8(this.b);
        FP8 t3 = new FP8(0);
        FP8 t4 = new FP8(this.b);
        t1.mul(y.a);
        t2.mul(y.b);
        t3.copy(y.b);
        t3.add(y.a);
        t4.add(this.a);
        t3.norm();
        t4.norm();
        t4.mul(t3);
        t3.copy(t1);
        t3.neg();
        t4.add(t3);
        t4.norm();
        t3.copy(t2);
        t3.neg();
        this.b.copy(t4);
        this.b.add(t3);
        t2.times_i();
        this.a.copy(t2);
        this.a.add(t1);
        this.norm();
    }

    public String toString() {
        return "[" + this.a.toString() + "," + this.b.toString() + "]";
    }

    public void inverse() {
        FP8 t1 = new FP8(this.a);
        FP8 t2 = new FP8(this.b);
        t1.sqr();
        t2.sqr();
        t2.times_i();
        t2.norm();
        t1.sub(t2);
        t1.norm();
        t1.inverse();
        this.a.mul(t1);
        t1.neg();
        t1.norm();
        this.b.mul(t1);
    }

    public void times_i() {
        FP8 s = new FP8(this.b);
        FP8 t = new FP8(this.a);
        s.times_i();
        this.b.copy(t);
        this.a.copy(s);
        this.norm();
    }

    public void times_i2() {
        this.a.times_i();
        this.b.times_i();
    }

    public void times_i4() {
        this.a.times_i2();
        this.b.times_i2();
    }

    public void frob(FP2 f) {
        FP2 ff = new FP2(f);
        ff.sqr();
        ff.norm();
        this.a.frob(ff);
        this.b.frob(ff);
        this.b.qmul(f);
        this.b.times_i();
    }

    public FP16 pow(BIG e) {
        this.norm();
        e.norm();
        FP16 w = new FP16(this);
        BIG z = new BIG(e);
        FP16 r = new FP16(1);
        while (true) {
            int bt = z.parity();
            z.fshr(1);
            if (bt == 1) {
                r.mul(w);
            }
            if (z.iszilch()) break;
            w.sqr();
        }
        r.reduce();
        return r;
    }

    public void xtr_A(FP16 w, FP16 y, FP16 z) {
        FP16 r = new FP16(w);
        FP16 t = new FP16(w);
        r.sub(y);
        r.norm();
        r.pmul(this.a);
        t.add(y);
        t.norm();
        t.pmul(this.b);
        t.times_i();
        this.copy(r);
        this.add(t);
        this.add(z);
        this.norm();
    }

    public void xtr_D() {
        FP16 w = new FP16(this);
        this.sqr();
        w.conj();
        w.add(w);
        w.norm();
        this.sub(w);
        this.reduce();
    }

    public FP16 xtr_pow(BIG n) {
        FP16 a = new FP16(3);
        FP16 b = new FP16(this);
        FP16 c = new FP16(b);
        c.xtr_D();
        FP16 t = new FP16(0);
        FP16 r = new FP16(0);
        n.norm();
        int par = n.parity();
        BIG v = new BIG(n);
        v.fshr(1);
        if (par == 0) {
            v.dec(1);
            v.norm();
        }
        int nb = v.nbits();
        for (int i = nb - 1; i >= 0; --i) {
            if (v.bit(i) != 1) {
                t.copy(b);
                this.conj();
                c.conj();
                b.xtr_A(a, this, c);
                this.conj();
                c.copy(t);
                c.xtr_D();
                a.xtr_D();
                continue;
            }
            t.copy(a);
            t.conj();
            a.copy(b);
            a.xtr_D();
            b.xtr_A(c, this, t);
            c.xtr_D();
        }
        if (par == 0) {
            r.copy(c);
        } else {
            r.copy(b);
        }
        r.reduce();
        return r;
    }

    public FP16 xtr_pow2(FP16 ck, FP16 ckml, FP16 ckm2l, BIG a, BIG b) {
        a.norm();
        b.norm();
        BIG e = new BIG(a);
        BIG d = new BIG(b);
        BIG w = new BIG(0);
        FP16 cu = new FP16(ck);
        FP16 cv = new FP16(this);
        FP16 cumv = new FP16(ckml);
        FP16 cum2v = new FP16(ckm2l);
        FP16 r = new FP16(0);
        FP16 t = new FP16(0);
        int f2 = 0;
        while (d.parity() == 0 && e.parity() == 0) {
            d.fshr(1);
            e.fshr(1);
            ++f2;
        }
        while (BIG.comp(d, e) != 0) {
            if (BIG.comp(d, e) > 0) {
                w.copy(e);
                w.imul(4);
                w.norm();
                if (BIG.comp(d, w) <= 0) {
                    w.copy(d);
                    d.copy(e);
                    e.rsub(w);
                    e.norm();
                    t.copy(cv);
                    t.xtr_A(cu, cumv, cum2v);
                    cum2v.copy(cumv);
                    cum2v.conj();
                    cumv.copy(cv);
                    cv.copy(cu);
                    cu.copy(t);
                } else if (d.parity() == 0) {
                    d.fshr(1);
                    r.copy(cum2v);
                    r.conj();
                    t.copy(cumv);
                    t.xtr_A(cu, cv, r);
                    cum2v.copy(cumv);
                    cum2v.xtr_D();
                    cumv.copy(t);
                    cu.xtr_D();
                } else if (e.parity() == 1) {
                    d.sub(e);
                    d.norm();
                    d.fshr(1);
                    t.copy(cv);
                    t.xtr_A(cu, cumv, cum2v);
                    cu.xtr_D();
                    cum2v.copy(cv);
                    cum2v.xtr_D();
                    cum2v.conj();
                    cv.copy(t);
                } else {
                    w.copy(d);
                    d.copy(e);
                    d.fshr(1);
                    e.copy(w);
                    t.copy(cumv);
                    t.xtr_D();
                    cumv.copy(cum2v);
                    cumv.conj();
                    cum2v.copy(t);
                    cum2v.conj();
                    t.copy(cv);
                    t.xtr_D();
                    cv.copy(cu);
                    cu.copy(t);
                }
            }
            if (BIG.comp(d, e) >= 0) continue;
            w.copy(d);
            w.imul(4);
            w.norm();
            if (BIG.comp(e, w) <= 0) {
                e.sub(d);
                e.norm();
                t.copy(cv);
                t.xtr_A(cu, cumv, cum2v);
                cum2v.copy(cumv);
                cumv.copy(cu);
                cu.copy(t);
                continue;
            }
            if (e.parity() == 0) {
                w.copy(d);
                d.copy(e);
                d.fshr(1);
                e.copy(w);
                t.copy(cumv);
                t.xtr_D();
                cumv.copy(cum2v);
                cumv.conj();
                cum2v.copy(t);
                cum2v.conj();
                t.copy(cv);
                t.xtr_D();
                cv.copy(cu);
                cu.copy(t);
                continue;
            }
            if (d.parity() == 1) {
                w.copy(e);
                e.copy(d);
                w.sub(d);
                w.norm();
                d.copy(w);
                d.fshr(1);
                t.copy(cv);
                t.xtr_A(cu, cumv, cum2v);
                cumv.conj();
                cum2v.copy(cu);
                cum2v.xtr_D();
                cum2v.conj();
                cu.copy(cv);
                cu.xtr_D();
                cv.copy(t);
                continue;
            }
            d.fshr(1);
            r.copy(cum2v);
            r.conj();
            t.copy(cumv);
            t.xtr_A(cu, cv, r);
            cum2v.copy(cumv);
            cum2v.xtr_D();
            cumv.copy(t);
            cu.xtr_D();
        }
        r.copy(cv);
        r.xtr_A(cu, cumv, cum2v);
        for (int i = 0; i < f2; ++i) {
            r.xtr_D();
        }
        r = r.xtr_pow(d);
        return r;
    }
}

