/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.BLS48;

import java.util.Date;
import org.apache.milagro.amcl.BLS48.BIG;
import org.apache.milagro.amcl.BLS48.ECP;
import org.apache.milagro.amcl.BLS48.ECP8;
import org.apache.milagro.amcl.BLS48.FP16;
import org.apache.milagro.amcl.BLS48.FP48;
import org.apache.milagro.amcl.BLS48.PAIR256;
import org.apache.milagro.amcl.BLS48.ROM;
import org.apache.milagro.amcl.HASH256;
import org.apache.milagro.amcl.HASH384;
import org.apache.milagro.amcl.HASH512;
import org.apache.milagro.amcl.RAND;

public class MPIN256 {
    public static final int EFS = 70;
    public static final int EGS = 70;
    public static final int INVALID_POINT = -14;
    public static final int BAD_PARAMS = -11;
    public static final int WRONG_ORDER = -18;
    public static final int BAD_PIN = -19;
    public static final int MAXPIN = 10000;
    public static final int PBLEN = 14;
    public static final int TS = 10;
    public static final int TRAP = 200;

    public static byte[] hashit(int sha, int n, byte[] B, int len) {
        Object H;
        byte[] R = null;
        if (sha == 32) {
            H = new HASH256();
            if (n > 0) {
                ((HASH256)H).process_num(n);
            }
            ((HASH256)H).process_array(B);
            R = ((HASH256)H).hash();
        }
        if (sha == 48) {
            H = new HASH384();
            if (n > 0) {
                ((HASH384)H).process_num(n);
            }
            ((HASH384)H).process_array(B);
            R = ((HASH384)H).hash();
        }
        if (sha == 64) {
            H = new HASH512();
            if (n > 0) {
                ((HASH512)H).process_num(n);
            }
            ((HASH512)H).process_array(B);
            R = ((HASH512)H).hash();
        }
        if (R == null) {
            return null;
        }
        byte[] W = new byte[len];
        if (sha >= len) {
            for (int i = 0; i < len; ++i) {
                W[i] = R[i];
            }
        } else {
            int i;
            for (i = 0; i < sha; ++i) {
                W[i + len - sha] = R[i];
            }
            for (i = 0; i < len - sha; ++i) {
                W[i] = 0;
            }
        }
        return W;
    }

    public static int today() {
        Date date = new Date();
        return (int)(date.getTime() / 86400000L);
    }

    public static byte[] HASH_ID(int sha, byte[] ID, int len) {
        return MPIN256.hashit(sha, 0, ID, len);
    }

    public static byte[] HASH_ALL(int sha, byte[] HID, byte[] xID, byte[] xCID, byte[] SEC, byte[] Y, byte[] R, byte[] W, int len) {
        int i;
        int tlen = 0;
        int ilen = HID.length + SEC.length + Y.length + R.length + W.length;
        ilen = xCID != null ? (ilen += xCID.length) : (ilen += xID.length);
        byte[] T = new byte[ilen];
        for (i = 0; i < HID.length; ++i) {
            T[i] = HID[i];
        }
        tlen += HID.length;
        if (xCID != null) {
            for (i = 0; i < xCID.length; ++i) {
                T[i + tlen] = xCID[i];
            }
            tlen += xCID.length;
        } else {
            for (i = 0; i < xID.length; ++i) {
                T[i + tlen] = xID[i];
            }
            tlen += xID.length;
        }
        for (i = 0; i < SEC.length; ++i) {
            T[i + tlen] = SEC[i];
        }
        tlen += SEC.length;
        for (i = 0; i < Y.length; ++i) {
            T[i + tlen] = Y[i];
        }
        tlen += Y.length;
        for (i = 0; i < R.length; ++i) {
            T[i + tlen] = R[i];
        }
        tlen += R.length;
        for (i = 0; i < W.length; ++i) {
            T[i + tlen] = W[i];
        }
        tlen += W.length;
        return MPIN256.hashit(sha, 0, T, len);
    }

    public static int GET_TIME() {
        Date date = new Date();
        return (int)(date.getTime() / 1000L);
    }

    public static byte[] mpin_hash(int sha, FP16 c, ECP U) {
        int i;
        byte[] w = new byte[70];
        byte[] t = new byte[1260];
        byte[] h = null;
        c.geta().geta().geta().getA().toBytes(w);
        for (i = 0; i < 70; ++i) {
            t[i] = w[i];
        }
        c.geta().geta().geta().getB().toBytes(w);
        for (i = 70; i < 140; ++i) {
            t[i] = w[i - 70];
        }
        c.geta().geta().getb().getA().toBytes(w);
        for (i = 140; i < 210; ++i) {
            t[i] = w[i - 140];
        }
        c.geta().geta().getb().getB().toBytes(w);
        for (i = 210; i < 280; ++i) {
            t[i] = w[i - 210];
        }
        c.geta().getb().geta().getA().toBytes(w);
        for (i = 280; i < 350; ++i) {
            t[i] = w[i - 280];
        }
        c.geta().getb().geta().getB().toBytes(w);
        for (i = 350; i < 420; ++i) {
            t[i] = w[i - 350];
        }
        c.geta().getb().getb().getA().toBytes(w);
        for (i = 420; i < 490; ++i) {
            t[i] = w[i - 420];
        }
        c.geta().getb().getb().getB().toBytes(w);
        for (i = 490; i < 560; ++i) {
            t[i] = w[i - 490];
        }
        c.getb().geta().geta().getA().toBytes(w);
        for (i = 560; i < 630; ++i) {
            t[i] = w[i - 560];
        }
        c.getb().geta().geta().getB().toBytes(w);
        for (i = 630; i < 700; ++i) {
            t[i] = w[i - 630];
        }
        c.getb().geta().getb().getA().toBytes(w);
        for (i = 700; i < 770; ++i) {
            t[i] = w[i - 700];
        }
        c.getb().geta().getb().getB().toBytes(w);
        for (i = 770; i < 840; ++i) {
            t[i] = w[i - 770];
        }
        c.getb().getb().geta().getA().toBytes(w);
        for (i = 840; i < 910; ++i) {
            t[i] = w[i - 840];
        }
        c.getb().getb().geta().getB().toBytes(w);
        for (i = 910; i < 980; ++i) {
            t[i] = w[i - 910];
        }
        c.getb().getb().getb().getA().toBytes(w);
        for (i = 980; i < 1050; ++i) {
            t[i] = w[i - 980];
        }
        c.getb().getb().getb().getB().toBytes(w);
        for (i = 1050; i < 1120; ++i) {
            t[i] = w[i - 1050];
        }
        U.getX().toBytes(w);
        for (i = 1120; i < 1190; ++i) {
            t[i] = w[i - 1120];
        }
        U.getY().toBytes(w);
        for (i = 1190; i < 1260; ++i) {
            t[i] = w[i - 1190];
        }
        if (sha == 32) {
            HASH256 H = new HASH256();
            H.process_array(t);
            h = H.hash();
        }
        if (sha == 48) {
            HASH384 H = new HASH384();
            H.process_array(t);
            h = H.hash();
        }
        if (sha == 64) {
            HASH512 H = new HASH512();
            H.process_array(t);
            h = H.hash();
        }
        if (h == null) {
            return null;
        }
        byte[] R = new byte[32];
        for (int i2 = 0; i2 < 32; ++i2) {
            R[i2] = h[i2];
        }
        return R;
    }

    public static ECP map(BIG u, int cb) {
        ECP P;
        BIG x = new BIG(u);
        BIG p = new BIG(ROM.Modulus);
        x.mod(p);
        while ((P = new ECP(x, cb)).is_infinity()) {
            x.inc(1);
            x.norm();
        }
        return P;
    }

    public static int unmap(BIG u, ECP P) {
        ECP R;
        int s = P.getS();
        int r = 0;
        BIG x = P.getX();
        u.copy(x);
        do {
            u.dec(1);
            u.norm();
            ++r;
        } while ((R = new ECP(u, s)).is_infinity());
        return r;
    }

    public static int ENCODING(RAND rng, byte[] E) {
        int i;
        byte[] T = new byte[70];
        for (int i2 = 0; i2 < 70; ++i2) {
            T[i2] = E[i2 + 1];
        }
        BIG u = BIG.fromBytes(T);
        for (int i3 = 0; i3 < 70; ++i3) {
            T[i3] = E[i3 + 70 + 1];
        }
        BIG v = BIG.fromBytes(T);
        ECP P = new ECP(u, v);
        if (P.is_infinity()) {
            return -14;
        }
        BIG p = new BIG(ROM.Modulus);
        u = BIG.randomnum(p, rng);
        int su = rng.getByte();
        ECP W = MPIN256.map(u, su %= 2);
        P.sub(W);
        int sv = P.getS();
        int rn = MPIN256.unmap(v, P);
        int m = rng.getByte();
        v.inc((m %= rn) + 1);
        E[0] = (byte)(su + 2 * sv);
        u.toBytes(T);
        for (i = 0; i < 70; ++i) {
            E[i + 1] = T[i];
        }
        v.toBytes(T);
        for (i = 0; i < 70; ++i) {
            E[i + 70 + 1] = T[i];
        }
        return 0;
    }

    public static int DECODING(byte[] D) {
        int i;
        byte[] T = new byte[70];
        if ((D[0] & 4) != 0) {
            return -14;
        }
        for (int i2 = 0; i2 < 70; ++i2) {
            T[i2] = D[i2 + 1];
        }
        BIG u = BIG.fromBytes(T);
        for (int i3 = 0; i3 < 70; ++i3) {
            T[i3] = D[i3 + 70 + 1];
        }
        BIG v = BIG.fromBytes(T);
        int su = D[0] & 1;
        int sv = D[0] >> 1 & 1;
        ECP W = MPIN256.map(u, su);
        ECP P = MPIN256.map(v, sv);
        P.add(W);
        u = P.getX();
        v = P.getY();
        D[0] = 4;
        u.toBytes(T);
        for (i = 0; i < 70; ++i) {
            D[i + 1] = T[i];
        }
        v.toBytes(T);
        for (i = 0; i < 70; ++i) {
            D[i + 70 + 1] = T[i];
        }
        return 0;
    }

    public static int RECOMBINE_G1(byte[] R1, byte[] R2, byte[] R) {
        ECP P = ECP.fromBytes(R1);
        ECP Q = ECP.fromBytes(R2);
        if (P.is_infinity() || Q.is_infinity()) {
            return -14;
        }
        P.add(Q);
        P.toBytes(R, false);
        return 0;
    }

    public static int RECOMBINE_G2(byte[] W1, byte[] W2, byte[] W) {
        ECP8 P = ECP8.fromBytes(W1);
        ECP8 Q = ECP8.fromBytes(W2);
        if (P.is_infinity() || Q.is_infinity()) {
            return -14;
        }
        P.add(Q);
        P.toBytes(W);
        return 0;
    }

    public static int RANDOM_GENERATE(RAND rng, byte[] S) {
        BIG r = new BIG(ROM.CURVE_Order);
        BIG s = BIG.randomnum(r, rng);
        s.toBytes(S);
        return 0;
    }

    public static int EXTRACT_PIN(int sha, byte[] CID, int pin, byte[] TOKEN) {
        ECP P = ECP.fromBytes(TOKEN);
        if (P.is_infinity()) {
            return -14;
        }
        byte[] h = MPIN256.hashit(sha, 0, CID, 70);
        ECP R = ECP.mapit(h);
        R = R.pinmul(pin %= 10000, 14);
        P.sub(R);
        P.toBytes(TOKEN, false);
        return 0;
    }

    public static int CLIENT_2(byte[] X, byte[] Y, byte[] SEC) {
        BIG r = new BIG(ROM.CURVE_Order);
        ECP P = ECP.fromBytes(SEC);
        if (P.is_infinity()) {
            return -14;
        }
        BIG px = BIG.fromBytes(X);
        BIG py = BIG.fromBytes(Y);
        px.add(py);
        px.mod(r);
        P = PAIR256.G1mul(P, px);
        P.neg();
        P.toBytes(SEC, false);
        return 0;
    }

    public static int CLIENT_1(int sha, int date, byte[] CLIENT_ID, RAND rng, byte[] X, int pin, byte[] TOKEN, byte[] SEC, byte[] xID, byte[] xCID, byte[] PERMIT) {
        BIG x;
        BIG r = new BIG(ROM.CURVE_Order);
        if (rng != null) {
            x = BIG.randomnum(r, rng);
            x.toBytes(X);
        } else {
            x = BIG.fromBytes(X);
        }
        byte[] h = MPIN256.hashit(sha, 0, CLIENT_ID, 70);
        ECP P = ECP.mapit(h);
        ECP T = ECP.fromBytes(TOKEN);
        if (T.is_infinity()) {
            return -14;
        }
        ECP W = P.pinmul(pin %= 10000, 14);
        T.add(W);
        if (date != 0) {
            W = ECP.fromBytes(PERMIT);
            if (W.is_infinity()) {
                return -14;
            }
            T.add(W);
            h = MPIN256.hashit(sha, date, h, 70);
            W = ECP.mapit(h);
            if (xID != null) {
                P = PAIR256.G1mul(P, x);
                P.toBytes(xID, false);
                W = PAIR256.G1mul(W, x);
                P.add(W);
            } else {
                P.add(W);
                P = PAIR256.G1mul(P, x);
            }
            if (xCID != null) {
                P.toBytes(xCID, false);
            }
        } else if (xID != null) {
            P = PAIR256.G1mul(P, x);
            P.toBytes(xID, false);
        }
        T.toBytes(SEC, false);
        return 0;
    }

    public static int GET_SERVER_SECRET(byte[] S, byte[] SST) {
        ECP8 Q = ECP8.generator();
        BIG s = BIG.fromBytes(S);
        Q = PAIR256.G2mul(Q, s);
        Q.toBytes(SST);
        return 0;
    }

    public static int GET_G1_MULTIPLE(RAND rng, int type, byte[] X, byte[] G, byte[] W) {
        ECP P;
        BIG x;
        BIG r = new BIG(ROM.CURVE_Order);
        if (rng != null) {
            x = BIG.randomnum(r, rng);
            x.toBytes(X);
        } else {
            x = BIG.fromBytes(X);
        }
        if (type == 0) {
            P = ECP.fromBytes(G);
            if (P.is_infinity()) {
                return -14;
            }
        } else {
            P = ECP.mapit(G);
        }
        PAIR256.G1mul(P, x).toBytes(W, false);
        return 0;
    }

    public static int GET_CLIENT_SECRET(byte[] S, byte[] CID, byte[] CST) {
        return MPIN256.GET_G1_MULTIPLE(null, 1, S, CID, CST);
    }

    public static int GET_CLIENT_PERMIT(int sha, int date, byte[] S, byte[] CID, byte[] CTT) {
        byte[] h = MPIN256.hashit(sha, date, CID, 70);
        ECP P = ECP.mapit(h);
        BIG s = BIG.fromBytes(S);
        ECP OP = PAIR256.G1mul(P, s);
        OP.toBytes(CTT, false);
        return 0;
    }

    public static void SERVER_1(int sha, int date, byte[] CID, byte[] HID, byte[] HTID) {
        byte[] h = MPIN256.hashit(sha, 0, CID, 70);
        ECP P = ECP.mapit(h);
        P.toBytes(HID, false);
        if (date != 0) {
            h = MPIN256.hashit(sha, date, h, 70);
            ECP R = ECP.mapit(h);
            P.add(R);
            P.toBytes(HTID, false);
        }
    }

    public static int SERVER_2(int date, byte[] HID, byte[] HTID, byte[] Y, byte[] SST, byte[] xID, byte[] xCID, byte[] mSEC, byte[] E, byte[] F) {
        ECP P;
        ECP R;
        BIG q = new BIG(ROM.Modulus);
        ECP8 Q = ECP8.generator();
        ECP8 sQ = ECP8.fromBytes(SST);
        if (sQ.is_infinity()) {
            return -14;
        }
        if (date != 0) {
            R = ECP.fromBytes(xCID);
        } else {
            if (xID == null) {
                return -11;
            }
            R = ECP.fromBytes(xID);
        }
        if (R.is_infinity()) {
            return -14;
        }
        BIG y = BIG.fromBytes(Y);
        if (date != 0) {
            P = ECP.fromBytes(HTID);
        } else {
            if (HID == null) {
                return -11;
            }
            P = ECP.fromBytes(HID);
        }
        if (P.is_infinity()) {
            return -14;
        }
        P = PAIR256.G1mul(P, y);
        P.add(R);
        R = ECP.fromBytes(mSEC);
        if (R.is_infinity()) {
            return -14;
        }
        FP48 g = PAIR256.ate2(Q, R, sQ, P);
        if (!(g = PAIR256.fexp(g)).isunity()) {
            if (HID != null && xID != null && E != null && F != null) {
                g.toBytes(E);
                if (date != 0) {
                    P = ECP.fromBytes(HID);
                    if (P.is_infinity()) {
                        return -14;
                    }
                    R = ECP.fromBytes(xID);
                    if (R.is_infinity()) {
                        return -14;
                    }
                    P = PAIR256.G1mul(P, y);
                    P.add(R);
                }
                g = PAIR256.ate(Q, P);
                g = PAIR256.fexp(g);
                g.toBytes(F);
            }
            return -19;
        }
        return 0;
    }

    public static int KANGAROO(byte[] E, byte[] F) {
        int i;
        FP48 ge = FP48.fromBytes(E);
        FP48 gf = FP48.fromBytes(F);
        int[] distance = new int[10];
        FP48 t = new FP48(gf);
        FP48[] table = new FP48[10];
        int s = 1;
        for (int m = 0; m < 10; ++m) {
            distance[m] = s;
            table[m] = new FP48(t);
            s *= 2;
            t.usqr();
        }
        t.one();
        int dn = 0;
        for (int j = 0; j < 200; ++j) {
            i = t.geta().geta().geta().geta().getA().lastbits(20) % 10;
            t.mul(table[i]);
            dn += distance[i];
        }
        gf.copy(t);
        gf.conj();
        int steps = 0;
        int dm = 0;
        int res = 0;
        while (dm - dn < 10000 && ++steps <= 800) {
            i = ge.geta().geta().geta().geta().getA().lastbits(20) % 10;
            ge.mul(table[i]);
            dm += distance[i];
            if (ge.equals(t)) {
                res = dm - dn;
                break;
            }
            if (!ge.equals(gf)) continue;
            res = dn - dm;
            break;
        }
        if (steps > 800 || dm - dn >= 10000) {
            res = 0;
        }
        return res;
    }

    public static int PRECOMPUTE(byte[] TOKEN, byte[] CID, byte[] G1, byte[] G2) {
        ECP T = ECP.fromBytes(TOKEN);
        if (T.is_infinity()) {
            return -14;
        }
        ECP P = ECP.mapit(CID);
        ECP8 Q = ECP8.generator();
        FP48 g = PAIR256.ate(Q, T);
        g = PAIR256.fexp(g);
        g.toBytes(G1);
        g = PAIR256.ate(Q, P);
        g = PAIR256.fexp(g);
        g.toBytes(G2);
        return 0;
    }

    public static int CLIENT_KEY(int sha, byte[] G1, byte[] G2, int pin, byte[] R, byte[] X, byte[] H, byte[] wCID, byte[] CK) {
        FP48 g1 = FP48.fromBytes(G1);
        FP48 g2 = FP48.fromBytes(G2);
        BIG z = BIG.fromBytes(R);
        BIG x = BIG.fromBytes(X);
        BIG h = BIG.fromBytes(H);
        ECP W = ECP.fromBytes(wCID);
        if (W.is_infinity()) {
            return -14;
        }
        W = PAIR256.G1mul(W, x);
        BIG r = new BIG(ROM.CURVE_Order);
        z.add(h);
        z.mod(r);
        g2.pinpow(pin, 14);
        g1.mul(g2);
        FP16 c = g1.compow(z, r);
        byte[] t = MPIN256.mpin_hash(sha, c, W);
        for (int i = 0; i < 32; ++i) {
            CK[i] = t[i];
        }
        return 0;
    }

    public static int SERVER_KEY(int sha, byte[] Z, byte[] SST, byte[] W, byte[] H, byte[] HID, byte[] xID, byte[] xCID, byte[] SK) {
        ECP8 sQ = ECP8.fromBytes(SST);
        if (sQ.is_infinity()) {
            return -14;
        }
        ECP R = ECP.fromBytes(Z);
        if (R.is_infinity()) {
            return -14;
        }
        ECP A = ECP.fromBytes(HID);
        if (A.is_infinity()) {
            return -14;
        }
        ECP U = xCID != null ? ECP.fromBytes(xCID) : ECP.fromBytes(xID);
        if (U.is_infinity()) {
            return -14;
        }
        BIG w = BIG.fromBytes(W);
        BIG h = BIG.fromBytes(H);
        A = PAIR256.G1mul(A, h);
        R.add(A);
        U = PAIR256.G1mul(U, w);
        FP48 g = PAIR256.ate(sQ, R);
        g = PAIR256.fexp(g);
        FP16 c = g.trace();
        byte[] t = MPIN256.mpin_hash(sha, c, U);
        for (int i = 0; i < 32; ++i) {
            SK[i] = t[i];
        }
        return 0;
    }

    public static void GET_Y(int sha, int TimeValue, byte[] xCID, byte[] Y) {
        byte[] h = MPIN256.hashit(sha, TimeValue, xCID, 70);
        BIG y = BIG.fromBytes(h);
        BIG q = new BIG(ROM.CURVE_Order);
        y.mod(q);
        y.toBytes(Y);
    }

    public static int CLIENT(int sha, int date, byte[] CLIENT_ID, RAND RNG, byte[] X, int pin, byte[] TOKEN, byte[] SEC, byte[] xID, byte[] xCID, byte[] PERMIT, int TimeValue, byte[] Y) {
        int rtn = 0;
        byte[] pID = date == 0 ? xID : xCID;
        rtn = MPIN256.CLIENT_1(sha, date, CLIENT_ID, RNG, X, pin, TOKEN, SEC, xID, xCID, PERMIT);
        if (rtn != 0) {
            return rtn;
        }
        MPIN256.GET_Y(sha, TimeValue, pID, Y);
        rtn = MPIN256.CLIENT_2(X, Y, SEC);
        if (rtn != 0) {
            return rtn;
        }
        return 0;
    }

    public static int SERVER(int sha, int date, byte[] HID, byte[] HTID, byte[] Y, byte[] SST, byte[] xID, byte[] xCID, byte[] SEC, byte[] E, byte[] F, byte[] CID, int TimeValue) {
        int rtn = 0;
        byte[] pID = date == 0 ? xID : xCID;
        MPIN256.SERVER_1(sha, date, CID, HID, HTID);
        MPIN256.GET_Y(sha, TimeValue, pID, Y);
        rtn = MPIN256.SERVER_2(date, HID, HTID, Y, SST, xID, xCID, SEC, E, F);
        if (rtn != 0) {
            return rtn;
        }
        return 0;
    }
}

